//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALPlayer.h
 * @brief		OpenAL vC[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXALPlayer_H_
#define INCG_IRIS_AXALPlayer_H_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "../../fnd/container/FndObserver.h"
#include "AXALTypes.h"

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// declare
class CALBuffer;

//======================================================================
// class
//! OpenALvC[NX
class CALPlayer : public fnd::CSubject<CALBuffer>
{
public:
	enum
	{
		VOLUME_MAX	= 4096,
	};
protected:
	AXALU32	m_Source;	//!< source

public:
	// RXgN^
	CALPlayer(void);
	// fXgN^
	~CALPlayer(void);

public:
	// 
	bool	Initialize(void);
	// 
	void	Release(void);

public:
	// obt@̓o^
	bool	StreamOut(CALBuffer* pBuffer, AXALBOOL isQueue);
	// obt@̐ݒ
	bool	SetBuffer(CALBuffer* pBuffer);
	// GL[
	bool	Enqueue(CALBuffer* pBuffer);
	// fL[
	bool	Dequeue(AXALSIZEI num, AXALU32* lpBuffers);
	// fL[
	bool	Dequeue(AXALSIZEI num);
	// Đ̊Jn(Đ͂ȂɂȂ)
	bool	Play(void);
	// 擪Đ̊Jn
	bool	Replay(void);
	// Đ̒~
	bool	Stop(void);
	// ꎞ~
	void	Pause(void);
	// ĊJ
	void	Continue(void);
	// ItZbgn_ɖ߂
	bool	Rewind(void);
	// Đǂ
	bool	IsPlay(void)	const;

public:
	// ~[gݒ
	void	Mute(AXALBOOL isMute);

public:
	// Đʒuݒ
	void	SetPosition(AXALF32 x, AXALF32 y, AXALF32 z);
	// {[̐ݒ
	void	SetVolume(AXALS32 volume);
	void	SetVolumeF(AXALF32 volume);
	// [vݒ
	void	SetLoop(AXALBOOL isLoop);
	// ̐ݒ
	void	SetReferenceDistance(AXALF32 distance);
	// ̍őlݒ
	void	SetMaxDistance(AXALF32 distance);
	// 
	void	SetRolloffFactor(AXALF32 rolloff);
	// sb`̐ݒ
	void	SetPitch(AXALF32 pitch);
	// ̐ݒ
	void	SetDirection(AXALF32 x, AXALF32 y, AXALF32 z);
	// R[̓p̐ݒ
	void	SetCornInnerAngle(AXALF32 angle);
	// R[̊Op̐ݒ
	void	SetCornOuterAngle(AXALF32 angle);
	// R[̊Op̃QCݒ
	void	SetCornOuterGain(AXALF32 gain);
	// Đʒu̐ݒ
	void	SetOffsetSec(AXALF32 sec);
	// Đʒu̐ݒ
	void	SetOffsetSample(AXALF32 sample);
	// Đʒu̐ݒ
	void	SetOffsetByte(AXALF32 byte);
	// Έʒuǂ̐ݒ
	void	SetSourceRelative(AXALBOOL relative);

public:
	// L[̐擾
	AXALS32	GetQueueBufferNum(void)	const;
	// Đς݃L[̐擾
	AXALS32	GetProcessedBufferNum(void)	const;

public:
	// \[X񋟂łGAIN̍ŏl擾
	AXALF32	GetMinGain(void)	const;
	// \[X񋟂łGAIN̍ől擾
	AXALF32	GetMaxGain(void)	const;

public:
	// Lȃ\[XIuWFNgǂ
	bool	IsValid(void)	const;

public:
	/// \[XIuWFNg̎擾
	AXALU32	GetSource(void)	{ return m_Source; }

public:
	// wrap
	void	seti (AXALENUM param, AXALS32 value);
	void	setf (AXALENUM param, AXALF32 value);
	void	set3i(AXALENUM param, AXALS32 v1, AXALS32 v2, AXALS32 v3);
	void	set3f(AXALENUM param, AXALF32 v1, AXALF32 v2, AXALF32 v3);
	void	setiv(AXALENUM param, const AXALS32* values);
	void	setfv(AXALENUM param, const AXALF32* values);

	void	geti (AXALENUM param, AXALS32* value)	const;
	void	getf (AXALENUM param, AXALF32* value)	const;
	void	get3i(AXALENUM param, AXALS32* v1, AXALS32* v2, AXALS32* v3)	const;
	void	get3f(AXALENUM param, AXALF32* v1, AXALF32* v2, AXALF32* v3)	const;
	void	getiv(AXALENUM param, AXALS32* values)	const;
	void	getfv(AXALENUM param, AXALF32* values)	const;
};

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#endif

#endif
