//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXMatrix.cpp
 * @brief		FBX SDK matrixt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FBXMatrix_CPP_

//======================================================================
// include
#include "FBXMatrix.h"

#ifdef _IRIS_SUPPORT_FBX
#include "../../../iris_debug.h"

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * KFbxMatrix -> KFbxXMatrix
 *
 ----------------------------------------------------------------------
 * @param [out]	pxmtx	= o̓}gbNX
 * @param [in]	pmtx	= ̓}gbNX
 * @return o̓}gbNX
*//***********************************************************************/
KFbxXMatrix*	MatrixToXMatrix(KFbxXMatrix* pxmtx, const KFbxMatrix* pmtx)
{
	IRIS_ASSERT( pxmtx != nullptr );
	IRIS_ASSERT( pmtx != nullptr );
	memcpy(pxmtx->mData, pmtx->mData, sizeof(pmtx->mData));
	return pxmtx;
}

/**********************************************************************//**
 *
 * KFbxXMatrix -> IrisFMtx44
 *
 ----------------------------------------------------------------------
 * @param [out]	pmtx	= o̓}gbNX
 * @param [in]	pxmtx	= ̓}gbNX
 * @return o̓}gbNX
*//***********************************************************************/
IrisFMtx44*	irisXMatrixToFMtx44(IrisFMtx44* pmtx, const KFbxXMatrix* pxmtx)
{
	IRIS_ASSERT( pxmtx != nullptr );
	IRIS_ASSERT( pmtx != nullptr );
	for( int y=0; y < 4; ++y )
	{
		for( int x=0; x < 4; ++x )
		{
			pmtx->m[y][x] = static_cast<f32>(pxmtx->mData[y].mData[x]);
		}
	}
	return pmtx;
}

}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif
