//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXMaterial.cpp
 * @brief		FBX SDK materialNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FBXMaterial_CPP_

//======================================================================
// include
#include "FBXMaterial.h"

#ifdef _IRIS_SUPPORT_FBX
#include "../FBXNode.h"
#include "FBXMesh.h"
#include "../../../iris_debug.h"

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFBXMaterial::CFBXMaterial(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	ptr	= }eA
*//***********************************************************************/
CFBXMaterial::CFBXMaterial(kfbx_ptr ptr)
: _Base(ptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= }eA
*//***********************************************************************/
CFBXMaterial::CFBXMaterial(CFBXMaterial& obj)
: _Base(obj)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFBXMaterial::~CFBXMaterial(void)
{
}

/**********************************************************************//**
 *
 * ArGg̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	rAmbient	= o
 * @return	
*//***********************************************************************/
bool CFBXMaterial::GetAmbient(fbxDouble3& rAmbient) const
{
	const KFbxSurfaceLambert* lambert = GetLambert();
	if( lambert == nullptr ) return false;
	rAmbient = lambert->GetAmbientColor().Get();
	return true;
}

/**********************************************************************//**
 *
 * fBt[Y̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	rDiffuse	= o
 * @return	
*//***********************************************************************/
bool CFBXMaterial::GetDiffuse(fbxDouble3& rDiffuse) const
{
	const KFbxSurfaceLambert* lambert = GetLambert();
	if( lambert == nullptr ) return false;
	rDiffuse = lambert->GetDiffuseColor().Get();
	return true;
}

/**********************************************************************//**
 *
 * G~bVu̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	rEmissive	= o
 * @return	
*//***********************************************************************/
bool CFBXMaterial::GetEmissive(fbxDouble3& rEmissive) const
{
	const KFbxSurfaceLambert* lambert = GetLambert();
	if( lambert == nullptr ) return false;
	rEmissive = lambert->GetEmissiveColor().Get();
	return true;
}

/**********************************************************************//**
 *
 * ov̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	rBump	= o
 * @return	
*//***********************************************************************/
bool CFBXMaterial::GetBump(fbxDouble3& rBump) const
{
	const KFbxSurfaceLambert* lambert = GetLambert();
	if( lambert == nullptr ) return false;
	rBump = lambert->GetBump().Get();
	return true;
}

/**********************************************************************//**
 *
 * x̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	rTrans	= o
 * @return	
*//***********************************************************************/
bool CFBXMaterial::GetTransparency(fbxDouble1& rTrans) const
{
	const KFbxSurfaceLambert* lambert = GetLambert();
	if( lambert == nullptr ) return false;
	rTrans = lambert->GetTransparencyFactor().Get();
	return true;
}

/**********************************************************************//**
 *
 * XyL̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	rSpecular	= o
 * @return	
*//***********************************************************************/
bool CFBXMaterial::GetSpecular(fbxDouble3& rSpecular) const
{
	const KFbxSurfacePhong* phong = GetPhong();
	if( phong == nullptr ) return false;
	rSpecular = phong->GetSpecularColor().Get();
	return true;
}

/**********************************************************************//**
 *
 * ̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	rShininess	= o
 * @return	
*//***********************************************************************/
bool CFBXMaterial::GetShininess(fbxDouble1& rShininess) const
{
	const KFbxSurfacePhong* phong = GetPhong();
	if( phong == nullptr ) return false;
	rShininess = phong->GetShininess().Get();
	return true;
}

/**********************************************************************//**
 *
 * ˂̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	rReflaction	= o
 * @return	
*//***********************************************************************/
bool CFBXMaterial::GetReflection(fbxDouble1& rReflection) const
{
	const KFbxSurfacePhong* phong = GetPhong();
	if( phong == nullptr ) return false;
	rReflection = phong->GetReflectionFactor().Get();
	return true;
}

/**********************************************************************//**
 *
 * LambertpĂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CFBXMaterial::IsLambert(void) const
{
	if( m_pKfbx == nullptr ) return false;
	return m_pKfbx->GetClassId().Is( KFbxSurfaceLambert::ClassId );
}

/**********************************************************************//**
 *
 * PhongpĂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CFBXMaterial::IsPhong(void) const
{
	if( m_pKfbx == nullptr ) return false;
	return m_pKfbx->GetClassId().Is( KFbxSurfacePhong::ClassId );
}

/**********************************************************************//**
 *
 * KFbxSurfaceLambert*擾
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
KFbxSurfaceLambert* CFBXMaterial::GetLambert(void) const
{
	if( m_pKfbx == nullptr ) return nullptr;
	if( !m_pKfbx->GetClassId().Is( KFbxSurfaceLambert::ClassId ) ) return nullptr;
	return static_cast<KFbxSurfaceLambert*>(m_pKfbx);
}

/**********************************************************************//**
 *
 * KFbxSurfacePhong*擾
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
KFbxSurfacePhong* CFBXMaterial::GetPhong(void) const
{
	if( m_pKfbx == nullptr ) return nullptr;
	if( !m_pKfbx->GetClassId().Is( KFbxSurfacePhong::ClassId ) ) return nullptr;
	return static_cast<KFbxSurfacePhong*>(m_pKfbx);
}

}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif
