//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXSkeleton.cpp
 * @brief		FBX SDK skeltonNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FBXSkeleton_CPP_

//======================================================================
// include
#include "FBXSkeleton.h"

#ifdef _IRIS_SUPPORT_FBX
#include "../FBXNode.h"
#include "FBXMesh.h"
#include "../../gl/GXGL.h"
#include "../../../iris_debug.h"

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFBXSkeleton::CFBXSkeleton(void)
: m_Time(0)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in] ptr	= FBXm[hNX|C^
*//***********************************************************************/
CFBXSkeleton::CFBXSkeleton(kfbx_ptr ptr)
: _Base(ptr)
, m_Time(0)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in] obj	= bVNX
*//***********************************************************************/
CFBXSkeleton::CFBXSkeleton(CFBXSkeleton& obj)
: _Base(obj.m_pKfbx)
, m_Time(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFBXSkeleton::~CFBXSkeleton(void)
{
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XVb
*//***********************************************************************/
void CFBXSkeleton::Update(xf32 time)
{
	KTime ktime;
	ktime.SetSecondDouble(static_cast<double>(XF_XF32_TO_F32(time)));
	m_Time += ktime;
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CFBXSkeleton::Draw(void)
{
	KFbxNode* pParent = GetParentNode();
	if( m_pKfbx->GetSkeletonType() == KFbxSkeleton::eLIMB_NODE
		&& pParent != nullptr
		&& pParent->GetNodeAttribute() != nullptr
		&& pParent->GetNodeAttribute()->GetAttributeType() == KFbxNodeAttribute::eSKELETON )
	{
		glLineWidth(2.0);

		glBegin(GL_LINE);

		glColor3f(1.0f, 0.0f, 0.0f);

		gl::gxglLoad3DMatrix();

		KFbxXMatrix pm = fbx::GetGlobalPosition(pParent, m_Time);
		KFbxXMatrix tm = GetGlobalPosition(m_Time);
		tm *= GetGeometricMatrix();

		glVertex3dv((GLdouble *)pm.GetT());
		glVertex3dv((GLdouble *)tm.GetT());

		gl::gxglUnload3DMatrix();

		glEnd();
	}
}


}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif
