//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXGlobalSettings.h
 * @brief		FBX SDK GlobalSettingsNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXGlobalSettings_H_
#define INCG_IRIS_FBXGlobalSettings_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_FBX
#include "../../../fnd/types/FndExecutor.h"
#include "../FBXObject.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/**
 * @ingroup	FBX
 * @brief	FBX SDK GlobalSettings
*/
class CFBXGlobalSettings : public IFBXObjectBase<KFbxGlobalSettings>
#if	FBXSDK_AT_LEAST(FBXSDK_VER_201102)
	, public IFBXObjectBase<KFbxGlobalCameraSettings>
#else
	, public IFBXObjectBase<KFbxGlobalCameraSettings>
	, public IFBXObjectBase<KFbxGlobalLightSettings>
	, public IFBXObjectBase<KFbxGlobalTimeSettings>
#endif
{
	typedef IFBXObjectBase<KFbxGlobalSettings>			_GlobalSettings;
#if	FBXSDK_AT_LEAST(FBXSDK_VER_201102)
	typedef IFBXObjectBase<KFbxGlobalSettings>		_Mybase;
	typedef _Mybase					_GlobalCamera;
	typedef _Mybase					_GlobalLight;
	typedef _Mybase					_GlobalTime;
	typedef KFbxGlobalSettings		kfbx_type;
	typedef KFbxGlobalSettings		*kfbx_ptr;
	typedef KFbxGlobalSettings		&kfbx_ref;

#else
	typedef IFBXObjectBase<KFbxGlobalCameraSettings>	_GlobalCamera;
	typedef IFBXObjectBase<KFbxGlobalLightSettings>		_GlobalLight;
	typedef IFBXObjectBase<KFbxGlobalTimeSettings>		_GlobalTime;
#endif

public:
public:
	// RXgN^
	CFBXGlobalSettings(void);
#if	FBXSDK_AT_LEAST(FBXSDK_VER_201002)
	// RXgN^
	CFBXGlobalSettings(kfbx_ptr ptr);
#endif
	// RXgN^
	CFBXGlobalSettings(KFbxScene* scene);
	// RXgN^
	CFBXGlobalSettings(CFBXGlobalSettings& obj);
	// fXgN^
	virtual ~CFBXGlobalSettings(void);

public:
	// ftHgJ擾
	KString				GetDefaultCameraName(void)	const;
	// ftHgJ擾
	KFbxCamera*			GetDefaultCamera(void)	const;
	// Ambient J[̐ݒ
	void				SetAmbientColor(KFbxColor pAmbientColor);
	// Ambient J[̎擾
	KFbxColor			GetAmbientColor(void)	const;
	// ^C}[[hݒ
	void				SetTimeMode(KTime::ETimeMode mode);
	// ^C}[[h擾
	KTime::ETimeMode	GetTimeMode(void)		const;
	// ftHg^CXp̐ݒ
	void				SetTimelineDefaultTimeSpan(const KTimeSpan& pTimeSpan);
	// ftHg^CXp̎擾
	void				GetTimelineDefaultTimeSpan(KTimeSpan& pTimeSpan)	const;
};


}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
