//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		dx_inchead.h
 * @brief		incheadt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_dx_inchead_H_
#define INCG_IRIS_dx_inchead_H_

//======================================================================
// include
#include "iris_inchead.h"
#include "dx_platform.h"
#include "dx_types.h"
#include "dx_internal.h"

//======================================================================
// define
// }N
#define DX_SAFE_DELETE( p )			do { if(p) { delete (p); (p) = nullptr; } } while(0)
#define DX_SAFE_DELETE_ARRAY( p )	do { if(p) { delete[] (p); (p) = nullptr; } } while(0)
#if 0
#define DX_SAFE_RELEASE( p )		do { if(p) { printf( __FILE__ "(%d) %s : %d\n", __LINE__, #p, safe_release(p) ); } } while(0)
#else
#define DX_SAFE_RELEASE( p )		safe_release(p)
#endif

namespace iris {
namespace dx 
{

template<typename TN>
ULONG	safe_release(TN& p)	{ ULONG r=0; if(p) { r = (p)->Release(); (p) = nullptr; } return r; } 

}	// end of namespace dx
}	// end of namespace iris

#endif

