//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		dx_platform.h
 * @brief		directx platform wb_
 *
 * @note		DirectX SDK Dec 2004ȑOɂ͖Ή
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_dx_platform_H_
#define INCG_IRIS_dx_platform_H_

//======================================================================
// include
#if	!defined(IRIS_WIN32_WCE)
#  include <dxsdkver.h>
#else
#  if IRIS_WCE_AT_LEAST(WIN_CE5)
#    include <d3dmx.h>
#  else
#  endif
#endif

//======================================================================
// define

#if defined(DIRECTINPUT_VERSION) && (DIRECTINPUT_VERSION != 0x0800)
#  undef DIRECTINPUT_VERSION
#endif
#if (!defined(DIRECTINPUT_VERSION) )
#  define DIRECTINPUT_VERSION 0x0800
#endif

// dxerr.libgp
#define _IRIS_DX_SUPPORT_DXERR

#if		defined(_DXSDK_PRODUCT_MAJOR)
#  define	DX_SDK_VERSION	_DXSDK_PRODUCT_MAJOR
#  if	!defined(_IRIS_DXSDK_TARGET_VER)
#    define	_IRIS_DXSDK_TARGET_VER	DX_SDK_VERSION
#  endif
#elif	defined(D3DM_SDK_VERSION)
#  define	DMX_SDK_VERSION	D3DM_SDK_VERSION
#endif

// Direct Music
#ifndef _IRIS_DX_SUPPORT_DXMUSIC
#  if		defined(DX_SDK_VERSION)
// DirectX SDK November 2007 Ŕp~
#    if	(_DXSDK_PRODUCT_MAJOR <= 9 && _DXSDK_PRODUCT_MINOR < 20)
#      define	_IRIS_DX_SUPPORT_DXMUSIC
#    endif
#  endif
#endif

#if		defined(D3DM_SDK_VERSION)
#  ifndef _IRIS_SUPPORT_DXMOBILE
#    define _IRIS_SUPPORT_DXMOBILE
#  endif
#  ifdef _IRIS_DX_SUPPORT_DXERR
#    undef _IRIS_DX_SUPPORT_DXERR
#  endif
#elif	!defined(_IRIS_DXSDK_TARGET_VER)
#  define _IRIS_NOT_SUPPORT_DIRECTX
#endif

//======================================================================
// include
#if !defined(_IRIS_NOT_SUPPORT_DIRECTX)
#  if !defined(_IRIS_SUPPORT_DXMOBILE)
#    if	(_IRIS_DXSDK_TARGET_VER == 9)
#      pragma warning (push)
#      pragma warning (disable:4820)
#      include <d3dx9.h>
#      pragma warning (pop)
#    elif	(_IRIS_DXSDK_TARGET_VER == 10)
#      include <d3dx10.h>
#    elif	(_IRIS_DXSDK_TARGET_VER == 11)
#      include <d3dx11.h>
#    endif
#    include <dinput.h>
#    define _IRIS_SUPPORT_DXSOUND
#  else
#    include "mobile/dmx_inchead.h"
#  endif
#endif

#if defined(_IRIS_SUPPORT_DXSOUND)
#  include <dsound.h>
#endif

#endif
