//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		dx_types.h
 * @brief		^` wb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_dx_types_H_
#define INCG_IRIS_dx_types_H_

//======================================================================
// include
#include "dx_platform.h"
#if		defined(DX_SDK_VERSION)
#  if	(_IRIS_DXSDK_TARGET_VER > 9)
//#    include "d3d9types.h"
#    include "d3dx9mesh.h"
#  endif
#endif

namespace iris {
namespace dx
{

//======================================================================
// struct
#if		defined(DX_SDK_VERSION)
#  if	(_IRIS_DXSDK_TARGET_VER > 9)
#  endif
#endif

//======================================================================
// typedef
#if		defined(DX_SDK_VERSION)
#  if		(_IRIS_DXSDK_TARGET_VER == 9)
	typedef LPDIRECT3D9						LPDIRECT3D;
	typedef LPDIRECT3DDEVICE9				LPDXDEVICE;
	typedef LPD3DXSPRITE					LPDXSPRITE;
	typedef IDirect3DBaseTexture9			IDXBASETEXTURE;
	typedef LPDIRECT3DTEXTURE9				LPDXTEXTURE;
	typedef LPDIRECT3DSURFACE9				LPDXSURFACE;
	typedef LPDIRECT3DSWAPCHAIN9			LPDXSWAPCHAIN;
	typedef LPDIRECT3DVERTEXBUFFER9			LPDXVERTEXBUFFER;
	typedef LPDIRECT3DINDEXBUFFER9			LPDXINDEXBUFFER;
	typedef LPDIRECT3DVERTEXSHADER9			LPDXVERTEXSHADER;
	typedef LPDIRECT3DPIXELSHADER9			LPDXPIXELSHADER;
	typedef LPD3DXFONT						LPDXFONT;
	typedef LPD3DXMESH						LPDXMESH;
	typedef D3DDEVTYPE						DXDEVTYPE;
	typedef D3DCAPS9						DXCAPS;
	typedef D3DPOOL							DXPOOL;
	typedef D3DFORMAT						DXFORMAT;
	typedef D3DVIEWPORT9					DXVIEWPORT;
	typedef D3DXIMAGE_INFO					DXIMAGE_INFO;
	typedef D3DXFONT_DESC					DXFONT_DESC;
	typedef D3DXFONT_DESCA					DXFONT_DESCA;
	typedef D3DXFONT_DESCW					DXFONT_DESCW;
	typedef D3DADAPTER_IDENTIFIER9			DXADAPTER_IDENTIFIER;
	typedef D3DPRIMITIVETYPE				DXPRIMITIVETYPE;
#  elif		(_IRIS_DXSDK_TARGET_VER == 10)
	typedef void							*LPDIRECT3D;
	typedef ID3D10Device					*LPDXDEVICE;
	typedef ID3DX10Sprite					*LPDXSPRITE;
	typedef ID3D10Resource					IDXBASETEXTURE;
	typedef ID3D10Texture2D					*LPDXTEXTURE;
	typedef ID3D10Buffer					*LPDXSURFACE;
	typedef IDXGISwapChain					*LPDXSWAPCHAIN;
	typedef ID3D10Buffer					*LPDXVERTEXBUFFER;
	typedef ID3D10Buffer					*LPDXINDEXBUFFER;
	typedef ID3DX10Font						*LPDXFONT;
	typedef ID3DX10Mesh						*LPDXMESH;
	typedef D3D10_DRIVER_TYPE				DXDEVTYPE;
	typedef D3D10_VIEWPORT					DXVIEWPORT;
	typedef D3DX10_IMAGE_INFO				DXIMAGE_INFO;
	typedef D3DX10_FONT_DESC				DXFONT_DESC;
	typedef D3DX10_FONT_DESCA				DXFONT_DESCA;
	typedef D3DX10_FONT_DESCW				DXFONT_DESCW;
#  elif		(_IRIS_DXSDK_TARGET_VER == 11)
#  endif
	typedef const LPDXSPRITE				LPCDXSPRITE;
	typedef D3DVECTOR						DXVECTOR;
	typedef f32								DXVALUE;
	typedef D3DLIGHTTYPE					DXLIGHTTYPE;
	typedef D3DLIGHT9						DXLIGHT;
	typedef D3DMATERIAL9					DXMATERIAL;
	typedef D3DLOCKED_RECT					DXLOCKED_RECT;
	typedef D3DPRESENT_PARAMETERS			DXPRESENT_PARAMETERS;
#elif	defined(_IRIS_SUPPORT_DXMOBILE)
	typedef LPDIRECT3DMOBILE				LPDIRECT3D;
	typedef LPDIRECT3DMOBILEDEVICE			LPDXDEVICE;
	typedef IDirect3DMobileBaseTexture		IDXBASETEXTURE;
	typedef LPDIRECT3DMOBILETEXTURE			LPDXTEXTURE;
	typedef LPDIRECT3DMOBILESURFACE			LPDXSURFACE;
	typedef LPDIRECT3DMOBILESWAPCHAIN		LPDXSWAPCHAIN;
	typedef LPDIRECT3DMOBILEVERTEXBUFFER	LPDXVERTEXBUFFER;
	typedef LPDIRECT3DMOBILEINDEXBUFFER		LPDXINDEXBUFFER;
	typedef D3DMDEVTYPE						DXDEVTYPE;
	typedef D3DMCAPS						DXCAPS;
	typedef D3DMPOOL						DXPOOL;
	typedef D3DMFORMAT						DXFORMAT;
	typedef D3DMLIGHT						DXLIGHT;
	typedef D3DMMATERIAL					DXMATERIAL;
	typedef D3DMVIEWPORT					DXVIEWPORT;
	typedef D3DMXIMAGE_INFO					DXIMAGE_INFO;
	typedef D3DMVECTOR						DXVECTOR;
	typedef D3DMVALUE						DXVALUE;
	typedef D3DMLIGHTTYPE					DXLIGHTTYPE;
	typedef D3DMLOCKED_RECT					DXLOCKED_RECT;
	typedef D3DMPRESENT_PARAMETERS			DXPRESENT_PARAMETERS;
	typedef D3DMADAPTER_IDENTIFIER			DXADAPTER_IDENTIFIER;
	typedef D3DMPRIMITIVETYPE				DXPRIMITIVETYPE;
#endif

typedef const LPDIRECT3D				LPCDIRECT3D;
typedef const LPDXDEVICE				LPCDXDEVICE;
typedef DXPRESENT_PARAMETERS			*LPDXPRESENT_PARAMETERS;
typedef const DXPRESENT_PARAMETERS		*LPCDXPRESENT_PARAMETERS;
typedef DXLIGHT							*LPDXLIGHT;
typedef const DXLIGHT					*LPCDXLIGHT;
typedef DXMATERIAL						*LPDXMATERIAL;
typedef const DXMATERIAL				*LPCDXMATERIAL;


// Direct Sound
#if defined(_IRIS_SUPPORT_DXSOUND)
#if		defined(DIRECTSOUND_VERSION)
#  if	(DIRECTSOUND_VERSION >= 0x0800)
     typedef LPDIRECTSOUND8				LPDXSOUND;
	 typedef LPDIRECTSOUNDBUFFER8		LPDXSOUNDBUFFER;
#    define  IID_DXSOUNDBUFFER			IID_IDirectSoundBuffer8
#    define  DXSoundCreate				DirectSoundCreate8
#  else
     typedef LPDIRECTSOUND				LPDXSOUND;
	 typedef LPDIRECTSOUNDBUFFER		LPDXSOUNDBUFFER;
#    define  IID_DXSOUNDBUFFER			IID_IDirectSoundBuffer
#    define  DXSoundCreate				DirectSoundCreate
#  endif
#else
   typedef LPDIRECTSOUND				LPDXSOUND;
   typedef LPDIRECTSOUNDBUFFER			LPDXSOUNDBUFFER;
#  define  IID_DXSOUNDBUFFER			IID_IDirectSoundBuffer
#  define  DXSoundCreate				DirectSoundCreate
#endif
#endif

}	// end of namespace dx
}	// end of namespace iris

#endif
