//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXDeviceObject.h
 * @brief		DirectXfoCXIuWF̃x[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXDeviceObject_H_
#define INCG_IRIS_DXDeviceObject_H_

//======================================================================
// include
#include "../dx_inchead.h"
#include "fnd/container/FndWrapObject.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**
 * @brief	foCXIuWFNgC^[tF[X
 * @tparam	TN	= foCXIuWFNg
*/
template<typename TN>
class CDXDeviceObject : public fnd::CWrapObject< TN >
{
	typedef TN								_Myobject;
	typedef fnd::CWrapObject<_Myobject>		_Mybase;
	typedef CDXDeviceObject<TN>				_Myt;
public:
	/**
	 * @brief	RXgN^
	*/
	CDXDeviceObject(void) {}
	/**
	 * @brief	RXgN^
	*/
	explicit CDXDeviceObject(const _Myobject object) : _Mybase(object)
	{
	}
	/**
	 * @brief	Rs[RXgN^
	*/
	CDXDeviceObject(const _Myt& obj) : _Mybase(obj)
	{
		attach(m_object);
	}

	/**
	 * @brief	fXgN^
	*/
	~CDXDeviceObject(void)
	{
		release();
	}

public:
	void				attach(const _Myobject obj)
	{
		release();
		m_object = obj;
		if( m_object != nullptr ) m_object->AddRef();
	}

	ULONG				release(void)
	{
		ULONG ref = 0;
		if( m_object != nullptr ) 
		{
			ref = m_object->Release();
			m_object = nullptr;
		}
		return ref;
	}


public:
	_Myt&				operator =	(const _Myobject obj)		{ m_object = obj; return *this; }		// ̃|C^̏ꍇ̓JEgAbvȂ
	_Myt&				operator =	(const _Myt& obj)			{ attach(obj.m_object); return *this; }
#if	defined(_IRIS_HAS_NULLPTR_T)
	_Myt&				operator =	(const nullptr_t& null)		{ release(); return *this; }
#endif
};

/**  */
template<typename TN>
ULONG	safe_release(CDXDeviceObject<TN>& p)	{ return p.release(); } 

}	// end of namespace dx
}	// end of namespace iris

#endif	
