//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXRenderState.h
 * @brief		_OXe[gNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXRenderState_H_
#define INCG_IRIS_DXRenderState_H_

//======================================================================
// include
#include "fnd/utility/FndFlag.h"
#include "fnd/utility/FndRefCounter.h"
#include "../DXObject.h"
#include "iris_debug.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/// _OXe[gp[^NX
class CDXRenderStateParam : public IIrisObject
{
public:
	typedef enum
	{
		LIGHT_NUM	= 4,			//!< ǗĂ郉Cg
	} INFOMATION;

	typedef enum
	{
		RS_FOGENABLE		= 0x00000001,		//!< D3DRS_FOGENABLE
		RS_ZWRITEENABLE		= 0x00000002,		//!< D3DRS_ZWRITEENABLE
		RS_ALPHATESTENABLE	= 0x00000004,		//!< D3DRS_ALPHATESTENABLE
		RS_ALPHABLENDENABLE	= 0x00000008,		//!< D3DRS_ALPHABLENDENABLE

		RS_DEFAULT			= 0xffffffff,		//!< ftHg
	} RENDERSTATE;
protected:
	BOOL		m_LightEnable[LIGHT_NUM];	//!< Cgon/off
	DWORD		m_Ambient;					//!< ArGg
	u8			m_CullMode;					//!< JOݒ
	u8			m_ZEnable;					//!< Z obt@
	u8			m_ColorMask;				//!< J[obt@ւ̏
	u8			m_BlendOp;					//!< uhIy[^
	u8			m_BlendSrc;					//!< D3DRS_SRCBLEND
	u8			m_BlendDst;					//!< D3DRS_DSTBLEND

	fnd::CFlag	m_Flags;					//!< tO

public:
	// RXgN^
	CDXRenderStateParam(void);
public:
	// ݂̃_OXe[g擾
	bool	GetCurrentRenderState(LPDXDEVICE pDevice);
	// ݂̃_OXe[gɐݒ
	bool	SetCurrentRenderState(LPDXDEVICE pDevice);

public:
	/// Cgon/off擾
	BOOL			GetLightEnable(int idx)	const	{ IRIS_ASSERT( idx >= 0 && idx < LIGHT_NUM ); return m_LightEnable[idx]; }
	/// ArGgl̎擾
	DWORD			GetAmbient(void)		const	{ return m_Ambient; }
	/// JOݒ̎擾
	u8				GetCullMode(void)		const	{ return m_CullMode; }
	/// Zobt@ݒ̎擾
	u8				GetZBufferMode(void)	const	{ return m_ZEnable; }
	/// J[obt@ݒ̎擾
	u8				GetColorBufferMode(void) const	{ return m_ColorMask; }
	/// uhIy[^̎擾
	u8				GetBlendOp(void)		const	{ return m_BlendOp; }
	/// D3DRS_SRCBLEND̎擾
	u8				GetBlendSrc(void)		const	{ return m_BlendSrc; }
	/// D3DRS_DSTBLEND̎擾
	u8				GetBlendDst(void)		const	{ return m_BlendDst; }

	/// tO̎擾
	fnd::CFlag&			GetFlag(void)					{ return m_Flags; }
	const fnd::CFlag&	GetFlag(void)		const		{ return m_Flags; }

public:
	/// Cgon/offݒ
	void			SetLightEnable(int idx, BOOL bEnable)	{ IRIS_ASSERT( idx >= 0 && idx < LIGHT_NUM ); m_LightEnable[idx] = bEnable; }
	/// ArGgl̐ݒ
	void			SetAmbient(DWORD ambient)	{ m_Ambient = ambient; }
	/// JOݒ̐ݒ
	void			SetCullMode(u8 mode)		{ m_CullMode = mode; }
	/// Zobt@ݒ̐ݒ
	void			SetZBufferMode(u8 mode)		{ m_ZEnable = mode; }
	/// J[obt@ݒ̐ݒ
	void			SetColorBufferMode(u8 mode)	{ m_ColorMask = mode; }
	/// uhIy[^̐ݒ
	void			SetBlendOp(u8 op)			{ m_BlendOp = op; }
	/// D3DRS_SRCBLEND̐ݒ
	void			SetBlendSrc(u8 src)			{ m_BlendSrc = src; }
	/// D3DRS_DSTBLEND̐ݒ
	void			SetBlendDst(u8 dst)			{ m_BlendDst = dst; }
};

/// _OXe[gp[^XgANX
class CDXRenderStateParamStore : public fnd::CRefCounter
{
private:
	CDXRenderStateParam		m_Param;	//!< p[^
public:
	// RXgN^
	CDXRenderStateParamStore(void);
public:
	// _OXe[gޔ
	bool	Push(LPDXDEVICE pDevice);
	// _OXe[g𕜋A
	bool	Pop(LPDXDEVICE pDevice);

public:
	/// p[^̎擾
	const	CDXRenderStateParam&	GetParam(void) const	{ return m_Param; }
};

/// _OXe[gNX
class CDXRenderState : public fnd::CFlag
{
public:
	typedef enum
	{
		RS_LIGHTING				= 0x00000001,		//!< Cg
		RS_FOG					= 0x00000002,		//!< tHO
		RS_CULL_FACE			= 0x00000004,		//!< tFCXJO
		RS_FLIP_FACE			= 0x00000008,		//!< tFCXʂ̃tbv
		RS_DEPTH_TEST			= 0x00000010,		//!< [xobt@
		RS_DEPTH_MASK			= 0x00000020,		//!< [xobt@ւ̏
		RS_ALPHA_TEST			= 0x00000040,		//!< At@eXg
		RS_ALPHA_MASK			= 0x00000080,		//!< At@l̏
		RS_BLEND				= 0x00000100,		//!< At@uh

		RS_OUTPUT_BLEND_FUNC	= 0x00010000,		//!< uh

		RS_FLUSH				= 0x80000000,		//!< 

		RS_DEFAULT				= 0x7fffffff,		//!< ftHg
	} RENDERSTATE;
public:
	// RXgN^
	CDXRenderState(void);

public:
	// K
	bool	Activate(LPDXDEVICE pDevice, const CDXRenderStateParam* pParam);
	bool	Activate(LPDXDEVICE pDevice);
	// K̊Jn
	bool	Begin(LPDXDEVICE pDevice);
	// K̏I
	bool	End(LPDXDEVICE pDevice);

public:
	// _OXe[gޔ
	static	bool	Push(LPDXDEVICE pDevice);
	// _OXe[g𕜋A
	static	bool	Pop(LPDXDEVICE pDevice);
	// ÕtONA
	static	void	PrevClear(void);
};


}	// end of namespace dx
}	// end of namespace iris

#endif
