//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXGdiFont.h
 * @brief		directX GDI gptHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXGdiFont_H_
#define INCG_IRIS_DXGdiFont_H_

//======================================================================
// include
#include "DXFontTexture.h"

namespace iris {
namespace dx
{

//======================================================================
//! Gdi tHgNX
class CDXGdiFont : public IDXFontTexture
{
protected:
	HFONT		m_hFont;		//!< tHg
	HDC			m_hDC;			//!< tHgɊ֘AtꂽDC

	bool		m_bAntialias;	//!< A`GCAX

public:
	// RXgN^
	CDXGdiFont(void);
	// fXgN^
	virtual ~CDXGdiFont(void);
public:
	// eNX`쐬
	virtual bool	Create(UINT width, UINT height);
	// 
	virtual void	Release(void);

public:
	// ̈̃NA
	virtual void	Clear(void);

	// 񏑂݁ieNX`ɕށj
	virtual bool	TextOutA(int x, int y, LPCSTR  pString, size_t size);
	virtual bool	TextOutW(int x, int y, LPCWSTR pString, size_t size);

public:
	// tHg쐬
	virtual	bool	CreateFontA(int height, int width, int weight, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCSTR  pszFaceName)
	{
		return CreateFontA( height, width, 0, 0, weight, bItalic, bUnderline, bStrikeOut
			, iCharSet, iOutputPrecision, CLIP_DEFAULT_PRECIS, iQuality, iPitchAndFamily, pszFaceName );
	}
	virtual	bool	CreateFontW(int height, int width, int weight, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCWSTR pszFaceName)
	{
		return CreateFontW( height, width, 0, 0, weight, bItalic, bUnderline, bStrikeOut
			, iCharSet, iOutputPrecision, CLIP_DEFAULT_PRECIS, iQuality, iPitchAndFamily, pszFaceName );
	}
	bool			CreateFontA(int height, int width, int escapement, int orientation, int weight
						  , DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
						  , DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
						  , DWORD iQuality, DWORD iPitchAndFamily, LPCSTR pszFaceName
						);
	bool			CreateFontW(int height, int width, int escapement, int orientation, int weight
						  , DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
						  , DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
						  , DWORD iQuality, DWORD iPitchAndFamily, LPCWSTR pszFaceName
						);
	bool			CreateFontIndirectA( const LOGFONTA* lplf );
	bool			CreateFontIndirectW( const LOGFONTW* lplf );

	virtual bool	CreateFontFromInfoA( const CDXFontInfo* lpInfo ) { LOGFONTA lf; lpInfo->GetLogFontA(lf); return CreateFontIndirectA(&lf); }
	virtual bool	CreateFontFromInfoW( const CDXFontInfo* lpInfo ) { LOGFONTW lf; lpInfo->GetLogFontW(lf); return CreateFontIndirectW(&lf); }

	// tHg폜
	virtual void	DeleteFont(void);

	// tHgݒ
	void	SetFont(HFONT hFont)			{ m_hFont = hFont; }
	// tHg擾
	HFONT	GetFont(void)	const			{ return m_hFont; }

public:
	// set, get
	void			SetAntialias(bool antialias)	{ m_bAntialias = antialias; }
	bool			GetAntialias(void)	const		{ return m_bAntialias; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif
