//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXGlyphFont.cpp
 * @brief		directX glyph gptHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXGlyphFont_CPP_

//======================================================================
// include
#include "DXGlyphFont.h"
#include "../DXDevice.h"
#include "../../DXError.h"

#include "../../../win/debug/WXDebug.h"
#include "../../../win/debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace dx
{

#ifndef GGO_GRAY8_BITMAP
#  define GGO_GRAY8_BITMAP	6
#endif

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXGlyphFont::CDXGlyphFont(void)
: m_FontFormat(GGO_GRAY8_BITMAP)
, m_Scale(1.0f, 1.0f)
, m_Rotate(0.0f)
, m_bOver(false)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	// 
	m_Mat.eM11.fract = 0;
	m_Mat.eM11.value = 1;
	m_Mat.eM12.fract = 0;
	m_Mat.eM12.value = 0;
	m_Mat.eM21.fract = 0;
	m_Mat.eM21.value = 0;
	m_Mat.eM22.fract = 0;
	m_Mat.eM22.value = 1;
#endif
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXGlyphFont::~CDXGlyphFont(void)
{
	Release();
}

/**********************************************************************//**
 *
 * ̈̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	width	= 
 * @param [in]	height	= 
 * @return	
*//***********************************************************************/
bool CDXGlyphFont::Create(UINT width, UINT height)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return CDXTexture::CreateTexture(width, height, 1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED);
#else
	return CDXGdiFont::Create(width, height);
#endif
}

/**********************************************************************//**
 *
 * ̈̃NA
 * 
*//***********************************************************************/
void CDXGlyphFont::Clear(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( m_pTexture == nullptr ) return;
	DXLOCKED_RECT TexRect;
	HRESULT hr = m_pTexture->LockRect(0, &TexRect, nullptr, 0);
	if( FAILED( hr ) ) { DX_ERROR( hr ); return; }

	memset(TexRect.pBits, 0x00, TexRect.Pitch*m_Height);
	m_pTexture->UnlockRect( 0 );
#else
	CDXGdiFont::Clear();
#endif
}

/**********************************************************************//**
 *
 * `
 * 
 ----------------------------------------------------------------------
 * @param [in]	x, y			= `ʒu
 * @param [in]	pString			= 
 * @param [in]	size			= 
 * @param [in]	over			= ㏑tO
 * @param [in]	lack			= ̋
 * @param [in]	proportional	= v|[Vi
 * @return	
*//***********************************************************************/
bool CDXGlyphFont::TextOutA(int x, int y, LPCSTR  pString, size_t size, bool over, bool lack, bool proportional)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( m_hFont == nullptr )
	{
		IRIS_WARNING( "HFONT is nullptr." );
		return false;
	}
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr || m_pTexture == nullptr ) return false;
	DXLOCKED_RECT TexRect;
	HRESULT hr = m_pTexture->LockRect(0, &TexRect, nullptr, 0);
	if( FAILED( hr ) ) return false;

	HWND hWnd = GetPresent()->hDeviceWindow;
	m_hDC = GetDC(hWnd);
	HFONT oldFont = (HFONT)SelectObject(m_hDC, m_hFont);

	// tHg擾
	TEXTMETRIC tm;
	GetTextMetrics(m_hDC, &tm);
	int height = tm.tmHeight + tm.tmExternalLeading * 2;

	LPCSTR c = pString;
	LPCSTR e = c+size;
	int ox = x;
	int cx = x;
	int cy = y;
	for( ; c < e; )
	{
		UINT code;
		// }`oCg̏ꍇA
		// 1oCg̃R[h1oCgڂUINTϊA
		// 2oCg̃R[h[擱R[h]*256 + [R[h]ł
		c += mbtocode(c,code);

		switch( code )
		{
		case '\0':
			goto textout_end;
			break;
		case '\n':
			cx = ox;
			cy += (int)(m_Scale.y * height);
			break;
		default:
			switch( DrawCharA(cx, cy, &cx, &cy, code, TexRect, tm, m_FontColor
				, over, m_bAntialias, lack, proportional) )
			{
			case DRAWCHAR_LACK:
				break;
			case DRAWCHAR_OUTBOUND:
				// ݂̏Ɏs
				if( 0 )
				{
					// s
					cx = ox;
					cy += (int)(m_Scale.y * height);
					DrawCharA(cx, cy, &cx, &cy, code, TexRect, tm, m_FontColor
						, over, m_bAntialias, lack, proportional);
				}
				break;
			case DRAWCHAR_ERR_OUTBOUND:
				// ̈Ôߏ߂Ȃ
				goto textout_end;
				break;
			}
			break;
		}
	}

textout_end:
	SelectObject(m_hDC, oldFont);
	ReleaseDC(hWnd, m_hDC);
	m_hDC = nullptr;

   m_pTexture->UnlockRect( 0 );
   return true;
#else
	IRIS_UNUSED_VARIABLE(over);
	IRIS_UNUSED_VARIABLE(lack);
	IRIS_UNUSED_VARIABLE(proportional);
	return CDXGdiFont::TextOutA(x, y, pString, size);
#endif
}
/// CDXGlyphFont::TextOutA Q
bool CDXGlyphFont::TextOutW(int x, int y, LPCWSTR pString, size_t size, bool over, bool lack, bool proportional)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( m_hFont == nullptr )
	{
		IRIS_WARNING( "HFONT is nullptr." );
		return false;
	}
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr || m_pTexture == nullptr ) return false;
	DXLOCKED_RECT TexRect;
	HRESULT hr = m_pTexture->LockRect(0, &TexRect, nullptr, 0);
	if( FAILED( hr ) ) return false;

	HWND hWnd = GetPresent()->hDeviceWindow;
	m_hDC = GetDC(hWnd);
	HFONT oldFont = (HFONT)SelectObject(m_hDC, m_hFont);

	// tHg擾
	TEXTMETRIC tm;
	GetTextMetrics(m_hDC, &tm);
	int height = tm.tmHeight + tm.tmExternalLeading * 2;

	LPCWSTR c = pString;
	LPCWSTR e = c+size;
	int ox = x;
	int cx = x;
	int cy = y;
	for( ; c < e; ++c )
	{
		UINT code = *c;

		switch( code )
		{
		case L'\0':
			goto textout_end;
			break;
		case L'\n':
			cx = ox;
			cy += (int)(m_Scale.y * height);
			break;
		default:
			switch( DrawCharW(cx, cy, &cx, &cy, code, TexRect, tm, m_FontColor
				, over, m_bAntialias, lack, proportional) )
			{
			case DRAWCHAR_LACK:
				break;
			case DRAWCHAR_OUTBOUND:
				// ݂̏Ɏs
				if( 0 )
				{
					// s
					cx = ox;
					cy += (int)(m_Scale.y * height);
					DrawCharW(cx, cy, &cx, &cy, code, TexRect, tm, m_FontColor
						, over, m_bAntialias, lack, proportional);
				}
				break;
			case DRAWCHAR_ERR_OUTBOUND:
				// ̈Ôߏ߂Ȃ
				goto textout_end;
				break;
			}
			break;
		}
	}

textout_end:
	SelectObject(m_hDC, oldFont);
	ReleaseDC(hWnd, m_hDC);
	m_hDC = nullptr;

   m_pTexture->UnlockRect( 0 );
   return true;
#else
	IRIS_UNUSED_VARIABLE(over);
	IRIS_UNUSED_VARIABLE(lack);
	IRIS_UNUSED_VARIABLE(proportional);
	return CDXGdiFont::TextOutW(x, y, pString, size);
#endif
}

#if	!defined(_IRIS_SUPPORT_DXMOBILE)
/**********************************************************************//**
 *
 * P`
 * 
 ----------------------------------------------------------------------
 * @param [in]	x,y			= `ʒu
 * @param [in]	nx,ny		= XVʒu
 * @param [in]	code		= R[h
 * @param [in]	rTexRect	= 
 * @param [in]	rtm			= 
 * @param [in]	color		= F
 * @param [in]	over		= ㏑tO
 * @param [in]	antialias	= A`GCAX
 * @param [in]	lack		= ̋
 * @param [in]	proportional= v|[VitHg
 * @return	G[R[h
*//***********************************************************************/
int CDXGlyphFont::DrawCharA(int x, int y, int* nx, int* ny, UINT code, DXLOCKED_RECT& rTexRect, TEXTMETRIC& rtm
						, intr::DXICOLOR color
						, bool over, bool antialias, bool lack, bool proportional)
{
	int ret = DRAWCHAR_OK;
	GLYPHMETRICS	gm;
	LPBYTE			buf;	// tHgobt@
	int				AlphaLevel = 255;
	UINT			format = GGO_BITMAP;
	if( antialias )
	{
		format = m_FontFormat;
		switch(format)
		{
		case GGO_GRAY2_BITMAP:
			AlphaLevel = 4;
			break;
		case GGO_GRAY4_BITMAP:
			AlphaLevel = 16;
			break;
		case GGO_GRAY8_BITMAP:
			AlphaLevel = 64;
			break;
		}
	}
	// tHgobt@擾
	DWORD DataSize = GetFontBufferA(code, &gm, &buf, &m_Mat, format);
	if( DataSize == 0 ) return DRAWCHAR_ERR_FAILED;
	ret = OnDrawChar(gm, buf, DataSize, AlphaLevel
		, x, y, nx, ny, code, rTexRect, rtm
		, color, over, antialias, lack, proportional);
	DX_SAFE_DELETE_ARRAY( buf );
	return ret;
}
/// CDXGlyphFont::DrawCharA Q
int CDXGlyphFont::DrawCharW(int x, int y, int* nx, int* ny, UINT code, DXLOCKED_RECT& rTexRect, TEXTMETRIC& rtm
						, intr::DXICOLOR color
						, bool over, bool antialias, bool lack, bool proportional)
{
	int ret = DRAWCHAR_OK;
	GLYPHMETRICS	gm;
	LPBYTE			buf;	// tHgobt@
	int				AlphaLevel = 255;
	UINT			format = GGO_BITMAP;
	if( antialias )
	{
		format = m_FontFormat;
		switch(format)
		{
		case GGO_GRAY2_BITMAP:
			AlphaLevel = 4;
			break;
		case GGO_GRAY4_BITMAP:
			AlphaLevel = 16;
			break;
		case GGO_GRAY8_BITMAP:
			AlphaLevel = 64;
			break;
		}
	}
	// tHgobt@擾
	DWORD DataSize = GetFontBufferW(code, &gm, &buf, &m_Mat, format);
	if( DataSize == 0 ) return DRAWCHAR_ERR_FAILED;
	ret = OnDrawChar(gm, buf, DataSize, AlphaLevel
		, x, y, nx, ny, code, rTexRect, rtm
		, color, over, antialias, lack, proportional);
	DX_SAFE_DELETE_ARRAY( buf );
	return ret;
}

/**********************************************************************//**
 *
 * P`
 * 
 ----------------------------------------------------------------------
 * @param [in]	gm			= Ot
 * @param [in]	buf			= obt@
 * @param [in]	size		= f[^TCY
 * @param [in]	alpah_level	= At@x
 * @param [in]	x,y			= `ʒu
 * @param [in]	nx,ny		= XVʒu
 * @param [in]	code		= R[h
 * @param [in]	rTexRect	= 
 * @param [in]	rtm			= 
 * @param [in]	color		= F
 * @param [in]	over		= ㏑tO
 * @param [in]	antialias	= A`GCAX
 * @param [in]	lack		= ̋
 * @param [in]	proportional= v|[VitHg
 * @return	G[R[h
*//***********************************************************************/
int CDXGlyphFont::OnDrawChar(GLYPHMETRICS& gm, LPBYTE buf, DWORD size, int alpha_level
					    , int x, int y, int* nx, int* ny, UINT code, DXLOCKED_RECT& rTexRect, TEXTMETRIC& rtm
						, intr::DXICOLOR color
						, bool over, bool antialias, bool lack, bool proportional)
{
	int ret = DRAWCHAR_OK;
	ABC				abc;
	if( (UINT)y >= m_Height ) return DRAWCHAR_ERR_OUTBOUND;
	if( (UINT)x >= m_Width  ) return DRAWCHAR_OUTBOUND;

	// TCY擾
	const UINT BoxX = gm.gmBlackBoxX;
	const UINT BoxY = gm.gmBlackBoxY;
	int dw = BoxX;
	int dh = BoxY;
	if(x + dw < 0 )					{ return DRAWCHAR_ERR_OUTBOUND; }
	if(y + dh < 0 )					{ return DRAWCHAR_ERR_OUTBOUND; }
	if((UINT)(x + dw) > m_Width )	{ dw = m_Width  - x; ret = DRAWCHAR_LACK; }
	if((UINT)(y + dh) > m_Height)	{ dh = m_Height - y; ret = DRAWCHAR_LACK; }
	if(x < 0)						{ x = 0; dw += x; ret = DRAWCHAR_LACK; }
	if(y < 0)						{ y = 0; dh += y; ret = DRAWCHAR_LACK; }
	if( lack == false && ret == DRAWCHAR_LACK ) { return DRAWCHAR_OUTBOUND; }

	// tHg擾
	GetCharABCWidths(m_hDC, code, code, &abc);
	// 
	LPBYTE p2 = buf;
	// `T[tFCX̃|C^
	LPDWORD p1 = (LPDWORD)rTexRect.pBits;
	DWORD pitch = rTexRect.Pitch / 4u;

	// `ʒui߂
	int a = (abc.abcA)?(2):(0);	//̍̑傫
//	int b = abc.abcB;			//̑傫
	int c = (abc.abcC)?(2):(0);	//̉Ȇ傫
	int width = proportional ? (int)(m_Scale.x * (a + c) + BoxX) : rtm.tmMaxCharWidth;
	int rx = proportional ? (int)(m_Scale.x * a) : abc.abcA;
	int height = rtm.tmHeight + rtm.tmExternalLeading * 2;
	if( (UINT)(x + width ) > m_Width ) width  = m_Width  - x;
	if( (UINT)(y + height) > m_Height) height = m_Height - y;

	if( !over )
	{
		if( width > 0 )
		{
			LPDWORD pt = (LPDWORD)rTexRect.pBits;
			pt += x + y * pitch;
			for( int y = 0; y <  height; ++y )
			{
				memset(pt, 0x00, width * sizeof(DWORD));
				pt += pitch;
			}
		}
	}

	int sy = rtm.tmAscent - gm.gmptGlyphOrigin.y;
	int add = x + (y + sy) * pitch + rx;
	if(add < 0)	add = 0;
	p1 += add;

	// ]
	// tHgsb`
	DWORD fontPitch;
	if(antialias)
	{
		fontPitch = (size / BoxY) & ~0x03;
		for( int ty = 0; ty < dh; ++ty )
		{
			LPDWORD pt = p1;
			for ( int tx = 0; tx < dw; ++tx, ++pt )
			{
				DWORD a1 = (DWORD)( (p2[tx]*255/alpha_level) * (color>>24) / 255) << 24;
				DWORD dwColor = (color&0x00FFFFFF) | a1;
				if((dwColor & 0xff000000) != 0x00000000)
				{
					*pt = dwColor; 
				}
			}
			p1 += pitch;
			p2 += fontPitch;
		}
	}
	else
	{
		LPBYTE lpCurrent; // ݃`FbNBYTEʒu
		fontPitch = ( ( BoxX + 0x1f ) & ~0x1f ) / 8; // 1s̃oCg
		BYTE byMask; // rbg}XN

		for(int ty = 0; ty < dh; ++ty)
		{
			byMask = 0x80; // }XNl
			lpCurrent = p2; // ݈ʒus
			LPDWORD pt = p1;
			for(int tx = 0; tx < dw; ++tx, ++pt )
			{
				if( !byMask ) 
				{
					byMask = 0x80;
					++lpCurrent;
				}
				if( *lpCurrent & byMask )
				{
					DWORD dwColor = color;
					if((dwColor & 0xff000000) != 0x00000000)
					{
						*pt = dwColor; 
					}
				}
				byMask >>= 1;
			}
			p2 += fontPitch;
			p1 += pitch; 
		}
	}

	if( nx != nullptr ) *nx = x + width;
	if( ny != nullptr ) *ny = y;
	return ret;
}

/**********************************************************************//**
 *
 * tHgobt@̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	code		= R[h
 * @param [in]	pgm			= 
 * @param [in]	lpData		= o̓obt@
 * @param [in]	mat2		= tHg}gbNX
 * @param [in]	format		= tH[}bg
 * @return	TCY
*//***********************************************************************/
DWORD CDXGlyphFont::GetFontBufferA(UINT code, GLYPHMETRICS* pgm, LPBYTE* lpData, const MAT2* mat2
							  , UINT format) const
{
	DWORD size;
	ZeroMemory( pgm, sizeof(GLYPHMETRICS) );

	// 16K̃A`FtHg
	// obt@TCYM
	size = GetGlyphOutlineA(m_hDC, code, format, pgm, 0, nullptr, mat2);
	if( size == 0 ) return 0;
	// obt@擾
	*lpData = new BYTE [size];
	// obt@ɃtHgM
	GetGlyphOutlineA(m_hDC, code, format, pgm, size, *lpData, mat2);
	return size;
}
/// CDXGlyphFont::GetFontBufferA Q
DWORD CDXGlyphFont::GetFontBufferW(UINT code, GLYPHMETRICS* pgm, LPBYTE* lpData, const MAT2* mat2
							  , UINT format) const
{
	DWORD size;
	ZeroMemory( pgm, sizeof(GLYPHMETRICS) );

	// 16K̃A`FtHg
	// obt@TCYM
	size = GetGlyphOutlineW(m_hDC, code, format, pgm, 0, nullptr, mat2);
	if( size == 0 ) return 0;
	// obt@擾
	*lpData = new BYTE [size];
	// obt@ɃtHgM
	GetGlyphOutlineW(m_hDC, code, format, pgm, size, *lpData, mat2);
	return size;
}

#endif

/**********************************************************************//**
 *
 * tHg}gbNXvZ
 *
*//***********************************************************************/
void CDXGlyphFont::CalcFontMatrix(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	f32 fCos = cos(m_Rotate);
	f32 fSin = sin(m_Rotate);
    long m11 = (long)( m_Scale.x * fCos * 65536.0);	long m12 = (long)(m_Scale.y * fSin * 65536.0);
    long m21 = (long)(-m_Scale.x * fSin * 65536.0);	long m22 = (long)(m_Scale.y * fCos * 65536.0);
	m_Mat.eM11 = *( (FIXED *)&m11 );	m_Mat.eM12 = *( (FIXED *)&m12 );
	m_Mat.eM21 = *( (FIXED *)&m21 );	m_Mat.eM22 = *( (FIXED *)&m22 );
#endif
}


}	// end of namespace dx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/DXDebugUnitTest.h"
#include "../DXObjectManager.h"
#include "../scene/DXCamera.h"
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// function
static LRESULT CALLBACK WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

//======================================================================
// test
IRIS_UNITTEST_B(CDXGlyphFontUnitTest, iris::dx::dbg::CDXUnitTestBase, DXGlyphFontUnitTest)
{
	static const UINT WINDOW_STYLE		= WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX;
	static const UINT WINDOW_STYLEEX	= WS_EX_OVERLAPPEDWINDOW;
	HWND hWnd = nullptr;
	RECT src = {0, 0, 640, 480};

	// EBhEg̒
	AdjustWindowRectEx(&src, WINDOW_STYLE, FALSE, WINDOW_STYLEEX);

	hWnd = wx::dbg::CreateUnitTestWindow(WINDOW_STYLEEX, m_TestName, m_TestName, WINDOW_STYLE
		, src.right, src.bottom, WindowProc);

	// EBhE̍쐬Ɏs
	if( hWnd == nullptr )
		return;

	ShowWindow( hWnd, SW_HIDE );
	CDXDevice dev(hWnd);
	CDXObjectManager objMan(&dev.GetDXSwapChain());
	if( !dev.CreateDevice(src.right, src.bottom, false, false, false, false, false, false) )
	{
		return;
	}
	dev.CreateSprite();
	objMan.CreateLayer<CDXDefaultLayer>(0);
	//CDXCamera* pCamera = devEx.CreateObject<CDXCamera>();
	//pCamera->SetPos(D3DXVECTOR3(0.0f, 0.0f, -10.0f));
	//pCamera->SetViewport();
	//pCamera->Activate();

	IDXFontTexture* pFont = objMan.CreateLayerObject<CDXGlyphFont>(0);

	CHAR buf[256] = "TEST";
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "͂ĂB" << std::endl;
	std::cin >> buf;
#endif

	pFont->Create(src.right,src.bottom);
	pFont->CreateFont(50,0,FW_NORMAL,0,0,0
		, SHIFTJIS_CHARSET
		, OUT_TT_PRECIS
		, PROOF_QUALITY
		, FIXED_PITCH | FF_MODERN
		, TEXT("lr ") );
	pFont->Clear();
	pFont->SetFontColor(0xFF22FF22);
	pFont->TextOutA(0, 0, buf, strlen(buf) ); 
	pFont->EnableRenderState(DXRS_DRAWSPRITE);
	pFont->SetWorldPos( &D3DXVECTOR3(0.0f, 0.0f, 0.0f) );

	this->SetDevice(&dev);

	// EBhE`
	ShowWindow( hWnd, SW_SHOW );
	// EBhE̍XV
	UpdateWindow( hWnd );
	// őOʂ
	SetForegroundWindow(hWnd);

	wx::dbg::UnitTestMainLoop(hWnd);
}


//**********************************************************************
//
// eXgpEBhEvV[W
// 
//----------------------------------------------------------------------
// @param	hWnd	EBhEnh
// @param	uMsg	sꂽbZ[W
// @param	wParam	sꂽbZ[W@
// @param	lParam	sꂽbZ[WA
// @return	LRESULTl
//**********************************************************************
LRESULT CALLBACK WindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	// bZ[W̏
	switch( uMsg )
	{
	case WM_DESTROY:
		PostQuitMessage( 0 );
		break;
	case WM_CLOSE:
		DestroyWindow( hWnd );
		break;
	case WM_KEYUP:
		switch( wParam )
		{
		case VK_ESCAPE:
			DestroyWindow( hWnd );
			break;
		}
		break;
	case WM_PAINT:
		{
			iris::dx::dbg::CDXUnitTestBase* pUT = iris::dx::dbg::CDXUnitTestBase::GetCurrent();
			pUT->Draw();
		}
		break;
	default:
		return DefWindowProc( hWnd, uMsg, wParam, lParam );
		break;
	}

	return 0L;
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
