//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXGlyphFont.h
 * @brief		directX glyph gptHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXGlyphFont_H_
#define INCG_IRIS_DXGlyphFont_H_

//======================================================================
// include
#include "DXGdiFont.h"

namespace iris {
namespace dx
{

//======================================================================
//! Glyph tHgNX
class CDXGlyphFont : public CDXGdiFont
{
public:
	/// DrawChar̃G[R[h
	typedef enum
	{
		DRAWCHAR_OK				=  0,	//!< I
		DRAWCHAR_LACK			=  1,	//!< 
		DRAWCHAR_OUTBOUND		=  2,	//!< ߂Ȃ
		DRAWCHAR_ERR_FAILED		= -1,	//!< ݎs
		DRAWCHAR_ERR_OUTBOUND	= -2,	//!< eNX`̈OɏƂ
		DRAWCHAR_ERR_TERM
	} DRAWCHAR_ERROR;

protected:
	UINT		m_FontFormat;	//!< tHgrbg}bvtH[}bg
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	MAT2		m_Mat;			//!< tHg}gbNX
#endif
	D3DXVECTOR2	m_Scale;
	f32			m_Rotate;

	bool		m_bOver;		//!< ㏑tO

public:
	// RXgN^
	CDXGlyphFont(void);
	// fXgN^
	virtual ~CDXGlyphFont(void);
public:
	// eNX`쐬
	virtual bool	Create(UINT width, UINT height);

public:
	// ̈̃NA
	virtual void	Clear(void);

	// 񏑂݁ieNX`ɕށj
	virtual bool	TextOutA(int x, int y, LPCSTR  pString, size_t size)
						{ return TextOutA(x, y, pString, size, m_bOver, false, false); }
	virtual bool	TextOutW(int x, int y, LPCWSTR pString, size_t size)
						{ return TextOutW(x, y, pString, size, m_bOver, false, false); }
	virtual bool	TextOutA(int x, int y, LPCSTR  pString, size_t size, bool over, bool lack, bool proportional);
	virtual bool	TextOutW(int x, int y, LPCWSTR pString, size_t size, bool over, bool lack, bool proportional);

protected:

#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	// P
	virtual int		DrawCharA(int x, int y, int* nx, int* ny, UINT code, DXLOCKED_RECT &rTexRect, TEXTMETRIC &rtm
							, intr::DXICOLOR color
							, bool over=false, bool antialias=false, bool lack=false, bool proportional=false);
	virtual int		DrawCharW(int x, int y, int* nx, int* ny, UINT code, DXLOCKED_RECT &rTexRect, TEXTMETRIC &rtm
							, intr::DXICOLOR color
							, bool over=false, bool antialias=false, bool lack=false, bool proportional=false);
	// 
	virtual int		OnDrawChar(GLYPHMETRICS& gm, LPBYTE buf, DWORD size, int alpha_level
							, int x, int y, int* nx, int* ny, UINT code, DXLOCKED_RECT &rTexRect, TEXTMETRIC &rtm
							, intr::DXICOLOR color
							, bool over=false, bool antialias=false, bool lack=false, bool proportional=false);

	// tHgobt@擾
	DWORD			GetFontBufferA(UINT code, GLYPHMETRICS* pgm, LPBYTE* lpData, const MAT2* mat2
							, UINT format) const;
	// tHgobt@擾
	DWORD			GetFontBufferW(UINT code, GLYPHMETRICS* pgm, LPBYTE* lpData, const MAT2* mat2
							, UINT format) const;

#endif
	// tHg}gbNXvZ
	void			CalcFontMatrix(void);


public:
	// set, get
	void			SetOver(bool over)				{ m_bOver = over; }
	bool			GetOver(void)	const			{ return m_bOver; }

	// tHgtH[}bg̐ݒ
	void			SetFontFormat(UINT fmt)			{ m_FontFormat = fmt; }

	// tHg}gbNXݒ
	void			SetFontMatrix(const D3DXVECTOR2& scale, f32 rotate) { m_Scale = scale; m_Rotate = rotate; CalcFontMatrix(); }
	void			SetSize(const D3DXVECTOR2& scale)					{ m_Scale = scale; CalcFontMatrix(); }
	void			SetRotate(f32 rotate)								{ m_Rotate = rotate; CalcFontMatrix(); }

};

}	// end of namespace dx
}	// end of namespace iris

#endif
