//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXPrimitive.cpp
 * @brief		DXPrimitive t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXPrimitive_CPP_

//======================================================================
// include
#include "DXPrimitive.h"
#include "../DXDevice.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IDXPrimitive::IDXPrimitive(void)
: CRenderState(DXRS_DEFAULT)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
IDXPrimitive::~IDXPrimitive(void)
{
	Release();
}

/**********************************************************************//**
 *
 * XV
 * 
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void IDXPrimitive::Update(f32 time)
{
	IRIS_UNUSED_VARIABLE(time);
}

/**********************************************************************//**
 *
 * `
 * 
*//***********************************************************************/
void IDXPrimitive::Draw(void)
{
	CDXDevice* pDxDevice = GetDXDevice();
	IRIS_ASSERT( pDxDevice != nullptr );
	CDXDeviceX& pDevice = pDxDevice->GetDevice();
	// _OXe[g̍XV
	// Cg
	DWORD light;
	D3DXMATRIX mat;
	D3DXMatrixIdentity(&mat);
	pDevice.GetRenderState( D3DRS_LIGHTING , &light);
	pDevice.SetRenderState( D3DRS_LIGHTING , IsRenderState(DXRS_ENABLELIGHT) );
	pDevice.SetTransform(D3DTS_TEXTURE0, &mat);

	if( m_pTexture.is_valid() )
	{
		if( FAILED(pDevice.SetTexture(0, m_pTexture)) )
		{
			IRIS_WARNING("failed SetTexture.");
		}
	}

	// [hWϊ
	pDevice.SetTransform(D3DTS_WORLD , &m_Mtx);

	DrawPrimitive();

	// Ƃɖ߂
	pDevice.SetRenderState( D3DRS_LIGHTING , light );

	if( m_pTexture.is_valid() ) pDevice.SetTexture(0, nullptr);
}

/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
void IDXPrimitive::Release(void)
{
	DX_SAFE_RELEASE(m_pTexture);
}

//======================================================================
// CDXPrimitive
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXPrimitive::CDXPrimitive(void)
: m_Type(D3DPT_TRIANGLESTRIP)
, m_Count(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXPrimitive::~CDXPrimitive(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
void CDXPrimitive::Release(void)
{
	CDXVertexBuffer::Release();
	IDXPrimitive::Release();
}

/**********************************************************************//**
 *
 * Zbg
 * 
*//***********************************************************************/
void CDXPrimitive::Reset(void)
{
	CDXVertexBuffer::Reset();
}

/**********************************************************************//**
 *
 * XgA
 * 
*//***********************************************************************/
void CDXPrimitive::Restore(void)
{
	CDXVertexBuffer::Restore();
}

/**********************************************************************//**
 *
 * `
 * 
*//***********************************************************************/
void CDXPrimitive::DrawPrimitive(void)
{
	SetStreamSource(0, 0);
	GetDevice()->DrawPrimitive(m_Type, 0, m_Count);
}

//======================================================================
// CDXIndexPrimitive
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXIndexPrimitive::CDXIndexPrimitive(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXIndexPrimitive::~CDXIndexPrimitive(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
void CDXIndexPrimitive::Release(void)
{
	CDXPrimitive::Release();
	DX_SAFE_RELEASE(m_lpIB);
}

/**********************************************************************//**
 *
 * `
 * 
*//***********************************************************************/
void CDXIndexPrimitive::DrawPrimitive(void)
{
	GetDevice()->SetIndices(m_lpIB);
	SetStreamSource(0, 0);
	GetDevice()->DrawIndexedPrimitive(m_Type, 0, 0, GetVertexCount(), 0, m_Count);
}

}	// end of namespace dx
}	// end of namespace iris


