//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFrame.h
 * @brief		directX bVReit@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXFrame_H_
#define INCG_IRIS_DXFrame_H_

//======================================================================
// include
#include "../DXMesh.h"

namespace iris {
namespace dx
{

//======================================================================
// struct

//======================================================================
// class
//! (D3DXMESHCONTAINER)Alloctor
class CDXFrameAllocHierarchy : public ID3DXAllocateHierarchy, public INonCopyable<CDXFrameAllocHierarchy>
{
public:
	// RXgN^
	CDXFrameAllocHierarchy(void);
	// fXgN^
	virtual ~CDXFrameAllocHierarchy(void);

public:
    //t[ IuWFNg̊蓖Ăv
    //STDMETHOD(CreateFrame)(THIS_ LPCSTR Name, LPD3DXFRAME *ppNewFrame);
    virtual HRESULT __stdcall CreateFrame(LPCSTR pMesh, LPD3DXFRAME *ppNewFrame);

    // bV Rei IuWFNg̊蓖Ăv
    //STDMETHOD(CreateMeshContainer)(THIS_
    //    LPCSTR Name,
    //    CONST D3DXMESHDATA *pMeshData,
    //    CONST D3DXMATERIAL *pMaterials,
    //    CONST D3DXEFFECTINSTANCE *pEffectInstances,
    //    DWORD NumMaterials,
    //    CONST DWORD *pAdjacency,
    //    LPD3DXSKININFO pSkinInfo,
    //    LPD3DXMESHCONTAINER *ppNewMeshContainer);
    virtual HRESULT __stdcall CreateMeshContainer(LPCSTR Name
		, const D3DXMESHDATA *pMeshData
		, const D3DXMATERIAL *pMaterials
		, const D3DXEFFECTINSTANCE *pEffectInstances
		, DWORD NumMaterials
		, const DWORD *pAdjacency
		, LPD3DXSKININFO pSkinInfo
		, LPD3DXMESHCONTAINER *ppNewMeshContainer);

    // t[ IuWFNg̊蓖ĉv
    //STDMETHOD(DestroyFrame)(THIS_ LPD3DXFRAME pFrameToFree);
    virtual HRESULT __stdcall DestroyFrame(LPD3DXFRAME pFrameToFree);

    // bV Rei IuWFNg̊蓖ĉv
    //STDMETHOD(DestroyMeshContainer)(THIS_ LPD3DXMESHCONTAINER pMeshContainerToFree);
    virtual HRESULT __stdcall DestroyMeshContainer(LPD3DXMESHCONTAINER pMeshContainerToFree);

protected:
	// Rei\̂̊m
	virtual D3DXMESHCONTAINER*	AllocateContainer(void);
	// O̍쐬
	virtual	bool				CreateName(D3DXMESHCONTAINER* pContainer, LPCSTR lpName);
	// bV̍쐬
	virtual bool				CreateMesh(D3DXMESHCONTAINER* pContainer, const D3DXMESHDATA* pMeshData);
	// @̍쐬
	virtual	bool				CreateNormalMap(D3DXMESHDATA* pMeshData);
	// }eA̍쐬
	virtual	bool				CreateMaterials(D3DXMESHCONTAINER* pContainer, const D3DXMATERIAL *pMaterials, DWORD NumMaterials);
	// eNX`̍쐬
	virtual	bool				CreateTexture(D3DXMESHCONTAINER* pContainer, LPCSTR lpFileName, DWORD dwIndex);
	// GtFNg̍쐬
	virtual bool				CreateEffects(D3DXMESHCONTAINER* pContainer, const D3DXEFFECTINSTANCE *pEffectInstances);
	// Adjacency̍쐬
	virtual bool				CreateAdjacency(D3DXMESHCONTAINER* pContainer, const DWORD* pAdjacency, DWORD FaceNum);
	// XL̍쐬
	virtual bool				CreateSkin(D3DXMESHCONTAINER* pContainer, LPD3DXSKININFO pSkinInfo);
};

}	// end of namespace dx
}	// end of namespace iris

#endif
