//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMessageData.h
 * @brief		directX bZ[Wf[^NXt@C
 *
 * @note		GȃNX݌vɂȂĂ܂BBB
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXMessageData_H_
#define INCG_IRIS_DXMessageData_H_

//======================================================================
// include
#include <map>
#include <vector>
#include "../../DXFlags.h"
#include "../font/DXFont.h"
#include "c++0x/cpp0x_enable_if.hpp"
#include "c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace dx
{

//======================================================================
// declare
class CDXMessageData;
class CDXMessage;

//======================================================================
// class
//======================================================================
//! bZ[Wf[^NX
class CDXMessageData : public CRenderState
{
public:
	typedef std::vector<UINT>	vecCode;

protected:
	vecCode		m_Code;		//!< bZ[Wf[^
	int			m_Length;	//!< \
	D3DXVECTOR3	m_Min;		//!< `̈iŏj
	D3DXVECTOR3 m_Max;		//!< `̈iőj

public:
	// RXgN^
	CDXMessageData(void);
	// fXgN^
	virtual ~CDXMessageData(void);
public:
	// XV
	virtual void		Update(f32 time);
	// `ʒǔvZ(ŃCfgƂ)
	virtual void		CalcPosition(int loop, int idx, int width, int height, D3DXVECTOR3& pos);
	// `Xe[gݒ(ŃJ[ύXƂ)
	virtual void		CalcState(UINT /*code*/, IDXFontTexture* /*font*/)	{}
public:
	// R[hݒ
	virtual void		SetCodeA(LPCSTR  pString, size_t size);
	virtual void		SetCodeW(LPCWSTR pString, size_t size);
	virtual void		SetCodeX(const UINT* codes, size_t size);
	template<typename CHARTYPE_>
	void				SetCode(const CHARTYPE_* pString, size_t size
		, typename enable_if_t< cpp0x::is_same<CHARTYPE_, CHAR > >::type*& =cpp0x::enabler)	{ SetCodeA(pString,size); }
	template<typename CHARTYPE_>
	void				SetCode(const CHARTYPE_* pString, size_t size
		, typename enable_if_t< cpp0x::is_same<CHARTYPE_, WCHAR> >::type*& =cpp0x::enabler)	{ SetCodeW(pString,size); }

	// R[h擾
	virtual vecCode&	GetCode(void)			{ return m_Code; }
	// \擾
	virtual int			GetShowLength(void)		{ int size = (int)m_Code.size(); return (m_Length < 0 || m_Length > size) ? size : m_Length; }
	// `掞vZ
	virtual int			GetCalcLoopCount(void)	const	{ return 1; }

public:
	// set, get
	int		GetLength(void)		const	{ return m_Length; }
	void	SetLength(int len)			{ m_Length = len; }

	const D3DXVECTOR3*	GetMin(void)		const		{ return &m_Min; }
	void				SetMin(const D3DXVECTOR3* min)	{ m_Min = *min; }
	const D3DXVECTOR3*	GetMax(void)		const		{ return &m_Max; }
	void				SetMax(const D3DXVECTOR3* max)	{ m_Max = *max; }

};

//======================================================================
//! bZ[Wf[^ǗNX
class CDXMessage : public IIrisObject
{
public:
	// bZ[Wf[^
	typedef std::map<UINT, CDXMessageData*>		CDataMap;
	typedef std::pair<UINT, CDXMessageData*>	CDataPair;

protected:
	UINT		m_ResID;	//!< tHg\[XID
	CDataMap	m_Data;		//!< bZ[Wf[^

public:
	// RXgN^
	CDXMessage(void);
	explicit CDXMessage(UINT uResID);
	// fXgN^
	virtual ~CDXMessage(void);

public:
	// XV
	virtual void	Update(f32 time);
	// 
	virtual void	Release(void);

	/// f[^ǉ
	template<class _TC>
	_TC*				CreateMessageData(UINT uID)
	{
		if( GetMessageData(uID) != nullptr ) return nullptr;
		_TC* p = new _TC;
		m_Data.insert( CDataPair(uID, p) );
		return p;
	}
	/// f[^ǉ
	CDXMessageData*	CreateMessageData(UINT uID)
	{
		return CreateMessageData<CDXMessageData>(uID);
	}
	// f[^폜
	bool			DeleteMessageData(UINT uID);
	// f[^擾
	CDXMessageData*	GetMessageData(UINT uID);

public:
	// R[hƂ̃tHg\[XID̎擾
	virtual UINT		GetCodeResID(UINT /*code*/)	{ return m_ResID; }
			CDataMap&	GetMessageData(void)		{ return m_Data; }
public:
	// set,get
	UINT	GetResID(void)		const	{ return m_ResID; }
	void	SetResID(UINT uID)			{ m_ResID = uID; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif	
