//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXCamera.h
 * @brief		directX JNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXCamera_H_
#define INCG_IRIS_DXCamera_H_

//======================================================================
// include
#include "../layer/DXLayerObject.h"

namespace iris {
namespace dx
{

//======================================================================
// declare

//======================================================================
// class
//! JNX
class CDXCamera : virtual public IDXLayerObject
{
protected:
	D3DXVECTOR3	m_Pos;		//!< Jʒu
	D3DXVECTOR3	m_LookAt;	//!< _
	D3DXVECTOR3	m_Up;		//!< xNg

	D3DXMATRIX	m_matView;	//!< r[s
	D3DXMATRIX	m_matProj;	//!< vWFNVϊs

	f32 m_fFovy;		//!< p
	f32 m_fAspect;		//!< AXyNg
	f32 m_fNear;		//!< ߎ_
	f32 m_fFar;			//!< _
	f32 m_fDistance;	//!< œ_

public:
	// RXgN^
	CDXCamera(void);
	explicit CDXCamera(D3DXVECTOR3* pos
		, f32 distance = 10.0f
		, D3DXVECTOR3* lookat=&D3DXVECTOR3(0.0f,0.0f,0.0f)
		, f32 _near=0.01f, f32 _far=1024.0f
		, D3DXVECTOR3* up=&D3DXVECTOR3(0.0f,1.0f,0.0f)
		, f32 fovy=1.0f, f32 aspect=1.333333f);
	// fXgN^
	virtual ~CDXCamera(void);
public:

	// r[gXtH[
	virtual	void	ViewTransform(void);
	// vWFNVgXtH[
	virtual	void	ProjectionTransform(void);
	// r[|[g
	virtual void	SetViewport(void);
	// r[|[g
	virtual void	SetViewport(DWORD width, DWORD height);

public:
	// 쐬
	virtual bool	Create(void);
public:
	// XV
	virtual void	Update(f32 time);
	// `
	virtual	void	Draw(void);
	// 
	virtual	void	Release(void);
protected:
	// Zbg
	virtual	void	Reset(void);
	// XgA
	virtual	void	Restore(void);

public:
	// ݒ̍XV
	virtual	void	Activate(void);

public:
	// XN[W[hWɕϊ
	D3DXVECTOR3*	ScreenToWorld(D3DXVECTOR3* pvecOut, const D3DXVECTOR3* pvecScreen);
	// [hWXN[Wɕϊ
	D3DXVECTOR3*	WorldToScreen(D3DXVECTOR3* pvecOut, const D3DXVECTOR3* pvecWorld);

public:
	// ʒuw
			D3DXVECTOR3&	GetPos(void)				{ return m_Pos; }
	const	D3DXVECTOR3&	GetPos(void)		const	{ return m_Pos; }
	void					SetPos(D3DXVECTOR3& pos)	{ m_Pos = pos; }
	// p̐ݒ
	f32				GetFovy(void)		const	{ return m_fFovy; }
	void			SetFovy(f32 fovy)			{ m_fFovy = fovy; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif	
