//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXRenderTextureUp.h
 * @brief		Texture `NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXRenderTextureUp_H_
#define INCG_IRIS_DXRenderTextureUp_H_

//======================================================================
// include
#include "DXRenderTexture.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**
 * @brief	eNX``NX
*/
class CDXRenderTextureUp : public IDXPrimitive, public IDXRenderTexture
{
	static const	DWORD	FVF	= (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX1);

public:
	// RXgN^
	CDXRenderTextureUp(void);
	CDXRenderTextureUp(const intr::DXICOLOR& color, const D3DXVECTOR2& tex_size);
	// fXgN^
	virtual ~CDXRenderTextureUp(void);

public:
	// 쐬
	virtual bool	Create(void);
	// 
	virtual	void	Release(void);

protected:
	// Zbg
	virtual	void	Reset(void);
	// XgA
	virtual	void	Restore(void);

public:
	// eNX`̐ݒ
	void			SetTexture(const IDXTexture* pTexture);

protected:
	// v~eBu`
	virtual	void	DrawPrimitive(void);
};

}	// end of namespace dx
}	// end of namespace iris

#endif
