//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXIDevice.h
 * @brief		DirectX foCXbsO t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXIDevice_H_
#define INCG_IRIS_DXIDevice_H_

//======================================================================
// include
#include "DXIMath.h"
#include "fnd/container/FndWrapObject.h"

namespace iris {
namespace dx
{

//======================================================================
// typedef

//======================================================================
// define
#if		defined(DX_SDK_VERSION)
#  if		(_IRIS_DXSDK_TARGET_VER == 9)
#    define	DXDEVTYPE_HAL		D3DDEVTYPE_HAL
#    define	DXDEVTYPE_REF		D3DDEVTYPE_REF
#    define	DXDEVTYPE_NULL		0
#    define	DXDEVTYPE_SW		D3DDEVTYPE_SW
#  elif		(_IRIS_DXSDK_TARGET_VER == 10)
#    define	DXDEVTYPE_HAL		D3D10_DRIVER_TYPE_HARDWARE
#    define	DXDEVTYPE_REF		D3D10_DRIVER_TYPE_REFERENCE
#    define	DXDEVTYPE_NULL		D3D10_DRIVER_TYPE_NULL
#    define	DXDEVTYPE_SW		D3D10_DRIVER_TYPE_SOFTWARE
#  else
#  endif
#elif	defined(_IRIS_SUPPORT_DXMOBILE)
#  define	DXDEVTYPE_HAL	D3DMDEVTYPE_DEFAULT
#  define	DXDEVTYPE_REF	D3DMDEVTYPE_DEFAULT
#  define	DXDEVTYPE_NULL	D3DMDEVTYPE_DEFAULT
#  define	DXDEVTYPE_SW	D3DMDEVTYPE_DEFAULT
#endif

namespace intr
{

//======================================================================
// class
/**
 * @brief	DirectX Device bvNX
*/
class CDXIDevice : public fnd::CWrapObject<LPDXDEVICE>
{
	typedef fnd::CWrapObject<LPDXDEVICE>	_Mybase;
public:
	// RXgN^
	CDXIDevice(void);
	CDXIDevice(const LPDXDEVICE object);
	// fXgN^
	~CDXIDevice(void);

#if	defined(_IRIS_HAS_NULLPTR_T)
	CDXIDevice&	operator = (const nullptr_t& null)	{ _Mybase::operator = (null); return *this; }
#endif

public:
	HRESULT		BeginScene(void);
	HRESULT		EndScene(void);

	HRESULT		Clear(DWORD Count, const intr::LPDXIRECT pRects, DWORD Flags, D3DCOLOR Color, float Z, DWORD Stencil);

public:
	HRESULT CreateDepthStencilSurface(UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample
		, DWORD MultisampleQuality, BOOL Discard, LPDXSURFACE *ppSurface, HANDLE *pSharedHandle);
	HRESULT CreateTexture(UINT Width, UINT Height, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool
		, LPDXTEXTURE* ppTexture, HANDLE* pSharedHandle);

public:
	HRESULT	CreateVertexBuffer(UINT uLength, DWORD dwUsage, DWORD dwFVF, DXPOOL Pool, LPDXVERTEXBUFFER* lppVB);
	HRESULT	CreateIndexBuffer(UINT uLength, DWORD dwUsage, DXFORMAT dwFVF, DXPOOL Pool, LPDXINDEXBUFFER* lppIB);

public:
	HRESULT		SetTexture(DWORD Stage, IDXBASETEXTURE* pTexture);
	HRESULT		GetTexture(DWORD Stage, IDXBASETEXTURE** ppTexture) const;

	HRESULT		SetStreamSource(UINT uStreamNumber, LPDXVERTEXBUFFER lpVB, UINT uOffsetInBytes, UINT uStride);

	HRESULT		SetTransform(D3DTRANSFORMSTATETYPE State, const D3DMATRIX* pMatrix);
	HRESULT		GetTransform(D3DTRANSFORMSTATETYPE State, D3DMATRIX* pMatrix) const;
#if	defined(_IRIS_SUPPORT_DXMOBILE)
	HRESULT		SetTransform(D3DTRANSFORMSTATETYPE State, const D3DXMATRIX* pMatrix);
	HRESULT		GetTransform(D3DTRANSFORMSTATETYPE State, D3DXMATRIX* pMatrix) const;
#endif

	HRESULT		SetRenderState(D3DRENDERSTATETYPE State, DWORD Value);
	HRESULT		SetRenderState(D3DRENDERSTATETYPE State, f32 Value);
	HRESULT		SetRenderState(D3DRENDERSTATETYPE State, f64 Value);
	template<typename TN>
	HRESULT		SetRenderState(D3DRENDERSTATETYPE State, TN Value)	{ return SetRenderState(State, static_cast<DWORD>(Value)); }

	HRESULT		GetRenderState(D3DRENDERSTATETYPE State, DWORD* pValue)	const;
	HRESULT		GetRenderState(D3DRENDERSTATETYPE State, f32* pValue)	const;
	HRESULT		GetRenderState(D3DRENDERSTATETYPE State, f64* pValue)	const;
	template<typename TN>
	HRESULT		GetRenderState(D3DRENDERSTATETYPE State, TN* Value)		const	{ return GetRenderState(State, static_cast<DWORD*>(Value)); }


	HRESULT		SetRenderTarget(DWORD RenderTargetIndex, LPDXSURFACE pRenderTarget);
	HRESULT		GetRenderTarget(DWORD RenderTargetIndex, LPDXSURFACE* ppRenderTarget) const;

	HRESULT		SetDepthStencilSurface(LPDXSURFACE lpSurface);
	HRESULT		GetDepthStencilSurface(LPDXSURFACE* lppSurface) const;

	HRESULT		SetSamplerState(DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD Value);

    HRESULT		SetLight(DWORD Index, CONST LPDXLIGHT pLight);
    HRESULT		GetLight(DWORD Index, LPDXLIGHT pLight) const;

	HRESULT		SetMaterial(CONST LPDXMATERIAL pMaterial);
	HRESULT		GetMaterial(LPDXMATERIAL pMaterial) const;

};

}	// end of namespace intr
}	// end of namespace dx
}	// end of namespace iris

#endif
