//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DMXMath.cpp
 * @brief		directX w֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DMXMath_CPP_

//======================================================================
// include
#include "DMXMath.h"

#if	defined(_IRIS_SUPPORT_DXMOBILE)

D3DMXVECTOR3*		D3DXVec3TransformCoord(D3DMXVECTOR3* pOut, const D3DMXVECTOR3* pV, const D3DMXMATRIX* pM)
{
	D3DMXVECTOR4 vec4(pOut->x, pOut->y, pOut->z, 0);
	D3DXVec3TransformCoord(&vec4, pV, pM);
	pOut->x = vec4.x;
	pOut->y = vec4.y;
	pOut->z = vec4.z;
	return pOut;
}
D3DMXVECTOR3FXD*	D3DXVec3TransformCoord(D3DMXVECTOR3FXD* pOut, const D3DMXVECTOR3FXD* pV, const D3DMXMATRIXFXD* pM)
{
	D3DMXVECTOR4FXD vec4(pOut->x, pOut->y, pOut->z, 0);
	D3DXVec3TransformCoord(&vec4, pV, pM);
	pOut->x = vec4.x;
	pOut->y = vec4.y;
	pOut->z = vec4.z;
	return pOut;
}

D3DMXVECTOR3*		D3DXVec3Transform(D3DMXVECTOR3* pOut, const D3DMXVECTOR3* pV, const D3DMXMATRIX* pM)
{
	D3DMXVECTOR4 vec4(pOut->x, pOut->y, pOut->z, 0);
	D3DXVec3Transform(&vec4, pV, pM);
	pOut->x = vec4.x;
	pOut->y = vec4.y;
	pOut->z = vec4.z;
	return pOut;
}
D3DMXVECTOR3FXD*	D3DXVec3Transform(D3DMXVECTOR3FXD* pOut, const D3DMXVECTOR3FXD* pV, const D3DMXMATRIXFXD* pM)
{
	D3DMXVECTOR4FXD vec4(pOut->x, pOut->y, pOut->z, 0);
	D3DXVec3Transform(&vec4, pV, pM);
	pOut->x = vec4.x;
	pOut->y = vec4.y;
	pOut->z = vec4.z;
	return pOut;
}

D3DXVECTOR3*		D3DXVec3Project(D3DMXVECTOR3 *pOut, CONST D3DMXVECTOR3 *pV, CONST D3DMVIEWPORT *pViewport
												, CONST D3DMXMATRIX *pProjection, CONST D3DMXMATRIX *pView, CONST D3DMXMATRIX *pWorld)
{
    D3DMXVECTOR4 in;
	D3DMXMATRIX mViewPort;
	D3DMXMatrixIdentity(&mViewPort);
	mViewPort._11 = pViewport->Width / 2.0f;
	mViewPort._41 = pViewport->Width / 2.0f;
	mViewPort._22 = -(pViewport->Height / 2.0f);
	mViewPort._42 =  pViewport->Height / 2.0f;
	mViewPort._33 = 1.0f;
	mViewPort._44 = 1.0f;

    D3DMXVec3Transform(&in, pV, pWorld);
    D3DMXVec4Transform(&in, &in, pView);
    D3DMXVec4Transform(&in, &in, pProjection);

    if(in.w != 0.0f)
    {
        in.x = (in.x / in.w + 1.0f) * mViewPort._41;
        in.y = (1.0f - in.y / in.w) * mViewPort._42;

        pOut->x = in.x;
        pOut->y = in.y;
        pOut->z = in.z;
    }

    return pOut;
}

D3DXVECTOR3*		D3DXVec3Unproject(D3DMXVECTOR3 *pOut, CONST D3DMXVECTOR3 *pV, CONST D3DMVIEWPORT *pViewport
												, CONST D3DMXMATRIX *pProjection, CONST D3DMXMATRIX *pView, CONST D3DMXMATRIX *pWorld)
{
	D3DMXMATRIX mViewPort;
	D3DMXMATRIX screen;
	D3DMXMatrixIdentity(&mViewPort);
	mViewPort._11 = pViewport->Width / 2.0f;
	mViewPort._41 = pViewport->Width / 2.0f;
	mViewPort._22 = -(pViewport->Height / 2.0f);
	mViewPort._42 =  pViewport->Height / 2.0f;
	mViewPort._33 = 1.0f;
	mViewPort._44 = 1.0f;

	D3DMXMatrixMultiply(&screen, pView, pWorld);
	D3DMXMatrixMultiply(&screen, pProjection, &screen);
	D3DMXMatrixMultiply(&screen, &mViewPort, &screen);
	D3DMXMatrixInverse(&screen, NULL, &screen);

	return D3DXVec3Transform(pOut, pV, &screen);
}

D3DXQUATERNION *	D3DXQuaternionRotationMatrix(D3DXQUATERNION *pOut, CONST D3DMXMATRIX *pM)
{
	FLOAT x, y, z, w;
	FLOAT r, t;

	t = pM->_11 + pM->_22 + pM->_33 + 1.0f;

	if( t > 0.01f ) 
	{
		w = F32_Mul(F32_Sqrt( t ), 0.5f);
		r = F32_Div(0.25f, w);
		x = F32_Mul(( pM->_23 - pM->_32 ), r);
		y = F32_Mul(( pM->_31 - pM->_13 ), r);
		z = F32_Mul(( pM->_12 - pM->_21 ), r);
	} 
	else if( pM->_11 > pM->_22 )
	{
		if( pM->_11 > pM->_33 ) 
		{
			x = F32_Mul(F32_Sqrt( 1.0f + pM->_11 - pM->_22 - pM->_33 ), 0.5f);
			r = F32_Div(0.25f, x);
			y = F32_Mul(( pM->_21 + pM->_12 ), r);
			z = F32_Mul(( pM->_31 + pM->_13 ), r);
			w = F32_Mul(( pM->_23 - pM->_32 ), r);
		}
		else
		{
			z = F32_Mul(F32_Sqrt( 1.0f + pM->_33 - pM->_11 - pM->_22 ), 0.5f);
			r = F32_Div(0.25f, z);
			x = F32_Mul(( pM->_31 + pM->_13 ), r);
			y = F32_Mul(( pM->_32 + pM->_23 ), r);
			w = F32_Mul(( pM->_12 - pM->_21 ), r);
		}
	} 
	else
	{
		if( pM->_22 > pM->_33 )
		{
			y = F32_Mul(F32_Sqrt( 1.0f + pM->_22 - pM->_33 - pM->_11 ), 0.5f);
			r = F32_Div(0.25f, y);
			x = F32_Mul(( pM->_21 + pM->_12 ), r);
			z = F32_Mul(( pM->_32 + pM->_23 ), r);
			w = F32_Mul(( pM->_31 - pM->_13 ), r);
		} 
		else 
		{
			z = F32_Mul(F32_Sqrt( 1.0f + pM->_33 - pM->_11 - pM->_22 ), 0.5f);
			r = F32_Div(0.25f, z);
			x = F32_Mul(( pM->_31 + pM->_13 ), r);
			y = F32_Mul(( pM->_32 + pM->_23 ), r);
			w = F32_Mul(( pM->_12 - pM->_21 ), r);
		}
	}
	pOut->x = x;
	pOut->y = y;
	pOut->z = z;
	pOut->w = w;
	return (pOut);
}

#endif

