//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXVPad.cpp
 * @brief		directX zRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXVPad_CPP_

//======================================================================
// include
#include "DXVPad.h"

#include "iris_debug.h"

namespace iris {
namespace dx
{

//======================================================================
// define

//======================================================================
// class

//======================================================================
// CDXVPad
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXVPad::CDXVPad(void)
: m_Hold(0)
, m_Trig(0)
, m_Free(0)
, m_Rept(0)
{
	for( int i=0; i < eDXVPAD_NUM; ++i )
		m_pKeys[i] = nullptr;
	for( int i=0; i < eDXVALGPAD_NUM; ++i )
		m_pJoys[i] = nullptr;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXVPad::~CDXVPad(void)
{
}

/**********************************************************************//**
 *
 * XV
 *
*//***********************************************************************/
void CDXVPad::Update(void)
{
	// button
	u32 mask=1;
	m_Hold = 0;
	m_Trig = 0;
	m_Free = 0;
	m_Rept = 0;
	for( int i=0; i < eDXVPAD_NUM; ++i, mask<<=1 )
	{
		CKeyState* pKey = m_pKeys[i];
		if( pKey == nullptr ) continue;
		m_Hold |= pKey->Hold() ? mask : 0;
		m_Trig |= pKey->Trig() ? mask : 0;
		m_Free |= pKey->Free() ? mask : 0;
		m_Rept |= pKey->Rept() ? mask : 0;
	}
	// joy
}

/**********************************************************************//**
 *
 * L[̊蓖
 *
 ----------------------------------------------------------------------
 * @param [in]	nIndex	= L[CfbNX
 * @param [in]	pKey	= L[
 * @return	ȑÕL[
*//***********************************************************************/
CKeyState* CDXVPad::SetKey(int nIndex, CKeyState* pKey)
{
	IRIS_ASSERT( nIndex >= 0 && nIndex < eDXVPAD_NUM );
	CKeyState* key = m_pKeys[nIndex];
	m_pKeys[nIndex] = pKey;
	return key;
}

/**********************************************************************//**
 *
 * L[̊蓖
 *
 ----------------------------------------------------------------------
 * @param [in]	nIndex	= AiOXeBbNCfbNX
 * @param [in]	pJoy	= AiOXeBbN
 * @return	ȑÕAiOXeBbN
*//***********************************************************************/
CDXJoyStickState* CDXVPad::SetJoy(int nIndex, CDXJoyStickState* pJoy)
{
	IRIS_ASSERT( nIndex >= 0 && nIndex < eDXVALGPAD_NUM );
	CDXJoyStickState* joy = m_pJoys[nIndex];
	m_pJoys[nIndex] = pJoy;
	return joy;
}

/**********************************************************************//**
 *
 * AiOXeBbN̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	nIndex	= AiOXeBbNCfbNX
 * @return	xl
*//***********************************************************************/
f32 CDXVPad::AlgX(int nIndex) const
{
	IRIS_ASSERT( nIndex >= 0 && nIndex < eDXVALGPAD_NUM );
	CDXJoyStickState* pJoy = m_pJoys[nIndex];
	if( pJoy == nullptr ) return 0.0f;
	return pJoy->GetStick()->x;
}
/**********************************************************************//**
 *
 * AiOXeBbN̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	nIndex	= AiOXeBbNCfbNX
 * @return	yl
*//***********************************************************************/
f32 CDXVPad::AlgY(int nIndex) const
{
	IRIS_ASSERT( nIndex >= 0 && nIndex < eDXVALGPAD_NUM );
	CDXJoyStickState* pJoy = m_pJoys[nIndex];
	if( pJoy == nullptr ) return 0.0f;
	return pJoy->GetStick()->y;
}
/**********************************************************************//**
 *
 * AiOXeBbN̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	nIndex	= AiOXeBbNCfbNX
 * @return	zl
*//***********************************************************************/
f32 CDXVPad::AlgZ(int nIndex) const
{
	IRIS_ASSERT( nIndex >= 0 && nIndex < eDXVALGPAD_NUM );
	CDXJoyStickState* pJoy = m_pJoys[nIndex];
	if( pJoy == nullptr ) return 0.0f;
	return pJoy->GetStick()->z;
}
/**********************************************************************//**
 *
 * AiOXeBbN̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	nIndex	= AiOXeBbNCfbNX
 * @return	x,y,zl
*//***********************************************************************/
const D3DXVECTOR3* CDXVPad::Alg(int nIndex) const
{
	IRIS_ASSERT( nIndex >= 0 && nIndex < eDXVALGPAD_NUM );
	CDXJoyStickState* pJoy = m_pJoys[nIndex];
	if( pJoy == nullptr ) return nullptr;
	return pJoy->GetStick();
}

/**********************************************************************//**
 *
 * NA
 *
*//***********************************************************************/
void CDXVPad::Clear(void)
{
	m_Hold = 0;
	m_Trig = 0;
	m_Free = 0;
	m_Rept = 0;
	for( int i=0; i < eDXVPAD_NUM; ++i )
	{
		CKeyState* pKey = m_pKeys[i];
		if( pKey == nullptr ) continue;
		pKey->Clear();
	}
}

}	// end of namespace dx
}	// end of namespace iris
