//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXSoundBuffer.h
 * @brief		directX TEhobt@[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXSoundBuffer_H_
#define INCG_IRIS_DXSoundBuffer_H_

//======================================================================
// include
#include "../dx_inchead.h"
#include "audio/format/AXAudioFile.h"

#if defined(_IRIS_SUPPORT_DXSOUND)

namespace iris {
namespace dx
{

//======================================================================
// class
//! TEhobt@[NX
class CDXSoundBuffer : public INonCopyable<>
{
private:
    LPDXSOUNDBUFFER*	m_ppBuffer;		//!< TEhobt@擪AhX
    DWORD				m_dwBufferNum;	//!< obt@̐

	ax::IAXFile*		m_pFile;

public:
	// RXgN^
	CDXSoundBuffer(void);
	// fXgN^
	virtual ~CDXSoundBuffer(void);

public:
	// 
	virtual void		Release(void);

	// TEhobt@IuWFNg̍쐬
	HRESULT					CreateBuffer(DWORD num);
	// TEhobt@IuWFNg̎擾
	LPDXSOUNDBUFFER*		GetBuffer(DWORD id);
	// 󂢂ĂTEhobt@IuWFNg̎擾
	LPDXSOUNDBUFFER			GetFreeBuffer(void);
	// 󂢂ĂTEhobt@IuWFNgindex擾
	DWORD					GetFreeBufferID(void) const;

public:
	// obt@Ƀf[^i[
	virtual HRESULT		FillBuffer(LPDXSOUNDBUFFER pBuffer);

public:
	// Đ
	virtual HRESULT		Play(DWORD id, DWORD dwPriority = 0, DWORD dwFlags = 0);
	// Đ
	virtual HRESULT		Play(DWORD dwPriority = 0, DWORD dwFlags = 0);
	// ~
	virtual HRESULT		Stop(DWORD id);
	// ~
	virtual HRESULT		Stop(void);
	// Đׂ
	virtual HRESULT		IsPlaying(DWORD id) const;
	// Đׂ
	virtual HRESULT		IsPlaying(void) const;
public:
	// ʂ̐ݒ
	virtual HRESULT		SetVolume(DWORD id, long lVolume);
	// ʂ̐ݒ
	virtual HRESULT		SetVolume(long lVolume);
	// ʂ̎擾
	virtual HRESULT		GetVolume(DWORD id, long *plVolume) const;
public:
	// p̐ݒ
	virtual HRESULT		SetPan(DWORD id, long lPan);
	// p̐ݒ
	virtual HRESULT		SetPan(long lPan);
	// p̎擾
	virtual HRESULT		GetPan(DWORD id, long *plPan) const;
public:
	// g̐ݒ
	virtual HRESULT		SetFrequency(DWORD id, DWORD dwFrequency);
	// g̐ݒ
	virtual HRESULT		SetFrequency(DWORD dwFrequency);
	// g̎擾
	virtual HRESULT		GetFrequency(DWORD id, DWORD *pdwFrequency) const;
public:
	// ĐJ[\ʒu̐ݒ
	virtual HRESULT		SetCurrentPosition(DWORD id, DWORD dwPosition);
	// ĐJ[\ʒu̎擾
	virtual HRESULT		GetCurrentPosition(DWORD id, DWORD *pdwPosition) const;

public:
	// set, get
	// TEht@CNX̐ݒ
	void				SetSoundFile(ax::IAXFile* pSoundFile)	{ m_pFile = pSoundFile; }
	// TEht@CNX̎擾
	ax::IAXFile*		GetSoundFile(void)						{ return m_pFile; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif

#endif
