//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MfcPrivateProfile.cpp
 * @brief		MfcPrivateProfile t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MfcPrivateProfile_CPP_

//======================================================================
// include
#include "MfcPrivateProfile.h"
#include "fnd/container/FndBuffer.h"
#include <tchar.h>

namespace iris {
namespace mfc
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPrivateProfile::CPrivateProfile(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	path	= pX
*//***********************************************************************/
CPrivateProfile::CPrivateProfile(const CString& path)
{
	Open(path);
}

/**********************************************************************//**
 *
 * J
 *
 -----------------------------------------------------------------------
 * @param [in]	path	= pX
*//***********************************************************************/
void CPrivateProfile::Open(const CString& path)
{
	m_Path = path;
}

/**********************************************************************//**
 *
 * ݂ZNV擾
 *
 -----------------------------------------------------------------------
 * @param [out]	names		= o
 * @return	
*//***********************************************************************/
bool CPrivateProfile::GetSectionNames(CArray<CString>& names)	const
{
	fnd::CBuffer<TCHAR> buf(1024);
	DWORD ret = GetPrivateProfileSectionNames(buf, buf.size(), m_Path);
	if( ret == 0 ) return false;
	if( ret == buf.size()-2 )
	{
		buf.resize(4096);
		GetPrivateProfileSectionNames(buf, buf.size(), m_Path);
	}
	LPTSTR c = buf;
	LPTSTR p = _tcschr(c, TEXT('\0'));
	while(p != nullptr)
	{
		names.Add(c);
		c = p+1;
		p = _tcschr(c, TEXT('\0'));
		if( c == p ) break;
	}
	return true;
}

/**********************************************************************//**
 *
 * ZNVɑ݂L[擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [out]	names		= o
 * @return	
*//***********************************************************************/
bool CPrivateProfile::GetSection(const CString& lpAppName, CArray<CString>& names)	const
{
	fnd::CBuffer<TCHAR> buf(1024);
	DWORD ret = GetPrivateProfileSection(lpAppName, buf, buf.size(), m_Path);
	if( ret == 0 ) return false;
	if( ret == buf.size()-1 )
	{
		buf.resize(4096);
		GetPrivateProfileSection(lpAppName, buf, buf.size(), m_Path);
	}
	LPTSTR c = buf;
	LPTSTR p = _tcschr(c, TEXT('='));
	while(p != nullptr)
	{
		*p = TEXT('\0');
		names.Add(c);
		c = p+1;
		p = _tcschr(c, TEXT('\0'));
		if( c == p ) break;
		c = p+1;
		p = _tcschr(c, TEXT('='));
	}
	return true;
}

/**********************************************************************//**
 *
 * t@C當擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpDefault	= sƂɕԂ
 * @param [out]	lpReturn	= o̓obt@(L['='؂ŏo͂)
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetString(const CString& lpAppName, const CString& lpKeyName, const CString& lpDefault, LPTSTR lpReturn, DWORD nSize)	const
{
	return GetPrivateProfileString(lpAppName, lpKeyName, lpDefault, lpReturn, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@C琮l擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nDefault	= sƂɕԂl
 * @return	l
*//***********************************************************************/
UINT CPrivateProfile::GetInt(const CString& lpAppName, const CString& lpKeyName, UINT nDefault)	const
{
	return GetPrivateProfileInt(lpAppName, lpKeyName, nDefault, m_Path);
}

}	// end of namespace mfc
}	// end of namespace iris

