//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDlgBase.cpp
 * @brief		_CAO{t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDlgBase_CPP_

//======================================================================
// include
#include "WXDlgBase.h"

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDlgBase::CDlgBase(void)
: m_ExitCode(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDlgBase::~CDlgBase(void)
{
}

/**********************************************************************//**
 *
 * ANZ[^L[̊mF
 *
 ----------------------------------------------------------------------
 * @param [in]	msg	= sꂽbZ[W
 * @return	
*//***********************************************************************/
BOOL CDlgBase::PreTranslateMessage(LPMSG msg)
{
	return IsDialogMessage(m_hWnd, msg);
}

/**********************************************************************//**
 *
 * CreateDialog
 *
 ----------------------------------------------------------------------
 * @param [in]	hInst			= CX^Xnh
 * @param [in]	lpTemplateName	= 
 * @param [in]	hParent			= eEBhE
 * @param [in]	lpDlgProc		= _CAOvV[W
 * @param [in]	lParam			= LPARAM
 * @return	EBhEnh
*//***********************************************************************/
HWND CDlgBase::CreateModeless (HINSTANCE hInst, LPCTSTR lpTemplateName, HWND hParent, DLGPROC lpDlgProc, LPARAM lParam)
{
#ifdef UNICODE
	return CreateModelessW(hInst, lpTemplateName, hParent, lpDlgProc, lParam);
#else
	return CreateModelessA(hInst, lpTemplateName, hParent, lpDlgProc, lParam);
#endif
}
/// CDlgBase::CreateModeless Q
HWND CDlgBase::CreateModelessA(HINSTANCE hInst, LPCSTR  lpTemplateName, HWND hParent, DLGPROC lpDlgProc, LPARAM lParam)
{
#if !defined(IRIS_WIN32_WCE)
	HWND hWnd = nullptr;
	if( m_hWnd != nullptr ) return nullptr;
	s_pWindow = this;
	hWnd = ::CreateDialogParamA(hInst, lpTemplateName, hParent, lpDlgProc, lParam);
	s_pWindow = nullptr;
	if( hWnd == nullptr ) return nullptr;
	Attach( hWnd );
	return hWnd;
#else
	return nullptr;
#endif
}
/// CDlgBase::CreateModeless Q
HWND CDlgBase::CreateModelessW(HINSTANCE hInst, LPCWSTR lpTemplateName, HWND hParent, DLGPROC lpDlgProc, LPARAM lParam)
{
	HWND hWnd = nullptr;
	if( m_hWnd != nullptr ) return nullptr;
	s_pWindow = this;
	hWnd = ::CreateDialogParamW(hInst, lpTemplateName, hParent, lpDlgProc, lParam);
	s_pWindow = nullptr;
	if( hWnd == nullptr ) return nullptr;
	Attach( hWnd );
	return hWnd;
}

/**********************************************************************//**
 *
 * DialogBox
 *
 ----------------------------------------------------------------------
 * @param [in]	hInst			= CX^Xnh
 * @param [in]	lpTemplateName	= 
 * @param [in]	hParent			= eEBhE
 * @param [in]	lpDlgProc		= _CAOvV[W
 * @param [in]	lParam			= LPARAM
 * @return	EBhEnh
*//***********************************************************************/
INT_PTR CDlgBase::CreateModal (HINSTANCE hInst, LPCTSTR lpTemplateName, HWND hParent, DLGPROC lpDlgProc, LPARAM lParam)
{
#ifdef UNICODE
	return CreateModalW(hInst, lpTemplateName, hParent, lpDlgProc, lParam);
#else
	return CreateModalA(hInst, lpTemplateName, hParent, lpDlgProc, lParam);
#endif
}
/// CDlgBase::CreateModal Q
INT_PTR CDlgBase::CreateModalA(HINSTANCE hInst, LPCSTR  lpTemplateName, HWND hParent, DLGPROC lpDlgProc, LPARAM lParam)
{
#if !defined(IRIS_WIN32_WCE)
	INT_PTR ret = 0;
	if( m_hWnd != nullptr ) return ret;
	s_pWindow = this;
	ret = ::DialogBoxParamA(hInst, lpTemplateName, hParent, lpDlgProc, lParam);
	return ret;
#else
	return -1;
#endif
}
/// CDlgBase::CreateModal Q
INT_PTR CDlgBase::CreateModalW(HINSTANCE hInst, LPCWSTR lpTemplateName, HWND hParent, DLGPROC lpDlgProc, LPARAM lParam)
{
	INT_PTR ret = 0;
	if( m_hWnd != nullptr ) return ret;
	s_pWindow = this;
	ret = ::DialogBoxParamW(hInst, lpTemplateName, hParent, lpDlgProc, lParam);
	return ret;
}

/**********************************************************************//**
 *
 * [__CAO
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
INT_PTR CDlgBase::DoModal(void)
{
	if( m_hWnd != nullptr )
	{
		MSG msg;
		ZeroMemory(&msg, sizeof(msg));
		HWND hParent = GetParent();
		m_ExitCode = STILL_ACTIVE;
		ShowWindow(SW_SHOW);
		// CEChE𖳌ă[_
		::EnableWindow(hParent, FALSE);
		// bZ[W[v
		while( (m_ExitCode==STILL_ACTIVE) && (msg.message != WM_QUIT) )
		{
			while( !PeekMessage(&msg, nullptr, 0U, 0U, PM_NOREMOVE) )
			{
				if( m_ExitCode != STILL_ACTIVE ) break;
			}
			if( GetMessage(&msg, nullptr, 0, 0) )
			{
				if( !IsDialogMessage(m_hWnd, &msg) )
				{
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
			}
		}
		DestroyWindow();
		Detach();

		// CEChELɂă[_
		//ShowWindow(SW_HIDE);
		::EnableWindow(hParent, TRUE);
		::BringWindowToTop(hParent);
	}
	return m_ExitCode;
}

/**********************************************************************//**
 *
 * _CAO
 *
*//***********************************************************************/
INT_PTR CDlgBase::DlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
	case WM_DESTROY:
		__IrisDlgEventFuncName(Destroy)			(hDlg,wParam,lParam);
		break;
	// ړ
	case WM_MOVE:
		return __IrisDlgEventFuncName(Move)		(hDlg,wParam,lParam);
	// TCYύX
	case WM_SIZE:
		return __IrisDlgEventFuncName(Size)		(hDlg,wParam,lParam);
	// Focus
	case WM_SETFOCUS:
		return __IrisDlgEventFuncName(SetFocus)	(hDlg,wParam,lParam);
	case WM_KILLFOCUS:
		return __IrisDlgEventFuncName(KillFocus)(hDlg,wParam,lParam);
	// EBhEELɂȂ낤ƂĂƂɑB
	// EnableWindow֐߂Oɑ.
	// wParam. LɂȂƂ 1 ɂȂƂ 0. lParam. 0. 
	case WM_ENABLE:
		return __IrisDlgEventFuncName(Enable)	(hDlg,wParam,lParam);
	/*
	// `̗}
	// Test
	//	SendMessage(hWnd,WM_SETREDRAW,false,0);
	//	//ŕ`揈
	//	SendMessage(hWnd,WM_SETREDRAW,true,0);
	//	InvalidateRect(hWnd,nullptr,true);
	case WM_SETREDRAW:
		break;
	*/
	case WM_PAINT:
		return __IrisDlgEventFuncName(Paint)	(hDlg,wParam,lParam);
	// 
	case WM_CLOSE:
		{
			LRESULT ret = __IrisDlgEventFuncName(Close)(hDlg,wParam,lParam);
			if( !ret ) ::DestroyWindow(hDlg);
			return ret;
		}
	// WindowsI悤ƂƂASẴEBhEɑ
	// wParam	WindowsZbVI̗vtbO
	//			[WindowsI]_CAOgpƂ        0
	//			[^XNXg]gpƂ                 0ȊO
	// lParam	[U[OItƂ                   1
	//			VXeVbg_EƂ             0
	// return	IłƂ                               1
	//			łȂƂ                                 0
		/*
	case WM_QUERYENDSESSION:
		return __IrisDlgEventFuncName(QueryEndSesssion)(hDlg,wParam,lParam);
		*/
	// ACRꂽEBhE𕜌悤ƂĂEBhEɑ. 
	// wParam.	0. lParam. 0.
	// ߂l.	vǂɕƂ 1
	//			LZƂ 0
		/*
	case WM_QUERYOPEN:
		return __IrisDlgEventFuncName(QueryOpen)(hDlg,wParam,lParam);
		*/

#if	!defined(IRIS_WIN32_WCE)
	// MiniMax
	case WM_GETMINMAXINFO:
		return __IrisDlgEventFuncName(GetMinMaxInfo)(hDlg,wParam,lParam);
#endif
	// `
	case WM_DRAWITEM:
		return __IrisDlgEventFuncName(DrawItem)	(hDlg,wParam,lParam);
	case WM_MEASUREITEM:
		return __IrisDlgEventFuncName(MeasurItem)(hDlg,wParam,lParam);

	// ACR\悤ƂƂɃNXACRȂEBhEɑ.
	// wParam. 0. lParam. 0.
	case WM_QUERYDRAGICON:
		return __IrisDlgEventFuncName(QueryDragIcon)	(hDlg,wParam,lParam);
#if	!defined(IRIS_WIN32_WCE)
	// TCYύXObZ[W
	case WM_WINDOWPOSCHANGING:
		return __IrisDlgEventFuncName(WindowPosChanging)(hDlg,wParam,lParam);
#endif
	// TCYύXチbZ[W
	case WM_WINDOWPOSCHANGED:
		return __IrisDlgEventFuncName(WindowPosChanged)	(hDlg,wParam,lParam);
	// ʒm
	case WM_NOTIFY:
		return __IrisDlgEventFuncName(Notify)	(hDlg,wParam,lParam);

	// VXep[ߖԂɓƂE߂Ƃɑ. 
	// wParam 
	// dCxgʒmbZ[W
	// 
	// 萔                 
	//-------------------------------------------------------------------
	//PWR_SUSPENDREQUEST   VXeTXyh[hɓ낤ƂĂ
	//PWR_SUSPENDRESUME    VXeʏǂTXyh[hɓ
	//                     (܂TXyhOɃAvP[V
	//                     PWR_SUSPENDRQUESTʒm𑗂)ŁA
	//                     ĊJ悤ƂĂB
	//                     AvP[V͕Kvȉ񕜓s
	//                     Ȃ΂ȂȂB
	//PWR_CRITICALRESUME   VXePWR_SUSPENDREQUESTʒmbZ[W
	//                     AvP[Vɑ炸ɃTXyh[h
	//                     ŁAĊJ悤ƂĂ邱Ƃ
	//                     BAvP[V͕Kvȉ񕜓s
	//                     Ȃ΂ȂȂB
	//-------------------------------------------------------------------
	// 
	//lParam 
	//0
	//
	//߂l 
	//wParam̒l            ߂l
	//----------------------------------------------------------------------
	//PWR_SUSPENDREQUEST    TXyhԂɂȂȂ悤ɂPWR_FAIL
	//                      TXyhPWR_OK
	//PWR_SUSPENDRESUME     0
	//PWR_CRITICALRESUME    0
	//----------------------------------------------------------------------
		/*
 	case WM_POWER:
		return __IrisDlgEventFuncName(Power)	(hDlg,wParam,lParam);
		*/

	// wv
	case WM_HELP:
		return __IrisDlgEventFuncName(Help)		(hDlg,wParam,lParam);
#if	!defined(IRIS_WIN32_WCE)
	// Unicode}`oCgĂ
	case WM_NOTIFYFORMAT:
		return __IrisDlgEventFuncName(NotifyFormat)(hDlg,wParam,lParam);
#endif

	// ACR擾
	case WM_GETICON:
		return __IrisDlgEventFuncName(GetIcon)	(hDlg,wParam,lParam);
	//
	case WM_GETDLGCODE:
		return __IrisDlgEventFuncName(GetDlgCode)(hDlg,wParam,lParam);

	// L[
	case WM_KEYDOWN:
		return __IrisDlgEventFuncName(KeyDown)	(hDlg,wParam,lParam);
	case WM_KEYUP:
		return __IrisDlgEventFuncName(KeyUp)	(hDlg,wParam,lParam);
	case WM_CHAR:
		return __IrisDlgEventFuncName(Char)		(hDlg,wParam,lParam);
	case WM_DEADCHAR:
		return __IrisDlgEventFuncName(DeadChar)	(hDlg,wParam,lParam);
	case WM_SYSKEYDOWN:
		return __IrisDlgEventFuncName(SysKeyDown)	(hDlg,wParam,lParam);
	case WM_SYSKEYUP:
		return __IrisDlgEventFuncName(SysKeyUp)	(hDlg,wParam,lParam);
	// [ALT]L[ƂƂɃL[ƂA̓tH[JXEBhEɑ. 
	// wParam. VXej[L[̕R[h.
	// lParam L[Xg[NbZ[W.
	// ߂l. 0Ԃ.
		/*
	case WM_SYSCHAR:
		return __IrisDlgEventFuncName(SysChar)	(hDlg,wParam,lParam);
		*/
	// VXefbhL[ꂽƂA̓tH[JXEBhEɑ
	// wParam VXeL[̕R[h
	// lParam L[Xg[NbZ[W
	// ߂l 0Ԃ
		/*
	case WM_SYSDEADCHAR:
		return __IrisDlgEventFuncName(SysDeadChar)(hDlg,wParam,lParam);
		*/

	// 
	case WM_INITDIALOG:
		{
			Attach(hDlg);
			::ShowWindow(hDlg,SW_SHOW);
		}
		return __IrisDlgEventFuncName(InitDialog)(hDlg,wParam,lParam);
	// R}h
	case WM_COMMAND:
		return __IrisDlgEventFuncName(Command)	(hDlg,wParam,lParam);
	// SYSR}h
	case WM_SYSCOMMAND:
		return __IrisDlgEventFuncName(SysCommand)(hDlg,wParam,lParam);
	// ^C}[
	case WM_TIMER:
		return __IrisDlgEventFuncName(Timer)	(hDlg,wParam,lParam);
	// XN[
	case WM_HSCROLL:
		return __IrisDlgEventFuncName(HScroll)	(hDlg,wParam,lParam);
	case WM_VSCROLL:
		return __IrisDlgEventFuncName(VScroll)	(hDlg,wParam,lParam);
#if	!defined(IRIS_WIN32_WCE)
	// j[\悤ƂƂɒʒm
	case WM_INITMENU:
		return __IrisDlgEventFuncName(InitMenu)	(hDlg,wParam,lParam);
#endif
	// |bvAbvj[\悤ƂƂɒʒm
	case WM_INITMENUPOPUP:
		return __IrisDlgEventFuncName(InitMenuPopup)(hDlg,wParam,lParam);
#if	!defined(IRIS_WIN32_WCE)
	// j[I
	case WM_MENUSELECT:
		return __IrisDlgEventFuncName(MenuSelect)	(hDlg,wParam,lParam);
#endif
	// j[ANeBuŁAj[̃ANZXL[̉pƈvȂ󂯎Ƃ
	// j[̃I[i[EBhEɑ
	// wParam 
	// <ʃ[h> 
	// ꂽL[̕R[h
	// 
	// @\ 
	// <ʃ[h> 
	// j[̃^Cv萔̑gݍ킹
	// 萔         l        e
	//----------------------------------------------------------------
	// MF_POPUP    &H10       |bvAbvj[
	// MF_SYSTEM   &H2000     VXej[
	//----------------------------------------------------------------
	// 
	// lParam 
	// ANeBuȃj[̃nh
	// 
	// ߂l 
	// ʃ[hɎ̒li[WindowsɕԂ
	// 萔         l      e
	//-----------------------------------------------------------------------
	// MNC_IGNORE   0       ꂽL[jAx炷(ftHg)
	// MNC_CLOSE    1       ANeBuȃj[N[Y
	// MNC_EXECUTE  2       ߂l̉ʃ[hŎw肷郁j[ڂj
	//                     I[i[EBhEWM_COMMAND𑗂
	// MNC_SELECT   3       ߂l̉ʃ[hŎw肷郁j[ڂI
	//-----------------------------------------------------------------------
	case WM_MENUCHAR:
		return __IrisDlgEventFuncName(MenuChar)	(hDlg,wParam,lParam);


#if	!defined(IRIS_WIN32_WCE)
	// D&D
	case WM_DROPFILES:
		return __IrisDlgEventFuncName(DropFiles)(hDlg,wParam,lParam);
#endif
	}
	return FALSE;
}

/**********************************************************************//*-
 *
 * Command
 *
*//***********************************************************************/
__IrisDlgEventFuncImpl(CDlgBase, Command)
{
	IRIS_UNUSED_VARIABLE(lParam);
	switch(LOWORD(wParam))
	{
	case IDOK:
	case IDCANCEL:
//		EndDialog(hDlg,IDCANCEL);
		::SendMessage(hDlg,WM_CLOSE,0,0);
		return TRUE;
	}
	return FALSE;
}

/**********************************************************************//*-
 *
 * NotifyFormat
 *
*//***********************************************************************/
__IrisDlgEventFuncImpl(CDlgBase, NotifyFormat)
{
	IRIS_UNUSED_VARIABLE(hDlg);
	IRIS_UNUSED_VARIABLE(wParam);
	IRIS_UNUSED_VARIABLE(lParam);
#if	!defined(IRIS_WIN32_WCE)
#ifdef _UNICODE
	return NFR_UNICODE;
#else
	return NFR_ANSI;
#endif
#else
	return 0;
#endif
}

}	// end of namespace wx
}	// end of namespace iris
