//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRegisterClass.cpp
 * @brief		RegisterClass NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXRegisterClass_CPP_

//======================================================================
// include
#include "WXRegisterClass.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CRegisterClass::CRegisterClass(void)
: m_Atom(0)
, m_hInstance(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CRegisterClass::~CRegisterClass(void)
{
	Delete();
}

/**********************************************************************//**
 *
 * 쐬
 * 
 -----------------------------------------------------------------------
 * @param	uStyle			= EBhENX̃X^C
 * @param	hInstance		= CX^Xnh
 * @param	wndproc			= EBhEvV[W
 * @param	hIcon			= ACR̃nh
 * @param	hCursor			= J[\̃nh
 * @param	hbrBackground	= wiF̃nh
 * @param	pClassName		= EBhENX̖O
 * @param	pMenuName		= NX̃j[̖O
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
template<>
ATOM CRegisterClass::Register<CHAR>(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCSTR pClassName
							   , LPCSTR pMenuName)
{
	WNDCLASSA wc = {0};// WNDCLASS \
	wc.style			= uStyle;			// EBhENX̃X^C
	wc.lpfnWndProc		= wndproc;			// EBhEvV[W
	wc.cbClsExtra		= 0;				// gp̃p[^
	wc.cbWndExtra		= 0;				// gp̃p[^
	wc.hInstance		= hInstance;		// CX^Xnh
	wc.hIcon			= hIcon;			// ACR̃nh
	wc.hCursor			= hCursor;			// J[\̃nh
	wc.hbrBackground	= hbrBackground;	// wiF̃nh
	wc.lpszMenuName		= pMenuName;		// NX̃j[̖O
	wc.lpszClassName	= pClassName;		// EBhENX̖O
	return RegisterClassA(&wc);
}
#endif
template<>
ATOM CRegisterClass::Register<WCHAR>(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCWSTR pClassName
							   , LPCWSTR pMenuName)
{
	WNDCLASSW wc = {0};// WNDCLASS \
	wc.style			= uStyle;			// EBhENX̃X^C
	wc.lpfnWndProc		= wndproc;			// EBhEvV[W
	wc.cbClsExtra		= 0;				// gp̃p[^
	wc.cbWndExtra		= 0;				// gp̃p[^
	wc.hInstance		= hInstance;		// CX^Xnh
	wc.hIcon			= hIcon;			// ACR̃nh
	wc.hCursor			= hCursor;			// J[\̃nh
	wc.hbrBackground	= hbrBackground;	// wiF̃nh
	wc.lpszMenuName		= pMenuName;		// NX̃j[̖O
	wc.lpszClassName	= pClassName;		// EBhENX̖O
	return RegisterClassW(&wc);
}

/**********************************************************************//**
 *
 * 쐬
 * 
 -----------------------------------------------------------------------
 * @param	uStyle			= EBhENX̃X^C
 * @param	hInstance		= CX^Xnh
 * @param	wndproc			= EBhEvV[W
 * @param	hIcon			= ACR̃nh
 * @param	hCursor			= J[\̃nh
 * @param	hbrBackground	= wiF̃nh
 * @param	pClassName		= EBhENX̖O
 * @param	pMenuName		= NX̃j[̖O
 * @param	hIconSm			= X[ACR̃nh
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
template<>
ATOM CRegisterClass::RegisterEx<CHAR>(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCSTR pClassName
							   , LPCSTR pMenuName, HICON hIconSm)
{
#if	defined(IRIS_WIN32_WCE)
	return Register(uStyle, hInstance, wndproc, hIcon, hCursor, hbrBackground, pClassName, pMenuName);
#else
	WNDCLASSEXA wcex = {0};// WNDCLASSEX\
	wcex.cbSize			= sizeof( wcex );	// WNDCLASSEX\̂̃TCY
	wcex.style			= uStyle;			// EBhENX̃X^C
	wcex.lpfnWndProc	= wndproc;			// EBhEvV[W
	wcex.cbClsExtra		= 0;				// gp̃p[^
	wcex.cbWndExtra		= 0;				// gp̃p[^
	wcex.hInstance		= hInstance;		// CX^Xnh
	wcex.hIcon			= hIcon;			// ACR̃nh
	wcex.hCursor		= hCursor;			// J[\̃nh
	wcex.hbrBackground	= hbrBackground;	// wiF̃nh
	wcex.lpszMenuName	= pMenuName;		// NX̃j[̖O
	wcex.lpszClassName	= pClassName;		// EBhENX̖O
	wcex.hIconSm		= hIconSm;			// X[ACR̃nh
	return RegisterClassExA(&wcex);
#endif
}
#endif
template<>
ATOM CRegisterClass::RegisterEx<WCHAR>(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCWSTR pClassName
							   , LPCWSTR pMenuName, HICON hIconSm)
{
#if	defined(IRIS_WIN32_WCE)
	return Register(uStyle, hInstance, wndproc, hIcon, hCursor, hbrBackground, pClassName, pMenuName);
#else
	WNDCLASSEXW wcex = {0};// WNDCLASSEX\
	wcex.cbSize			= sizeof( wcex );	// WNDCLASSEX\̂̃TCY
	wcex.style			= uStyle;			// EBhENX̃X^C
	wcex.lpfnWndProc	= wndproc;			// EBhEvV[W
	wcex.cbClsExtra		= 0;				// gp̃p[^
	wcex.cbWndExtra		= 0;				// gp̃p[^
	wcex.hInstance		= hInstance;		// CX^Xnh
	wcex.hIcon			= hIcon;			// ACR̃nh
	wcex.hCursor		= hCursor;			// J[\̃nh
	wcex.hbrBackground	= hbrBackground;	// wiF̃nh
	wcex.lpszMenuName	= pMenuName;		// NX̃j[̖O
	wcex.lpszClassName	= pClassName;		// EBhENX̖O
	wcex.hIconSm		= hIconSm;			// X[ACR̃nh
	return RegisterClassExW(&wcex);
#endif
}

/**********************************************************************//**
 *
 * 쐬
 * 
 -----------------------------------------------------------------------
 * @param	wc		= p[^
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
template<>
bool CRegisterClass::Create<WNDCLASSA>(LPWNDCLASSA wc)
{
	IRIS_ASSERT( wc != nullptr );
	ATOM atom = ::RegisterClassA( wc );
	return TryAttach(wc->hInstance, atom);
}
#endif
template<>
bool CRegisterClass::Create<WNDCLASSW>(LPWNDCLASSW wc)
{
	IRIS_ASSERT( wc != nullptr );
	ATOM atom = ::RegisterClassW( wc );
	return TryAttach(wc->hInstance, atom);
}
#if	!defined(IRIS_WIN32_WCE)
template<>
bool CRegisterClass::Create<WNDCLASSEXA>(LPWNDCLASSEXA wc)
{
	IRIS_ASSERT( wc != nullptr );
	ATOM atom = ::RegisterClassExA( wc );
	return TryAttach(wc->hInstance, atom);
}
template<>
bool CRegisterClass::Create<WNDCLASSEXW>(LPWNDCLASSEXW wc)
{
	IRIS_ASSERT( wc != nullptr );
	ATOM atom = ::RegisterClassExW( wc );
	return TryAttach(wc->hInstance, atom);
}
#endif

/**********************************************************************//**
 *
 * 쐬
 * 
 -----------------------------------------------------------------------
 * @param	wcex	= p[^
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
template<>
bool CRegisterClass::CreateEx<WNDCLASSEXA>(LPWNDCLASSEXA wcex)
{
	return Create(wcex);
}
template<>
bool CRegisterClass::CreateEx<WNDCLASSEXW>(LPWNDCLASSEXW wcex)
{
	return Create(wcex);
}
#endif

/**********************************************************************//**
 *
 * 쐬
 * 
 -----------------------------------------------------------------------
 * @param	uStyle			= EBhENX̃X^C
 * @param	hInstance		= CX^Xnh
 * @param	wndproc			= EBhEvV[W
 * @param	hIcon			= ACR̃nh
 * @param	hCursor			= J[\̃nh
 * @param	hbrBackground	= wiF̃nh
 * @param	pClassName		= EBhENX̖O
 * @param	pMenuName		= NX̃j[̖O
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
template<>
bool CRegisterClass::Create<CHAR>(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCSTR pClassName
							   , LPCSTR pMenuName)
{
	ATOM atom = Register(uStyle, hInstance, wndproc, hIcon, hCursor, hbrBackground, pClassName, pMenuName);
	return TryAttach(hInstance, atom);
}
#endif
template<>
bool CRegisterClass::Create<WCHAR>(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCWSTR pClassName
							   , LPCWSTR pMenuName)
{
	ATOM atom = Register(uStyle, hInstance, wndproc, hIcon, hCursor, hbrBackground, pClassName, pMenuName);
	return TryAttach(hInstance, atom);
}

/**********************************************************************//**
 *
 * 쐬
 * 
 -----------------------------------------------------------------------
 * @param	uStyle			= EBhENX̃X^C
 * @param	hInstance		= CX^Xnh
 * @param	wndproc			= EBhEvV[W
 * @param	hIcon			= ACR̃nh
 * @param	hCursor			= J[\̃nh
 * @param	hbrBackground	= wiF̃nh
 * @param	pClassName		= EBhENX̖O
 * @param	pMenuName		= NX̃j[̖O
 * @param	hIconSm			= X[ACR̃nh
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
template<>
bool CRegisterClass::CreateEx<CHAR>(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCSTR pClassName
							   , LPCSTR pMenuName, HICON hIconSm)
{
	ATOM atom = RegisterEx(uStyle, hInstance, wndproc, hIcon, hCursor, hbrBackground, pClassName, pMenuName, hIconSm);
	return TryAttach(hInstance, atom);
}
#endif
template<>
bool CRegisterClass::CreateEx<WCHAR>(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCWSTR pClassName
							   , LPCWSTR pMenuName, HICON hIconSm)
{
	ATOM atom = RegisterEx(uStyle, hInstance, wndproc, hIcon, hCursor, hbrBackground, pClassName, pMenuName, hIconSm);
	return TryAttach(hInstance, atom);
}

/**********************************************************************//**
 *
 * 폜
 * 
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CRegisterClass::Delete(void)
{
	HINSTANCE hInstance = m_hInstance;
	ATOM atom = Detach();
	if( atom == 0 ) return TRUE;
	return UnregisterClass((LPCTSTR)atom, hInstance);
}

/**********************************************************************//**
 *
 * Lǂ
 * 
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CRegisterClass::IsValid(void) const
{
	return m_Atom != 0;
}

/**********************************************************************//**
 *
 * ֘At
 * 
 -----------------------------------------------------------------------
 * @param [in]	hInstance	= CX^X
 * @param [in]	atom		= ATOM
 * @return	
*//***********************************************************************/
bool CRegisterClass::Attach(HINSTANCE hInstance, ATOM atom)
{
	if( IsValid() ) return false;
	if( atom == 0 ) return false;
	m_Atom = atom;
	m_hInstance = hInstance;
	return true;
}

/**********************************************************************//**
 *
 * ֘At
 * 
 -----------------------------------------------------------------------
 * @param [in]	hInstance	= CX^X
 * @param [in]	atom		= ATOM
 * @return	
*//***********************************************************************/
bool CRegisterClass::TryAttach(HINSTANCE hInstance, ATOM atom)
{
	if( !Attach(hInstance, atom) ) 
	{
		UnregisterClass((LPCTSTR)atom, hInstance);
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * ֘At
 * 
 -----------------------------------------------------------------------
 * @return	ȑO ATOM
*//***********************************************************************/
ATOM CRegisterClass::Detach(void)
{
	ATOM atom = m_Atom;
	m_Atom = 0;
	m_hInstance = nullptr;
	return atom;
}

}	// end of namespace wx
}	// end of namespace iris

