//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRegisterClass.h
 * @brief		RegisterClass NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXRegisterClass_H_
#define INCG_IRIS_WXRegisterClass_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	RegisterClass NX
*/
class CRegisterClass : public IIrisObject
{
protected:
	ATOM		m_Atom;		//!< atom
	HINSTANCE	m_hInstance;

public:
	// RXgN^
	CRegisterClass(void);
	// fXgN^
	~CRegisterClass(void);

public:
	template<typename CHARTYPE_>
	static ATOM	Register(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, const CHARTYPE_* pClassName
							   , const CHARTYPE_* pMenuName = nullptr);

	template<typename CHARTYPE_>
	static ATOM	RegisterEx(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, const CHARTYPE_* pClassName
							   , const CHARTYPE_* pMenuName = nullptr, HICON hIconSm = nullptr);

public:
	// 쐬
	template<typename TN>
	bool	Create(TN* wc);
	template<typename TN>
	bool	CreateEx(TN* wcex);

	template<typename CHARTYPE_>
	bool	Create(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, const CHARTYPE_* pClassName
							   , const CHARTYPE_* pMenuName = nullptr);

	template<typename CHARTYPE_>
	bool	CreateEx(UINT uStyle, HINSTANCE hInstance, WNDPROC wndproc
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, const CHARTYPE_* pClassName
							   , const CHARTYPE_* pMenuName = nullptr, HICON hIconSm = nullptr);

public:
	// 폜
	BOOL	Delete(void);

public:
	// Lǂ
	bool	IsValid(void) const;

public:
	// ֘At
	bool	Attach(HINSTANCE hInstance, ATOM atom);
	bool	TryAttach(HINSTANCE hInstance, ATOM atom);
	// ֘At
	ATOM	Detach(void);

};

}	// end of namespace wx
}	// end of namespace iris

#endif
