//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXConsole.cpp
 * @brief		R\[NX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXConsole_CPP_

//======================================================================
// include
#include <string>
#include "WXConsole.h"
#include "../os/modules/WXKernel.h"
#include "../wx_inchead.h"
#include <tchar.h>

#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * R\[EBhẼEBhEnh擾
 *
 -----------------------------------------------------------------------
 * @return	EBhEnh
*//***********************************************************************/
HWND GetConsoleWindow(void)
{
	HWND hWnd = nullptr;
#if(_WIN32_WINNT >= 0x0500)
	hWnd = ::GetConsoleWindow();
	if( hWnd != nullptr ) return hWnd;
#endif
	int cnt = 20;
	TCHAR csl_title_bef[1024];
	TCHAR csl_title[64];
	wsprintf(csl_title, IRIS_TEXT("%d/%d"), GetTickCount(), GetCurrentProcessId());
	GetConsoleTitle(csl_title_bef, 1024);
	SetConsoleTitle(csl_title);
	while(cnt--)
	{
		Sleep(40);
		hWnd = FindWindow(nullptr, csl_title);
		if( hWnd != nullptr ) break;
	}
	SetConsoleTitle(csl_title_bef);
	return hWnd;
}

//======================================================================
// class

// CConsoleHandle
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CConsoleHandle::CConsoleHandle(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CConsoleHandle::CConsoleHandle(HANDLE hObject)
: CHandle(hObject)
{
}

/**********************************************************************//**
 *
 * XN[obt@̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pcsbi = XN[obt@
 * @return	
*//***********************************************************************/
BOOL CConsoleHandle::GetScreenBufferInfo(PCONSOLE_SCREEN_BUFFER_INFO pcsbi)
{
	return ::GetConsoleScreenBufferInfo(m_hObject, pcsbi);
}

/**********************************************************************//**
 *
 * XN[obt@̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pcsbi = XN[obt@
 * @return	
*//***********************************************************************/
BOOL CConsoleHandle::GetScreenBufferInfoEx(PCONSOLE_SCREEN_BUFFER_INFOEX pcsbi)
{
	IRIS_ASSERT( pcsbi != nullptr );
	pcsbi->cbSize = sizeof(CONSOLE_SCREEN_BUFFER_INFOEX);
	return CKernel::GetConsoleScreenBufferInfoEx(m_hObject, pcsbi);
}

/**********************************************************************//**
 *
 * XN[obt@̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [out]	pcsbi = XN[obt@
 * @return	
*//***********************************************************************/
BOOL CConsoleHandle::SetScreenBufferInfoEx(PCONSOLE_SCREEN_BUFFER_INFOEX pcsbi)
{
	return CKernel::SetConsoleScreenBufferInfoEx(m_hObject, pcsbi);
}

/**********************************************************************//**
 *
 * XN[obt@TCY̎擾
 *
 -----------------------------------------------------------------------
 * @return	XN[obt@TCY
*//***********************************************************************/
COORD CConsoleHandle::GetScreenBufferSize(void)
{
	CONSOLE_SCREEN_BUFFER_INFO csbi;
	GetScreenBufferInfo(&csbi);
	return csbi.dwSize;
}

/**********************************************************************//**
 *
 * XN[obt@TCY̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	dwSize = XN[obt@TCY
 * @return	
*//***********************************************************************/
BOOL CConsoleHandle::SetScreenBufferSize(COORD dwSize)
{
	return ::SetConsoleScreenBufferSize(m_hObject, dwSize);
}

/**********************************************************************//**
 *
 * eLXgJ[̕ύX
 *
 -----------------------------------------------------------------------
 * @param [in]	wAttributes = eLXgƔwi̐F
 * @return	
*//***********************************************************************/
BOOL	CConsoleHandle::SetTextAttribute(WORD wAttributes)	
{
	return ::SetConsoleTextAttribute(m_hObject, wAttributes);
}

/**********************************************************************//**
 *
 * eLXgJ[̎擾
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
WORD	CConsoleHandle::GetTextAttribute(void)	
{
	CONSOLE_SCREEN_BUFFER_INFO csbi;
	if( !GetScreenBufferInfo(&csbi) ) return FOREGROUND_BLUE|FOREGROUND_GREEN|FOREGROUND_RED;
	return csbi.wAttributes;
}

BOOL	CConsoleHandle::ReadConsoleA(LPVOID lpBuf, DWORD dwRead, LPDWORD lpRead, PCONSOLE_READCONSOLE_CONTROL lpInputControl)
															{ return ::ReadConsoleA(m_hObject, lpBuf, dwRead, lpRead, lpInputControl); }
BOOL	CConsoleHandle::ReadConsoleW(LPVOID lpBuf, DWORD dwRead, LPDWORD lpRead, PCONSOLE_READCONSOLE_CONTROL lpInputControl)
															{ return ::ReadConsoleW(m_hObject, lpBuf, dwRead, lpRead, lpInputControl); }
BOOL	CConsoleHandle::ReadConsoleInputA(PINPUT_RECORD lpBuf, DWORD dwLength, LPDWORD lpRead)
															{ return ::ReadConsoleInputA(m_hObject, lpBuf, dwLength, lpRead); }
BOOL	CConsoleHandle::ReadConsoleInputW(PINPUT_RECORD lpBuf, DWORD dwLength, LPDWORD lpRead)
															{ return ::ReadConsoleInputA(m_hObject, lpBuf, dwLength, lpRead); }
BOOL	CConsoleHandle::ReadConsoleOutputA(PCHAR_INFO lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion)
															{ return ::ReadConsoleOutputA(m_hObject, lpBuf, dwSize, dwCoord, lpRegion); }
BOOL	CConsoleHandle::ReadConsoleOutputW(PCHAR_INFO lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion)
															{ return ::ReadConsoleOutputW(m_hObject, lpBuf, dwSize, dwCoord, lpRegion); }

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	lpBuf		= obt@
 * @param [in]	dwWrite		= ޕ
 * @param [in]	lpWritten	= ܂ꂽւ̃|C^
 * @param [in]	lpReserved	= 
 * @return	
*//***********************************************************************/
template<>
BOOL	CConsoleHandle::Write<CHAR>(LPCSTR lpBuf, DWORD dwWrite, LPDWORD lpWritten, LPVOID lpReserved)
{
	return ::WriteConsoleA(m_hObject, lpBuf, dwWrite, lpWritten, lpReserved);
}
template<>
BOOL	CConsoleHandle::Write<WCHAR>(LPCWSTR lpBuf, DWORD dwWrite, LPDWORD lpWritten, LPVOID lpReserved)
{
	return ::WriteConsoleW(m_hObject, lpBuf, dwWrite, lpWritten, lpReserved);
}
template<>
BOOL	CConsoleHandle::Write<VOID>(const void* lpBuf, DWORD dwWrite, LPDWORD lpWritten, LPVOID lpReserved)
{
	return ::WriteConsole(m_hObject, lpBuf, dwWrite, lpWritten, lpReserved);
}
BOOL	CConsoleHandle::WriteConsoleInputA(const INPUT_RECORD* lpBuf, DWORD dwWrite, LPDWORD lpWritten)
															{ return ::WriteConsoleInputA(m_hObject, lpBuf, dwWrite, lpWritten); }
BOOL	CConsoleHandle::WriteConsoleInputW(const INPUT_RECORD* lpBuf, DWORD dwWrite, LPDWORD lpWritten)
															{ return ::WriteConsoleInputW(m_hObject, lpBuf, dwWrite, lpWritten); }
BOOL	CConsoleHandle::WriteConsoleOutputA(const CHAR_INFO* lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion)
															{ return ::WriteConsoleOutputA(m_hObject, lpBuf, dwSize, dwCoord, lpRegion); }
BOOL	CConsoleHandle::WriteConsoleOutputW(const CHAR_INFO* lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion)
															{ return ::WriteConsoleOutputW(m_hObject, lpBuf, dwSize, dwCoord, lpRegion); }


// CConsole

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CConsole::CConsole(void)
: m_hConsole(nullptr)
, m_hCurrent(nullptr)
, m_stdout(nullptr)
, m_stdin(nullptr)
, m_stderr(nullptr)
, m_PageNo(PAGE_DEFAULT)
, m_bExist(false)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CConsole::~CConsole(void)
{
	Close();
}

/**********************************************************************//**
 *
 * R\[J
 *
 -----------------------------------------------------------------------
 * @param [in]	std = std::cout, std::cin̏óE͕ύXsǂ
 * @return	
*//***********************************************************************/
bool CConsole::Open(bool std)
{
	AddRef();
	if( m_hConsole != nullptr ) return true;
	m_hConsole = GetStdHandle(STD_OUTPUT_HANDLE);
	if( m_hConsole != nullptr )
	{
		m_bExist = true;
	}
	else
	{
		if( AllocConsole() == FALSE) 
		{
			printf("AllocConsole failed.\n");
		}
		m_hConsole = GetStdHandle(STD_OUTPUT_HANDLE);
	}
	m_Page.insert(PAGEPAIR(PAGE_DEFAULT, m_hConsole));
	m_hCurrent = m_hConsole;
	m_PageNo = PAGE_DEFAULT;
	if( std )
	{
		freopen_s(&m_stdout, "CON", "w", stdout);
		freopen_s(&m_stdin , "CON", "r", stdin);
		freopen_s(&m_stderr, "CON", "w", stderr);
	}
	return true;
}

/**********************************************************************//**
 *
 * R\[
 *
*//***********************************************************************/
void CConsole::Close(void)
{
	if( m_hConsole == nullptr ) return;
	SubRef();
	if( GetRef() > 0 ) 
	{
		return;
	}

	for( PAGE::iterator it = m_Page.begin(); it != m_Page.end(); ++it )
	{
		if( it->second != m_hConsole )
			CloseHandle( it->second );
	}

	if( m_stdout != nullptr )
	{
		//fclose(m_stdout);
		m_stdout = nullptr;
	}
	if( m_stdin != nullptr )
	{
		//fclose(m_stdin);
		m_stdin = nullptr;
	}
	if( m_stderr != nullptr )
	{
		//fclose(m_stderr);
		m_stderr = nullptr;
	}

	if( !m_bExist )
	{
		FreeConsole();
	}
	m_bExist = false;
	m_hConsole.Detach();
	m_hCurrent.Detach();
}

/**********************************************************************//**
 *
 * o
 *
 -----------------------------------------------------------------------
 * @param [in]	format	= o͕
 * @param [in]	va		= 
*//***********************************************************************/
template<>
void CConsole::Print<CHAR>(LPCSTR format, va_list va )
{
	DWORD write=0;
	int size = 64;	// K
	LPSTR buf = nullptr;
	for( int i=0; i < 2; ++i )
	{
		buf = new CHAR [size];
		if( buf == nullptr ) return;
		int ret = _vsnprintf_s(buf, size, _TRUNCATE, format, va);
		if( ret >= 0 && ret < size )
		{
			size = ret;
			break;
		}
		size = _vscprintf(format,va) + 1;
		delete [] buf;
		buf = nullptr;
	}

	if( buf != nullptr ) 
	{
		if( m_hConsole == nullptr )
		{
			OutputDebugStringA(buf);
			//printf( buf );
		}
		else
		{
			::WriteConsoleA(m_hCurrent, buf, size, &write, nullptr);
		}
		delete [] buf;
	}
}
/// CConsole::Print Q
template<>
void CConsole::Print<WCHAR>(LPCWSTR format, va_list va )
{
	DWORD write=0;
	int size = 64;	// K
	LPWSTR buf = nullptr;
	for( int i=0; i < 2; ++i )
	{
		buf = new WCHAR [size];
		if( buf == nullptr ) return;
		int ret = _vsnwprintf_s(buf, size, _TRUNCATE, format, va);
		if( ret >= 0 && ret < size )
		{
			size = ret;
			break;
		}
		size = _vscwprintf(format, va) + 1;
		delete [] buf;
		buf = nullptr;
	}

	if( buf != nullptr ) 
	{
		if( m_hConsole == nullptr )
		{
			OutputDebugStringW(buf);
			//wprintf( buf );
		}
		else
		{
			::WriteConsoleW(m_hCurrent, buf, size, &write, nullptr);
		}
		delete [] buf;
	}
}

/**********************************************************************//**
 *
 * y[Wǉ
 *
 -----------------------------------------------------------------------
 * @param [in]	page		= y[WID
 * @param [in]	dwAccess	= ANZX(GENERIC_READ,GENERIC_WRITE)
 * @param [in]	dwShareMode	= L@(FILE_SHARE_READ,FILE_SHARE_WRITE)
 * @param [in]	lpAttributes= 
 * @return	
*//***********************************************************************/
bool CConsole::AddPage(int page, DWORD dwAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpAttributes)
{
	PAGE::iterator it = m_Page.find(page);
	if( it != m_Page.end() ) 
	{
		printf("y[W͂łɑ݂܂B%d.\n", page);
		return false;
	}
	HANDLE hdl = CreateConsoleScreenBuffer(dwAccess,dwShareMode,lpAttributes,CONSOLE_TEXTMODE_BUFFER,nullptr);
	if( hdl == INVALID_HANDLE_VALUE ) 
	{
		printf("y[W̍쐬Ɏs܂B\n", page);
		return false;
	}
	m_Page.insert(PAGEPAIR(page,hdl));
	return true;
}

/**********************************************************************//**
 *
 * y[W폜
 *
 -----------------------------------------------------------------------
 * @param [in]	page		= y[WID
 * @return	
*//***********************************************************************/
bool CConsole::DelPage(int page)
{
	PAGE::iterator it = m_Page.find(page);
	if( it != m_Page.end() ) return false;
	HANDLE hdl = it->second;
	if( hdl == m_hConsole ) return false;
	CloseHandle(hdl);
	m_Page.erase(it);
	return true;
}

/**********************************************************************//**
 *
 * y[Wݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	page		= y[WID
 * @return	
*//***********************************************************************/
bool CConsole::SetPage(int page)
{
	if( m_PageNo == page ) return true;
	HANDLE hdl = GetHandle(page);
	if( hdl == nullptr ) 
	{
		printf("page݂܂B%d.\n", page);
		return false;
	}
	if( !SetConsoleActiveScreenBuffer(hdl) )
	{
		printf("page̐ݒɎs܂B%d.\n", page);
		return false;
	}
	m_hCurrent = hdl;
	TCHAR title[MAX_PATH<<1];
	GetConsoleTitle(title,MAX_PATH<<1);
	LPTSTR p = _tcsstr(title,TEXT("(PAGE"));
	if( p != nullptr ) *p = TEXT('\0');
	TCHAR page_str[64];
	wsprintf(page_str,TEXT("(PAGE:%d)"), page);
	_tcscat_s(title,MAX_PATH<<1,page_str);
	SetConsoleTitle(title);
	m_PageNo = page;
	return true;
}

/**********************************************************************//**
 *
 * nh擾
 *
 -----------------------------------------------------------------------
 * @param [in]	page		= y[WID
 * @return	nh
*//***********************************************************************/
HANDLE CConsole::GetHandle(int page)
{
	PAGE::iterator it = m_Page.find(page);
	if( it == m_Page.end() ) return nullptr;
	return it->second;
}

/**********************************************************************//**
 *
 * EBhEnh擾
 *
 -----------------------------------------------------------------------
 * @return	EBhEnh
*//***********************************************************************/
HWND CConsole::GetHWND(void)
{
	return GetConsoleWindow();
}

/**********************************************************************//**
 *
 * eEBhE̐ݒ
 *
 -----------------------------------------------------------------------
 * @parma [in]	hWndNewParent	= VKeEBhEnh
 * @return	EBhEnh
*//***********************************************************************/
HWND CConsole::SetParent(HWND hWndNewParent)
{
	return ::SetParent(GetHWND(), hWndNewParent);
}

/**********************************************************************//*-
 *
 * bp[֐
 *
*//***********************************************************************/
DWORD	CConsole::GetConsoleTitleA(LPSTR  lpTitle, DWORD dwSize)	const	{ return ::GetConsoleTitleA(lpTitle, dwSize); }
DWORD	CConsole::GetConsoleTitleW(LPWSTR lpTitle, DWORD dwSize)	const	{ return ::GetConsoleTitleW(lpTitle, dwSize); }
BOOL	CConsole::SetConsoleTitleA(LPCSTR  lpTitle)							{ return ::SetConsoleTitleA(lpTitle); }
BOOL	CConsole::SetConsoleTitleW(LPCWSTR lpTitle)							{ return ::SetConsoleTitleW(lpTitle); }
BOOL	CConsole::FlushInputBuffer(void)					{ return ::FlushConsoleInputBuffer(GetStdHandle(STD_INPUT_HANDLE)); }
BOOL	CConsole::GetNumberOfInputEvents(LPDWORD lpNumberOfEvents)
															{ return ::GetNumberOfConsoleInputEvents(m_hCurrent, lpNumberOfEvents); }

BOOL	CConsole::SetCtrlHandler(PHANDLER_ROUTINE Handler, BOOL Add)
															{ return ::SetConsoleCtrlHandler(Handler,Add); }
BOOL	CConsole::AddCtrlHandler(PHANDLER_ROUTINE Handler)	{ return ::SetConsoleCtrlHandler(Handler,1); }
BOOL	CConsole::DelCtrlHandler(PHANDLER_ROUTINE Handler)	{ return ::SetConsoleCtrlHandler(Handler,0); }
UINT	CConsole::GetCP(void)	const						{ return ::GetConsoleCP(); }
BOOL	CConsole::SetCP(UINT CodePageID)					{ return ::SetConsoleCP(CodePageID); }
BOOL	CConsole::ReadConsoleA(LPVOID lpBuf, DWORD dwRead, LPDWORD lpRead, PCONSOLE_READCONSOLE_CONTROL lpInputControl)
															{ return ::ReadConsoleA(GetStdHandle(STD_INPUT_HANDLE), lpBuf, dwRead, lpRead, lpInputControl); }
BOOL	CConsole::ReadConsoleW(LPVOID lpBuf, DWORD dwRead, LPDWORD lpRead, PCONSOLE_READCONSOLE_CONTROL lpInputControl)
															{ return ::ReadConsoleW(GetStdHandle(STD_INPUT_HANDLE), lpBuf, dwRead, lpRead, lpInputControl); }
BOOL	CConsole::ReadConsoleInputA(PINPUT_RECORD lpBuf, DWORD dwLength, LPDWORD lpRead)
															{ return m_hCurrent.ReadConsoleInputA(lpBuf, dwLength, lpRead); }
BOOL	CConsole::ReadConsoleInputW(PINPUT_RECORD lpBuf, DWORD dwLength, LPDWORD lpRead)
															{ return m_hCurrent.ReadConsoleInputA(lpBuf, dwLength, lpRead); }
BOOL	CConsole::ReadConsoleOutputA(PCHAR_INFO lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion)
															{ return m_hCurrent.ReadConsoleOutputA(lpBuf, dwSize, dwCoord, lpRegion); }
BOOL	CConsole::ReadConsoleOutputW(PCHAR_INFO lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion)
															{ return m_hCurrent.ReadConsoleOutputW(lpBuf, dwSize, dwCoord, lpRegion); }
BOOL	CConsole::WriteConsoleInputA(const INPUT_RECORD* lpBuf, DWORD dwWrite, LPDWORD lpWritten)
															{ return m_hCurrent.WriteConsoleInputA(lpBuf, dwWrite, lpWritten); }
BOOL	CConsole::WriteConsoleInputW(const INPUT_RECORD* lpBuf, DWORD dwWrite, LPDWORD lpWritten)
															{ return m_hCurrent.WriteConsoleInputW(lpBuf, dwWrite, lpWritten); }
BOOL	CConsole::WriteConsoleOutputA(const CHAR_INFO* lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion)
															{ return m_hCurrent.WriteConsoleOutputA(lpBuf, dwSize, dwCoord, lpRegion); }
BOOL	CConsole::WriteConsoleOutputW(const CHAR_INFO* lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion)
															{ return m_hCurrent.WriteConsoleOutputW(lpBuf, dwSize, dwCoord, lpRegion); }


}	// end of namespace wx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "unit/UnitCore.h"
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CConsole, Func)
{
	CConsole con;
	con.Open();

	WORD attr = con.GetCurrentHandle().GetTextAttribute();

	con.GetCurrentHandle().SetTextAttribute(FOREGROUND_GREEN);
	con.WriteLine("green");
	con.GetCurrentHandle().SetTextAttribute(FOREGROUND_RED);
	con.WriteLine("red");
	con.GetCurrentHandle().SetTextAttribute(attr);
}

#endif
