//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXError.h
 * @brief		error t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXError_H_
#define INCG_IRIS_WXError_H_

//======================================================================
// include
#include "../../../../fnd/container/FndAutoPtr.h"
#include "../container/WXLiberator.h"

namespace iris {
namespace wx
{

//======================================================================
// typedef
/// GetLastError ̖߂l^
typedef DWORD	LASTERROR;

//======================================================================
// class
/**
 * @brief	XR[vLG[萔NX
 * @details	(@ref section_atuoexp_CScopedLastError "autoexp")
 * @note	EHb` "@err,hr" Ɠ GetLastError ̕񂪌܂
*/
class CScopedLastError : public IIrisObject
{
	LASTERROR	m_LastError;	//!< LastError l
public:
	/// RXgN^
	CScopedLastError(void)
	{
		m_LastError = ::GetLastError();
	}
	/// fXgN^
	~CScopedLastError(void)
	{
		::SetLastError(m_LastError);
	}
public:
	operator LASTERROR (void) const	{ return m_LastError; }
};

/**
 * @brief	LASTERROR NX
 * @details	(@ref section_atuoexp_CScopedLastError "autoexp")
*/
class CLastError : public IIrisObject
{
public:
	typedef fnd::CAutoPtr<TCHAR, CLocalMemLiberator>	String;		//!< ^
	typedef fnd::CAutoPtr<CHAR , CLocalMemLiberator>	StringA;	//!< }`oCg^
	typedef fnd::CAutoPtr<WCHAR, CLocalMemLiberator>	StringW;	//!< Ch^

private:
	LASTERROR	m_LastError;	//!< LastError l

public:
	/**
	 * @name RXgN^
	 * @{
	*/
	CLastError(void) : m_LastError(0) { m_LastError = CScopedLastError(); }
	CLastError(LASTERROR error) : m_LastError(error) {  }
	/**
	 * @}
	*/


public:
	/**
	 * @name G[̎擾
	 * @{
	*/
	String		ToString (void)	const	{ return GetErrorString (m_LastError); }
	StringA		ToStringA(void)	const	{ return GetErrorStringA(m_LastError); }
	StringW		ToStringW(void)	const	{ return GetErrorStringW(m_LastError); }
	/**
	 * @}
	*/

public:
	operator	LASTERROR (void) const	{ return m_LastError; }
	LASTERROR	operator ()(void) const { return m_LastError; }

	CLastError& operator = (LASTERROR err)	{ m_LastError = err; return *this; }
public:
	//! G[萔G[̎擾
	String		GetErrorString (LASTERROR error) const
	{
#ifdef UNICODE
		return GetErrorStringW(error);
#else
		return GetErrorStringA(error);
#endif
	}
	//! @ref	GetErrorString 
	StringA		GetErrorStringA(LASTERROR error) const
	{
		LPSTR pString = nullptr;
#if !defined(IRIS_WIN32_WCE)
		FormatMessageA(
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			nullptr,
			error,
			0,
			//MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ftHg [U[ 
			(LPSTR)&pString,
			0,
			nullptr );
#endif
		return StringA(pString);
	}

	//! @ref	GetErrorString 
	StringW		GetErrorStringW(LASTERROR error) const
	{
		LPWSTR pString = nullptr;
		FormatMessageW(
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			nullptr,
			error,
			0,
			//MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ftHg [U[ 
			(LPWSTR)&pString,
			0,
			nullptr );
		return StringW(pString);
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif

/**
 * @addtogroup	autoexp
 * @{
 * @addtogroup	Visualizer
 * @section		section_atuoexp_CScopedLastError	; iris::wx::CScopedLastError|iris::wx::CLastError
 * @code
;------------------------------------------------------------------------------
; iris::wx::CScopedLastError|iris::wx::CLastError
;------------------------------------------------------------------------------ 
iris::wx::CScopedLastError|iris::wx::CLastError {
	children
	(
		#(
			[actual members]: [$e,!],
			LASTERROR : $e.m_LastError,
			VALUE : @err, $e.m_LastError
		)
	)
	preview
	(
		$e.m_LastError
	)
}
 * @endcode
 * @}
*/