//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHandle.h
 * @brief		nhx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXHandle_H_
#define INCG_IRIS_WXHandle_H_

//======================================================================
// include
#include "../../../../iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! nhNXC^[tFCX
class IHandle : public IIrisObject
{
public:
	virtual ~IHandle(void) {}
public:
	virtual	bool	Close(void) = 0;
};

//! nhNXx[X
template<typename TN>
class IHandleBase : public IHandle
{
protected:
	typedef TN				_MyHandle;
	typedef IHandleBase<TN>	_Myt;
public:
	typedef TN				HandleType;

protected:
	_MyHandle	m_hObject;	//!< nh
public:
	/// RXgN^
	IHandleBase(void)
		: m_hObject(nullptr)		{}
	/// RXgN^
	IHandleBase(_MyHandle hObject)
		: m_hObject(nullptr)		{ Attach(hObject); }

	_MyHandle	GetHandle(void)	const			{ return m_hObject; }
	operator	_MyHandle	(void)	const		{ return GetHandle(); }
	_MyHandle	operator	() (void)	const	{ return GetHandle(); }
	_Myt&		operator	= (_MyHandle hdl)	{ Attach(hdl); return *this; }
public:
	/// nh֘At
	BOOL	Attach(_MyHandle hObject)
	{
		if( hObject == nullptr || m_hObject != nullptr ) return FALSE;
		m_hObject = hObject;
		return TRUE;
	}
	/// nh̊֘At
	_MyHandle	Detach(void)
	{
		_MyHandle hPre = m_hObject;
		m_hObject = nullptr;
		return hPre;
	}
	/// ֘At̎s
	virtual	BOOL	TryAttach(_MyHandle hObject)
	{
		if( Attach(hObject) ) return TRUE;
		_MyHandle hTemp = Detach();
		Attach(hObject);
		Close();
		Attach(hTemp);
		return FALSE;
	}

public:
	// Rs[쐬
	BOOL	Duplicate(HANDLE hSrcProcess, HANDLE hTargetProcess, LPHANDLE lpTargetHandle, DWORD dwDesiredAccess, BOOL bInherit, DWORD dwOptions=DUPLICATE_SAME_ACCESS)
	{
		return ::DuplicateHandle(hSrcProcess, m_hObject, hTargetProcess, lpTargetHandle, dwDesiredAccess, bInherit, dwOptions);
	}
};

//! nhNX
class CHandle : public IHandleBase<HANDLE>, public INonCopyable<CHandle>
{
public:
	/// RXgN^
	CHandle(void)					{}
	/// RXgN^
	CHandle(HANDLE hObject)	: IHandleBase<HANDLE>(hObject)	{}
	
	/// fXgN^
	virtual ~CHandle(void)			{ Close(); }

	CHandle&	operator	= (HANDLE hdl)		{ Attach(hdl); return *this; }
	
public:
	/// ֘At̎s
	virtual	BOOL	TryAttach(HANDLE hObject)
	{
		if( Attach(hObject) ) return TRUE;
		CloseHandle(hObject);
		return FALSE;
	}

public:
	/// Lȃnhǂ
	bool	IsValid(void)	const	{ return (m_hObject != nullptr && m_hObject != INVALID_HANDLE_VALUE); }

public:
#if	!defined(IRIS_WIN32_WCE)
	/// nh̎擾
	BOOL	GetInformation(LPDWORD lpdwFlags)			const	{ return ::GetHandleInformation(m_hObject, lpdwFlags); }
	/// nh̐ݒ
	BOOL	SetInformation(DWORD dwMask, DWORD dwFlags)			{ return ::SetHandleInformation(m_hObject, dwMask, dwFlags); }
#endif

public:
#if	!defined(IRIS_WIN32_WCE)
	/// nh݂Ă邩
	virtual BOOL	IsExist(void)	const	{ if( !IsValid() ) return false; DWORD dwFlags=0; return GetInformation(&dwFlags); }
#else
	virtual BOOL	IsExist(void)	const	{ return IsValid(); }
#endif

public:
	/// 
	virtual	bool	Close(void)				{ return IRIS_TO_bool(CloseHandle( Detach() )); }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
