//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCom.h
 * @brief		ComIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXCom_CPP_

//======================================================================
// include
#include "WXCom.h"
#include <stdio.h>

namespace iris {
namespace wx 
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCom::CCom(void)
: m_bInit(false)
{
	CoInitialize();
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCom::~CCom(void)
{
	CoUninitialize();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CCom::CoInitialize(void)
{
#if	defined(IRIS_WIN32_WCE)
	return CoInitializeEx(COINIT_APARTMENTTHREADED);
#else
	if( m_bInit ) return S_OK;
	HRESULT hr = ::CoInitialize(nullptr);
	if( FAILED(hr) )
	{
		puts("failed CoInitialize.");
		return hr;
	}
	m_bInit = true;
	return hr;
#endif
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	dwCoInit	= }XN
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CCom::CoInitializeEx(DWORD dwCoInit)
{
#if (_WIN32_WINNT >= 0x0400 ) || defined(_WIN32_DCOM) // DCOM
	if( m_bInit ) return S_OK;
	HRESULT hr = ::CoInitializeEx(nullptr, dwCoInit);
	if( FAILED(hr) )
	{
		puts("failed CoInitializeEx.");
		return hr;
	}
	m_bInit = true;
	return hr;
#else
	return CoInitialize();
#endif
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CCom::CoUninitialize(void)
{
	if( m_bInit )	::CoUninitialize();
}

/**********************************************************************//**
 *
 * CoCreateInstance
 *
*//***********************************************************************/
HRESULT CCom::CoCreateInstance(REFCLSID rclsid, LPUNKNOWN pUnkOuter, DWORD dwClsContext, REFIID riid, LPVOID* ppv)
{
	return ::CoCreateInstance(rclsid, pUnkOuter, dwClsContext, riid, ppv);
}

}	// end of namespace wx
}	// end of namespace iris
