//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXComObj.h
 * @brief		ComIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXComObj_H_
#define INCG_IRIS_WXComObj_H_

//======================================================================
// include
#include "WXCom.h"

namespace iris {
namespace wx 
{

//======================================================================
// class
//! Com IuWFNgNX
template<typename IT>
class CComObj : public IIrisObject
{
	typedef IT		value_type;
	typedef IT		*value_ptr;

	friend class CComObj;

protected:
	value_ptr		m_pObj;	//!< C^[tFCXCX^X
	CCom			m_Com;
public:
    /// RXgN^
	CComObj(void) : m_pObj(nullptr) {}
    /// fXgN^
	virtual ~CComObj(void) { IRIS_SAFE_RELEASE(m_pObj); }

public:
	/**
	 * @brief	쐬
	*/
	HRESULT	Create(REFCLSID rclsid, LPUNKNOWN pUnkOuter, DWORD dwClsContext, REFIID riid)
	{
		HRESULT hr = CCom::CoCreateInstance(rclsid, pUnkOuter, dwClsContext, riid, (void**)&m_pObj);
		return hr;
	}

	/**
	 * @brief	
	*/
	template<typename IT2>
	HRESULT	QueryInterface(REFIID riid, CComObj<IT2>& obj)
	{
		if( m_pObj == nullptr ) return E_POINTER;
		return m_pObj->QueryInterface(riid, (void**)&obj.m_pObj);
	}

public:
	/**
	 * @name	operator
	 * @{
	*/
			value_ptr	operator ->	(void)			{ return m_pObj; }
	const	value_ptr	operator ->	(void)	const	{ return m_pObj; }
			value_ptr	operator ()	(void)			{ return m_pObj; }
	const	value_ptr	operator ()	(void)	const	{ return m_pObj; }
	/**
	 * @}
	*/
};

}	// end of namespace wx
}	// end of namespace iris

#endif
