//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMenu.cpp
 * @brief		Menu t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMenu_CPP_

//======================================================================
// include
#include "WXMenu.h"
#if	defined(IRIS_WIN32_WCE)
#include <commctrl.h>
#endif
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
static UINT _GetMenuBarStringA(HMENU hMenu, UINT uID, LPSTR  lpString, UINT uSize, UINT fMask, BOOL fByPosition);
static UINT _GetMenuBarStringW(HMENU hMenu, UINT uID, LPWSTR lpString, UINT uSize, UINT fMask, BOOL fByPosition);
static UINT _GetMenuBarString (HMENU hMenu, UINT uID, LPTSTR lpString, UINT uSize, UINT fMask, BOOL fByPosition)
{
#ifdef UNICODE
	return _GetMenuBarStringW(hMenu, uID, lpString, uSize, fMask, fByPosition);
#else
	return _GetMenuBarStringA(hMenu, uID, lpString, uSize, fMask, fByPosition);
#endif
}

//======================================================================
// function

/**********************************************************************//**
 *
 * 擾
 *	hMenuȉׂ̂Ă
 ----------------------------------------------------------------------
 * @param [in]	hMenu		= Ώۃj[
 * @param [in]	uID			= ID
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @return	擾
*//***********************************************************************/
UINT GetMenuStringFromID (HMENU hMenu, UINT uID, LPTSTR lpString, UINT uSize)
{
#ifdef UNICODE
	return _GetMenuBarStringW(hMenu, uID, lpString, uSize, MIIM_ID | MIIM_TYPE, MF_BYCOMMAND);
#else
	return _GetMenuBarStringA(hMenu, uID, lpString, uSize, MIIM_ID | MIIM_TYPE, MF_BYCOMMAND);
#endif
}
/// iris::wx::GetMenuStringFromID Q
UINT GetMenuStringFromIDA(HMENU hMenu, UINT uID, LPSTR  lpString, UINT uSize)
{
	return _GetMenuBarStringA(hMenu, uID, lpString, uSize, MIIM_ID | MIIM_TYPE, MF_BYCOMMAND);
}
/// iris::wx::GetMenuStringFromID Q
UINT GetMenuStringFromIDW(HMENU hMenu, UINT uID, LPWSTR lpString, UINT uSize)
{
	return _GetMenuBarStringW(hMenu, uID, lpString, uSize, MIIM_ID | MIIM_TYPE, MF_BYCOMMAND);
}

/**********************************************************************//**
 *
 * 擾
 *	hMenuȉׂ̂Ă
 ----------------------------------------------------------------------
 * @param [in]	hMenu		= Ώۃj[
 * @param [in]	uPos		= ʒu
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @return	擾
*//***********************************************************************/
UINT GetMenuStringFromPos (HMENU hMenu, UINT uPos, LPTSTR lpString, UINT uSize)
{
#ifdef UNICODE
	return _GetMenuBarStringW(hMenu, uPos, lpString, uSize, MIIM_TYPE, MF_BYPOSITION);
#else
	return _GetMenuBarStringA(hMenu, uPos, lpString, uSize, MIIM_TYPE, MF_BYPOSITION);
#endif
}
/// iris::wx::GetMenuStringFromPos Q
UINT GetMenuStringFromPosA(HMENU hMenu, UINT uPos, LPSTR  lpString, UINT uSize)
{
	return _GetMenuBarStringA(hMenu, uPos, lpString, uSize, MIIM_TYPE, MF_BYPOSITION);
}
/// iris::wx::GetMenuStringFromPos Q
UINT GetMenuStringFromPosW(HMENU hMenu, UINT uPos, LPWSTR lpString, UINT uSize)
{
	return _GetMenuBarStringW(hMenu, uPos, lpString, uSize, MIIM_TYPE, MF_BYPOSITION);
}

/**********************************************************************//**
 *
 * ID猟
 *
 ----------------------------------------------------------------------
 * @param [in]	hMenu	= Ώۃj[
 * @param [in]	uID		= ID
 * @return	qbgj[nh
*//***********************************************************************/
HMENU FindRootMenu(HMENU hMenu, UINT uID)
{
	MENUITEMINFO mi;
	memset(&mi,0,sizeof(mi));
	mi.cbSize	= sizeof(mi);
	mi.fMask	= MIIM_ID;
	mi.wID		= uID;

	if( GetMenuItemInfo(hMenu, uID, MF_BYCOMMAND, &mi) ) return hMenu;

	HMENU hSubMenu = GetSubMenu(hMenu, 0);
	for( int i=0; hSubMenu; ++i, hSubMenu = GetSubMenu(hMenu, i) )
	{
		if( FindMenuItemInfo(hSubMenu, uID, MF_BYCOMMAND, &mi) != nullptr ) return hSubMenu;
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * ID猟
 *
 ----------------------------------------------------------------------
 * @param [in]	hMenu	= Ώۃj[
 * @param [in]	uID		= ID
 * @return	qbgj[nh
*//***********************************************************************/
HMENU FindMenu(HMENU hMenu, UINT uID)
{
	int nPos = GetMenuItemPos(hMenu, uID);
	if( nPos != -1 )
	{
		return ::GetSubMenu(hMenu, nPos);
	}

	HMENU hSubMenu = GetSubMenu(hMenu, 0);
	for( int i=0; hSubMenu; ++i, hSubMenu = GetSubMenu(hMenu, i) )
	{
		HMENU hMenu = FindMenu(hSubMenu, uID);
		if( hMenu != nullptr ) return hMenu;
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * j[ACě
 *
 ----------------------------------------------------------------------
 * @param [in]	hMenu	= Ώۃj[
 * @param [in]	uItem	= ACe
 * @param [in]	fByPos	= tO
 * @param [out]	lpmii	= o
 * @return	qbgj[nh
*//***********************************************************************/
HMENU FindMenuItemInfo (HMENU hMenu, UINT uItem, BOOL fByPos, LPMENUITEMINFO  lpmii)
{
#ifdef UNICODE
	return FindMenuItemInfoW(hMenu, uItem, fByPos, lpmii);
#else
	return FindMenuItemInfoA(hMenu, uItem, fByPos, lpmii);
#endif
}
/// iris::wx::FindMenuItemInfo Q
HMENU FindMenuItemInfoA(HMENU hMenu, UINT uItem, BOOL fByPos, LPMENUITEMINFOA lpmii)
{
	if( GetMenuItemInfoA(hMenu, uItem, fByPos, lpmii) ) return hMenu;

	HMENU hSubMenu = GetSubMenu(hMenu, 0);
	for( int i=0; hSubMenu; ++i, hSubMenu = GetSubMenu(hMenu, i) )
	{
		if( FindMenuItemInfoA(hSubMenu, uItem, fByPos, lpmii) != nullptr ) return hSubMenu;
	}
	return nullptr;
}
/// iris::wx::FindMenuItemInfo Q
HMENU FindMenuItemInfoW(HMENU hMenu, UINT uItem, BOOL fByPos, LPMENUITEMINFOW lpmii)
{
	if( GetMenuItemInfoW(hMenu, uItem, fByPos, lpmii) ) return hMenu;

	HMENU hSubMenu = GetSubMenu(hMenu, 0);
	for( int i=0; hSubMenu; ++i, hSubMenu = GetSubMenu(hMenu, i) )
	{
		if( FindMenuItemInfoW(hSubMenu, uItem, fByPos, lpmii) != nullptr ) return hSubMenu;
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * j[ʒu̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hMenu	= j[nh
 * @param [in]	uID		= j[ID
 * @return	j[ڂ̈ʒu
*//***********************************************************************/
int GetMenuItemPos(HMENU hMenu, UINT uID)
{
	MENUITEMINFO mi;
	memset(&mi,0,sizeof(mi));
	mi.cbSize	= sizeof(mi);
	mi.fMask	= MIIM_ID;
	mi.wID		= uID;

	for( int i=0, n=::GetMenuItemCount(hMenu); i < n; ++i )
	{
		if( GetMenuItemInfo(hMenu, i, MF_BYPOSITION, &mi) )
		{
			if( mi.wID == uID ) return i;
		}
	}
	return -1;
}

/**********************************************************************//**
 *
 * |bvAbvj[̕\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= eEBhE
 * @param [in]	hMenu	= Ώۃj[
 * @param [in]	prc		= gpĂ܂
 * @return	BOOLl
*//***********************************************************************/
BOOL ShowPopupMenu(HWND hWnd, HMENU hMenu, LPRECT prc)
{
	IRIS_UNUSED_VARIABLE(prc);
	POINT pos;
	// J[\̈ʒu擾
	GetCursorPos(&pos);
	// |bvAbvj[\
	return TrackPopupMenu( hMenu,
		TPM_LEFTALIGN | TPM_TOPALIGN | TPM_RIGHTBUTTON | TPM_LEFTBUTTON,
		pos.x, pos.y, 0, hWnd, nullptr );
}

/**********************************************************************//**
 * @internal
 *
 * 擾
 *	hMenuȉׂ̂Ă
 *
 ----------------------------------------------------------------------
 * @param [in]	hMenu		= Ώۃj[
 * @param [in]	uID			= ID
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	fMask		= 
 * @param [in]	fByPosition	=
 * @return	擾
*//***********************************************************************/
UINT _GetMenuBarStringA(HMENU hMenu, UINT uID, LPSTR  lpString, UINT uSize, UINT fMask, BOOL fByPosition)
{
	MENUITEMINFOA mi;
	memset(&mi,0,sizeof(mi));
	mi.cbSize	= sizeof(mi);
	mi.fMask	= fMask;
	mi.fType	= MFT_STRING;
	mi.wID		= uID;

	GetMenuItemInfoA(hMenu, uID, fByPosition, &mi);
	mi.dwTypeData = lpString;
	++mi.cch;
	if( mi.cch > uSize )
	{
		mi.cch = uSize;
	}
	if(GetMenuItemInfoA(hMenu, uID, fByPosition, &mi))
	{
		return mi.cch;
	}
	if( fByPosition == MF_BYCOMMAND )
	{
		HMENU menu = GetSubMenu(hMenu, 0);
		for( int i=1; menu; ++i )
		{
			UINT ret = _GetMenuBarStringA(menu, uID, lpString, uSize, fMask, fByPosition);
			if( ret ) return ret;
			menu = GetSubMenu(hMenu, i);
		}
	}
	return 0;
}
/** @internal */
UINT _GetMenuBarStringW(HMENU hMenu, UINT uID, LPWSTR lpString, UINT uSize, UINT fMask, BOOL fByPosition)
{
	MENUITEMINFOW mi;
	memset(&mi,0,sizeof(mi));
	mi.cbSize	= sizeof(mi);
	mi.fMask	= fMask;
	mi.fType	= MFT_STRING;
	mi.wID		= uID;

	GetMenuItemInfoW(hMenu, uID, fByPosition, &mi);
	mi.dwTypeData = lpString;
	++mi.cch;
	if( mi.cch > uSize )
	{
		mi.cch = uSize;
	}
	if(GetMenuItemInfoW(hMenu, uID, fByPosition, &mi))
	{
		return mi.cch;
	}
	if( fByPosition == MF_BYCOMMAND )
	{
		HMENU menu = GetSubMenu(hMenu, 0);
		for( int i=1; menu; ++i )
		{
			UINT ret = _GetMenuBarStringW(menu, uID, lpString, uSize, fMask, fByPosition);
			if( ret ) return ret;
			menu = GetSubMenu(hMenu, i);
		}
	}
	return 0;
}

//======================================================================
// class
// CMenu
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMenu::CMenu(void)
: m_hMenu(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hMenu	= ֘At郁j[
*//***********************************************************************/
CMenu::CMenu(HMENU hMenu)
: m_hMenu(nullptr)
{
	Attach(hMenu);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= j[ێĂEBhEnh
*//***********************************************************************/
CMenu::CMenu(HWND hWnd)
: m_hMenu(nullptr)
{
#if	!defined(IRIS_WIN32_WCE)
	Attach(::GetMenu(hWnd));
#else
	Attach(CommandBar_GetMenu(hWnd, 0));
#endif
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMenu::~CMenu(void)
{
	DestroyMenu();
}

/**********************************************************************//**
 *
 * j[֘At
 *
 ----------------------------------------------------------------------
 * @param [in]	hMenu	= ֘At郁j[
 * @return	
*//***********************************************************************/
bool CMenu::Attach(HMENU hMenu)
{
	if( m_hMenu != nullptr && hMenu == nullptr ) return false;
	m_hMenu = hMenu;
	return true;
}

/**********************************************************************//**
 *
 * j[̊֘At𕪗
 *
 ----------------------------------------------------------------------
 * @return	Õj[nh
*//***********************************************************************/
HMENU CMenu::Detach(void)
{
	HMENU hMenu = m_hMenu;
	if( m_hMenu != nullptr )
	{
	}
	m_hMenu = nullptr;
	return hMenu;
}

/**********************************************************************//**
 *
 * j[쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CMenu::CreateMenu(void)
{
	HMENU hMenu = ::CreateMenu();
	if( !Attach(hMenu) )
	{
		::DestroyMenu(hMenu);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * |bvAbvj[쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CMenu::CreatePopupMenu(void)
{
	HMENU hMenu = ::CreatePopupMenu();
	if( !Attach(hMenu) )
	{
		::DestroyMenu(hMenu);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * j[̃[h
 *
 ----------------------------------------------------------------------
 * @param [in]	hInstance	= CX^Xnh
 * @param [in]	lpMenuName	= j[́AID
 * @return	
*//***********************************************************************/
BOOL CMenu::LoadMenuA(HINSTANCE hInstance, LPCSTR  lpMenuName)
{
	HMENU hMenu = ::LoadMenuA(hInstance, lpMenuName);
	if( !Attach(hMenu) )
	{
		::DestroyMenu(hMenu);
		return FALSE;
	}
	return TRUE;
}
/// CMenu::LoadMenuA Q
BOOL CMenu::LoadMenuW(HINSTANCE hInstance, LPCWSTR lpMenuName)
{
	HMENU hMenu = ::LoadMenuW(hInstance, lpMenuName);
	if( !Attach(hMenu) )
	{
		::DestroyMenu(hMenu);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * j[̔j
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CMenu::DestroyMenu(void)
{
	if( m_hMenu == nullptr ) return FALSE;
	return ::DestroyMenu(Detach());
}

/**********************************************************************//**
 *
 * j[ǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	uItem		= ʒuorID
 * @param [in]	fByPos		= tO(MF_BYCOMMAND or MF_BYPOSITION)
 * @param [in]	lpmii		= j[ACe
 * @return	
*//***********************************************************************/
BOOL CMenu::InsertMenuItemA(UINT uItem, BOOL fByPos, LPCMENUITEMINFOA lpmii)
{
	return ::InsertMenuItemA(m_hMenu, uItem, fByPos, lpmii);
}
/// CMenu::InsertMenuItemA Q
BOOL CMenu::InsertMenuItemW(UINT uItem, BOOL fByPos, LPCMENUITEMINFOW lpmii)
{
	return ::InsertMenuItemW(m_hMenu, uItem, fByPos, lpmii);
}

/**********************************************************************//**
 *
 * j[̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	uItem		= ʒuorID
 * @param [in]	nFlags		= nPosition̓ew(MF_BYCOMMAND or MF_BYPOSITION)
 * @return	
*//***********************************************************************/
BOOL CMenu::DeleteMenu(UINT uItem, UINT uFlags)
{
	return ::DeleteMenu(m_hMenu, uItem, uFlags);
}

/**********************************************************************//**
 *
 * j[I
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= j[ĂEBhEnh
 * @return	
*//***********************************************************************/
BOOL CMenu::SelectMenuItem(HWND hWnd, int nPos)
{
	UINT id = GetMenuItemID(nPos);
	if( id == (UINT)-1 ) return FALSE;
	MENUITEMINFO mi = {0};
	mi.cbSize = sizeof(mi);
	mi.fMask = MIIM_STATE;
	if( !GetMenuItemInfo(nPos, MF_BYPOSITION, &mi) ) return FALSE;
	::SendMessage(hWnd, WM_MENUSELECT, MAKEWPARAM(id, mi.fState), (LPARAM)m_hMenu);
	return TRUE;
}

/**********************************************************************//**
 *
 * j[
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= j[ĂEBhEnh
 * @return	
*//***********************************************************************/
BOOL CMenu::PushMenuItem(HWND hWnd, int nPos)
{
	UINT uID = GetMenuItemID(nPos);
	if( uID == (UINT)-1 ) return FALSE;
	HMENU hMenu = GetSubMenu(nPos);
	MENUINFO mi = {0};
	mi.cbSize = sizeof(mi);
	mi.fMask = MIM_STYLE;
	::GetMenuInfo(hMenu, &mi);
	if( mi.dwStyle & MNS_NOTIFYBYPOS )
	{
		::SendMessage(hWnd, WM_MENUCOMMAND, nPos, (LPARAM)hMenu);
	}
	else
	{
		::SendMessage(hWnd, WM_COMMAND, MAKEWPARAM(uID, 0), 0);
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * j[̍폜(Ȃ)
 *
 ----------------------------------------------------------------------
 * @param [in]	uItem		= ʒuorID
 * @param [in]	nFlags		= nPosition̓ew(MF_BYCOMMAND or MF_BYPOSITION)
 * @return	j[nh
*//***********************************************************************/
HMENU CMenu::RemoveMenu(UINT uItem, UINT uFlags)
{
	HMENU hMenu = m_hMenu;
	HMENU hSubMenu = nullptr;
	if( uFlags == MF_BYCOMMAND )
	{
		hMenu = FindRootMenu(uItem);
		int pos = wx::GetMenuItemPos(hMenu, uItem);
		hSubMenu = ::GetSubMenu(hMenu, pos);
	}
	else
	{
		hSubMenu = GetSubMenu(static_cast<int>(uItem));
	}
	::RemoveMenu(hMenu, uItem, uFlags);
	return hSubMenu;
}

/**********************************************************************//**
 *
 * j[ɃWI{^`FbN
 *
 ----------------------------------------------------------------------
 * @param [in]	uItem		= j[ACeID
 * @param [in]	uCheck		= `FbN(MF_***)
 * @return	
*//***********************************************************************/
BOOL CMenu::CheckMenuItem(UINT uItem, UINT uCheck)
{
	return (::CheckMenuItem(m_hMenu, uItem, uCheck) != -1 ? TRUE : FALSE);
}

/**********************************************************************//**
 *
 * j[ɃWI{^`FbN
 *
 ----------------------------------------------------------------------
 * @param [in]	uFirst		= O[v̍ŏ̍
 * @param [in]	uLast		= O[v̍Ō̍
 * @param [in]	uCheck		= `FbN(MF_***)
 * @param [in]	nFlags		= nPosition̓ew(MF_BYCOMMAND or MF_BYPOSITION)
 * @return	
*//***********************************************************************/
BOOL CMenu::CheckMenuRadioItem(UINT uFirst, UINT uLast, UINT uCheck, UINT uFlags)
{
	return ::CheckMenuRadioItem(m_hMenu, uFirst, uLast, uCheck, uFlags );
}
/// CMenu::CheckMenuRadioItem Q
/// CheckMenuRadioItem(uCheck, uCheck, uCheck, uFlags );
BOOL CMenu::CheckMenuRadioItem(UINT uCheck, UINT uFlags)
{
	return CheckMenuRadioItem(uCheck, uCheck, uCheck, uFlags );
}

/**********************************************************************//**
 *
 * j[ڂLAA܂͒WF\ɂ
 *
 ----------------------------------------------------------------------
 * @param [in]	uID			= 
 * @param [in]	uEnable		= MF_ENABLED or MF_DISABLED or MF_GRAYED
 * @return	
*//***********************************************************************/
BOOL CMenu::EnableMenuItem(UINT uID, UINT uEnable)
{
	return ::EnableMenuItem(m_hMenu, uID, uEnable);
}

/**********************************************************************//**
 *
 * j[擾
 *
 ----------------------------------------------------------------------
 * @param	lpmi	= o
 * @return	
*//***********************************************************************/
BOOL CMenu::GetMenuInfo(LPMENUINFO lpmi) const
{
	IRIS_ASSERT( lpmi != nullptr );
	IRIS_ASSERT( lpmi->cbSize == sizeof(MENUINFO) );
	return ::GetMenuInfo(m_hMenu, lpmi);
}

/**********************************************************************//**
 *
 * j[ڐ̎擾
 *
 ----------------------------------------------------------------------
 * @return	ڐ
*//***********************************************************************/
int CMenu::GetMenuItemCount(void) const
{
	return ::GetMenuItemCount(m_hMenu);
}

/**********************************************************************//**
 *
 * j[ID̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	nPos	= j[ڂ̈ʒu
 * @return	ID
*//***********************************************************************/
UINT CMenu::GetMenuItemID(int nPos) const
{
	return ::GetMenuItemID(m_hMenu, nPos);
}

/**********************************************************************//**
 *
 * j[ACe\̂fMasko擾
 *
 ----------------------------------------------------------------------
 * @param [in]	uItem	= ACe
 * @param [in]	fByPos	= tO(MF_BYPOSITION or MF_BYCOMMAND)
 * @return	fMask
*//***********************************************************************/
DWORD CMenu::GetMenuItemInfoMask(UINT uItem, BOOL fByPosition) const
{
	MENUITEMINFO mi = {0};
	mi.cbSize = sizeof(mi);
	if( !GetMenuItemInfo(uItem, fByPosition, &mi) ) return 0;
	return mi.fMask;
}

/**********************************************************************//**
 *
 * j[ACe\̂fTypeo擾
 *
 ----------------------------------------------------------------------
 * @param [in]	uItem	= ACe
 * @param [in]	fByPos	= tO(MF_BYPOSITION or MF_BYCOMMAND)
 * @return	fMask
*//***********************************************************************/
DWORD CMenu::GetMenuItemInfoType(UINT uItem, BOOL fByPosition) const
{
	MENUITEMINFO mi = {0};
	mi.cbSize = sizeof(mi);
	mi.fMask = MIIM_TYPE;
	if( !GetMenuItemInfo(uItem, fByPosition, &mi) ) return 0;
	return mi.fType;
}

/**********************************************************************//**
 *
 * j[ACe\̂fStateo擾
 *
 ----------------------------------------------------------------------
 * @param [in]	uItem	= ACe
 * @param [in]	fByPos	= tO(MF_BYPOSITION or MF_BYCOMMAND)
 * @return	fState
*//***********************************************************************/
DWORD CMenu::GetMenuItemInfoState(UINT uItem, BOOL fByPosition) const
{
	MENUITEMINFO mi = {0};
	mi.cbSize = sizeof(mi);
	mi.fMask = MIIM_STATE;
	if( !GetMenuItemInfo(uItem, fByPosition, &mi) ) return 0;
	return mi.fState;
}

/**********************************************************************//**
 *
 * j[ACȅ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	uItem	= ACe
 * @param [in]	fByPos	= tO(MF_BYPOSITION or MF_BYCOMMAND)
 * @param [out]	lpmii	= o
 * @return	
*//***********************************************************************/
BOOL CMenu::GetMenuItemInfoA(UINT uItem, BOOL fByPosition, LPMENUITEMINFOA lpmii) const
{
	return ::GetMenuItemInfoA(m_hMenu, uItem, fByPosition, lpmii);
}
/// CMenu::GetMenuItemInfoA Q
BOOL CMenu::GetMenuItemInfoW(UINT uItem, BOOL fByPosition, LPMENUITEMINFOW lpmii) const
{
	return ::GetMenuItemInfoW(m_hMenu, uItem, fByPosition, lpmii);
}

/**********************************************************************//**
 *
 * j[ACë̗擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= j[ێĂEBhEnh
 * @param [in]	uItem	= ACe
 * @param [out]	lprc	= o
 * @return	
*//***********************************************************************/
BOOL CMenu::GetMenuItemRect(HWND hWnd, UINT uItem, LPRECT lprc) const
{
	return ::GetMenuItemRect(hWnd, m_hMenu, uItem, lprc);
}

/**********************************************************************//**
 *
 * Tuj[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	nPos	= ʒu
 * @return	Tuj[
*//***********************************************************************/
HMENU CMenu::GetSubMenu(int nPos) const
{
	return ::GetSubMenu(m_hMenu, nPos);
}

/**********************************************************************//**
 *
 * nCCgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= j[ێĂEBhEnh
 * @param [in]	uID			= ʒuorID
 * @param [in]	uHilite		= tO(MF_BYCOMMAND or MF_BYPOSITION and MF_HILIITE or MF_UNHILITE)
 * @return	
*//***********************************************************************/
BOOL CMenu::HiliteMenuItem(HWND hWnd, UINT uID, UINT uHilite)
{
	return ::HiliteMenuItem(hWnd, m_hMenu, uID, uHilite);
}

/**********************************************************************//**
 *
 * j[nhǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CMenu::IsMenu(void) const
{
	return ::IsMenu(m_hMenu);
}

/**********************************************************************//**
 *
 * |bvAbvj[nhǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CMenu::IsPopupMenu(void) const
{
	if( GetSubMenu(0) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * ʒu烁j[nh擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= j[ێĂEBhEnh
 * @param [in]	ptScreen	= XN[W
 * @return	j[ʒu
*//***********************************************************************/
int CMenu::MenuItemFromPoint(HWND hWnd, POINT ptScreen) const
{
	return ::MenuItemFromPoint(hWnd, m_hMenu, ptScreen);
}

/**********************************************************************//**
 *
 * j[ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpmi	= j[
 * @return	
*//***********************************************************************/
BOOL CMenu::SetMenuInfo(LPCMENUINFO lpmi)
{
	return ::SetMenuInfo(m_hMenu, lpmi);
}

/**********************************************************************//**
 *
 * rbg}bvj[Ɋ֘At
 *
 *----------------------------------------------------------------------
 * @param [in]	uItem				= ʒuorID
 * @param [in]	uFlags				= tO
 * @param [in]	hBitmapUnchecked	= `FbNrbg}bvnh
 * @param [in]	hBitmapChecked		= `FbNrbg}bvnh
 * @return	
*//***********************************************************************/
BOOL CMenu::SetMenuItemBitmaps(UINT uItem, UINT uFlags, HBITMAP hBitmapUnchecked, HBITMAP hBitmapChecked)
{
	return ::SetMenuItemBitmaps(m_hMenu, uItem, uFlags, hBitmapUnchecked, hBitmapChecked);
}

/**********************************************************************//**
 *
 * j[ACȅݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	uItem	= ACe
 * @param [in]	fByPos	= tO
 * @param [in]	lpmii	= ݒ
 * @return	
*//***********************************************************************/
BOOL CMenu::SetMenuItemInfoA(UINT uItem, BOOL fByPosition, LPMENUITEMINFOA lpmii)
{
	return ::SetMenuItemInfoA(m_hMenu, uItem, fByPosition, lpmii);
}
/// CMenu::SetMenuItemInfoA Q
BOOL CMenu::SetMenuItemInfoW(UINT uItem, BOOL fByPosition, LPMENUITEMINFOW lpmii)
{
	return ::SetMenuItemInfoW(m_hMenu, uItem, fByPosition, lpmii);
}

/**********************************************************************//**
 *
 * j[ACȅݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlags	= tO(TPM_***)
 * @param [in]	x,y		= \ʒu
 * @param [in]	hWnd	= EBhEnh
 * @return	
*//***********************************************************************/
BOOL CMenu::TrackPopup(UINT uFlags, int x, int y, HWND hWnd)
{
	return ::TrackPopupMenu(m_hMenu, uFlags, x, y, 0, hWnd, nullptr);
}

/**********************************************************************//**
 *
 * j[ACȅݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlags	= tO(TPM_***)
 * @param [in]	x,y		= \ʒu
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	lptpm	= I[o[bv֎~̈
 * @return	
*//***********************************************************************/
BOOL CMenu::TrackPopupEx(UINT uFlags, int x, int y, HWND hWnd, LPTPMPARAMS lptpm)
{
	return ::TrackPopupMenuEx(m_hMenu, uFlags, x, y, hWnd, lptpm);
}

/**********************************************************************//**
 *
 * 擾
 *	hMenuȉׂ̂Ă
 *
 ----------------------------------------------------------------------
 * @param [in]	hMenu		= Ώۃj[
 * @param [in]	uID			= ID
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @return	擾
*//***********************************************************************/
UINT	CMenu::GetMenuStringFromID	(UINT uID , LPTSTR lpString, UINT uSize) const
{
	return wx::GetMenuStringFromID (m_hMenu, uID, lpString, uSize); 
}
/// CMenu::GetMenuStringFromID Q
UINT	CMenu::GetMenuStringFromIDA(UINT uID , LPSTR  lpString, UINT uSize) const
{
	return wx::GetMenuStringFromIDA(m_hMenu, uID, lpString, uSize); 
}
/// CMenu::GetMenuStringFromID Q
UINT	CMenu::GetMenuStringFromIDW(UINT uID , LPWSTR lpString, UINT uSize) const	
{
	return wx::GetMenuStringFromIDW(m_hMenu, uID, lpString, uSize); 
}

/**********************************************************************//**
 *
 * 擾
 *	hMenuȉׂ̂Ă
 *
 ----------------------------------------------------------------------
 * @param [in]	hMenu		= Ώۃj[
 * @param [in]	uPos		= ʒu
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @return	擾
*//***********************************************************************/
UINT	CMenu::GetMenuStringFromPos (UINT uPos, LPTSTR lpString, UINT uSize) const
{
	return wx::GetMenuStringFromPos (m_hMenu, uPos, lpString, uSize); 
}
/// CMenu::GetMenuStringFromPos Q
UINT	CMenu::GetMenuStringFromPosA(UINT uPos, LPSTR  lpString, UINT uSize) const
{
	return wx::GetMenuStringFromPosA(m_hMenu, uPos, lpString, uSize); 
}
/// CMenu::GetMenuStringFromPos Q
UINT	CMenu::GetMenuStringFromPosW(UINT uPos, LPWSTR lpString, UINT uSize) const
{
	return wx::GetMenuStringFromPosW(m_hMenu, uPos, lpString, uSize); 
}

/**********************************************************************//**
 *
 * j[ACeIDAj[nh
 *
 ----------------------------------------------------------------------
 * @param [in]	uID			= j[ID
 * @return	j[nh
*//***********************************************************************/
HMENU CMenu::FindRootMenu(UINT uID) const
{
	return wx::FindRootMenu(m_hMenu, uID);
}

/**********************************************************************//**
 *
 * j[ACeIDAj[nh
 *
 ----------------------------------------------------------------------
 * @param [in]	uID			= j[ID
 * @return	j[nh
*//***********************************************************************/
HMENU CMenu::FindMenu(UINT uID) const
{
	return wx::FindMenu(m_hMenu, uID);
}

/**********************************************************************//**
 *
 * j[ACě
 *
 ----------------------------------------------------------------------
 * @param [in]	hMenu	= Ώۃj[
 * @param [in]	uItem	= ACe
 * @param [in]	fByPos	= tO
 * @param [out]	lpmii	= o
 * @return	qbgj[nh
*//***********************************************************************/
HMENU CMenu::FindMenuItemInfo (UINT uItem, BOOL fByPos, LPMENUITEMINFO  lpmii) const
{
	return wx::FindMenuItemInfo (m_hMenu, uItem, fByPos, lpmii);
}
/// CMenu::FindMenuItemInfo Q
HMENU CMenu::FindMenuItemInfoA(UINT uItem, BOOL fByPos, LPMENUITEMINFOA lpmii) const
{
	return wx::FindMenuItemInfoA(m_hMenu, uItem, fByPos, lpmii);
}
/// CMenu::FindMenuItemInfo Q
HMENU CMenu::FindMenuItemInfoW(UINT uItem, BOOL fByPos, LPMENUITEMINFOW lpmii) const
{
	return wx::FindMenuItemInfoW(m_hMenu, uItem, fByPos, lpmii);
}

/**********************************************************************//**
 *
 * j[ʒu̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	uID	= j[ID
 * @return	j[ڂ̈ʒu
*//***********************************************************************/
int CMenu::GetMenuItemPos(UINT uID) const
{
	return wx::GetMenuItemPos(m_hMenu, uID);
}

/**********************************************************************//**
 *
 * |bvAbvj[̕\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= eEBhE
 * @param [in]	hMenu	= Ώۃj[
 * @param [in]	prc		= gpĂ܂
 * @return	BOOLl
*//***********************************************************************/
BOOL	CMenu::ShowPopupMenu(HWND hWnd, RECT* prc)
{
	return wx::ShowPopupMenu(hWnd, m_hMenu, prc); 
}


/**********************************************************************//**
 *
 * j[
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	hMenu	= Ώۂ̃j[Ă郁j[̃nh
 * @param [in]	lpmii	= j[ACe
 * @return	LRESULT l
*//***********************************************************************/
LRESULT CMenu::PushMenu (HWND hWnd, HMENU hRootMenu, LPMENUITEMINFO  lpmii)
{
#ifdef UNICODE
	return PushMenuW(hWnd, hRootMenu, lpmii);
#else
	return PushMenuA(hWnd, hRootMenu, lpmii);
#endif
}
LRESULT CMenu::PushMenuA(HWND hWnd, HMENU hRootMenu, LPMENUITEMINFOA lpmii)
{
	IRIS_ASSERT( lpmii != nullptr );
	IRIS_ASSERT( lpmii->fMask & MIIM_ID );
	int nPos = ::iris::wx::GetMenuItemPos(hRootMenu, lpmii->wID);
	HMENU hMenu = ::GetSubMenu(hRootMenu, nPos);
	MENUINFO mi = {0};
	mi.cbSize = sizeof(mi);
	mi.fMask = MIM_STYLE;
	::GetMenuInfo(hMenu, &mi);
	if( mi.dwStyle & MNS_NOTIFYBYPOS )
	{
		return ::SendMessageA(hWnd, WM_MENUCOMMAND, nPos, (LPARAM)hMenu);
	}
	else
	{
		return ::SendMessageA(hWnd, WM_COMMAND, MAKEWPARAM(lpmii->wID, 0), 0);
	}
}
LRESULT CMenu::PushMenuW(HWND hWnd, HMENU hRootMenu, LPMENUITEMINFOW lpmii)
{
	IRIS_ASSERT( lpmii != nullptr );
	IRIS_ASSERT( lpmii->fMask & MIIM_ID );
	int nPos = ::iris::wx::GetMenuItemPos(hRootMenu, lpmii->wID);
	HMENU hMenu = ::GetSubMenu(hRootMenu, nPos);
	MENUINFO mi = {0};
	mi.cbSize = sizeof(mi);
	mi.fMask = MIM_STYLE;
	::GetMenuInfo(hMenu, &mi);
	if( mi.dwStyle & MNS_NOTIFYBYPOS )
	{
		return ::SendMessageW(hWnd, WM_MENUCOMMAND, nPos, (LPARAM)hMenu);
	}
	else
	{
		return ::SendMessageW(hWnd, WM_COMMAND, MAKEWPARAM(lpmii->wID, 0), 0);
	}
}

}	// end of namespace wx
}	// end of namespace iris
