//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPropertySheet.cpp
 * @brief		vpeBV[gNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXPropertySheet_CPP_

//======================================================================
// include
#include "WXComControl.h"
#include "WXPropertySheet.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CPropertySheet::CPropertySheet(void)
{
	CComCtrl::Initialize();
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CPropertySheet::~CPropertySheet(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
INT_PTR WINAPI CPropertySheet::Create(LPPROPSHEETHEADER  lpPsh)
{
#ifdef UNICODE
	return CreateW(lpPsh);
#else
	return CreateA(lpPsh);
#endif
}
/// CPropertySheet::Create Q
INT_PTR WINAPI CPropertySheet::CreateA(LPPROPSHEETHEADERA lpPsh)
{
	if( lpPsh == nullptr ) return -1;
	lpPsh->dwSize	= sizeof(PROPSHEETHEADERA);
	INT_PTR ret = PropertySheetA(lpPsh);
	if( lpPsh->dwFlags & PSH_MODELESS )
	{
		Attach(reinterpret_cast<HWND>(ret));
	}
	return ret;
}
/// CPropertySheet::Create Q
INT_PTR WINAPI CPropertySheet::CreateW(LPPROPSHEETHEADERW lpPsh)
{
	if( lpPsh == nullptr ) return -1;
	lpPsh->dwSize	= sizeof(PROPSHEETHEADERW);
	INT_PTR ret = PropertySheetW(lpPsh);
	if( lpPsh->dwFlags & PSH_MODELESS )
	{
		Attach(reinterpret_cast<HWND>(ret));
	}
	return ret;
}

}	// end of namespace wx
}	// end of namespace iris

#if 0
#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/WXDebugUnitTest.h"
#include "iris_using.h"

//======================================================================
// declare
UNITTEST_MAIN_FUNC(WXPropertySheetUnitTest);

//======================================================================
// class
class CWXPropertySheetUnitTest : public iris::unit::CUnitTest {};
// `
IRIS_UNITTEST(CWXPropertySheetUnitTest,Func);

//======================================================================
// typedef
typedef CWXPropertySheetUnitTest	dbUnitTest;

//======================================================================
// declare
INT_PTR CALLBACK _DlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

//======================================================================
// define
#define PAGE	1

/**********************************************************************//**
 *
 * UNITTEST_MAIN
 * 
 ----------------------------------------------------------------------
 * @return
*//***********************************************************************/
UNITTEST_MAIN_FUNC(WXPropertySheetUnitTest)
{
#ifdef IDD_DIALOG1
	CPropertySheet ps;
	CPropertySheetPage psp[PAGE];
	HPROPSHEETPAGE hpsp[PAGE];
	PROPSHEETHEADER psh = {0};
	HINSTANCE hInst = GetModuleHandle(nullptr);
	for( int i=0; i < PAGE; ++i )
	{
		psp[i].Create(hInst, PSP_DEFAULT, (LPCTSTR)IDD_DIALOG1, _DlgProc
			, IRIS_TEXT("PropSheetPage"));
		hpsp[i] = psp[i].Detach();
	}

	psh.dwSize		= sizeof(PROPSHEETHEADER);
	psh.dwFlags		= PSH_DEFAULT;
	psh.hInstance	= hInst;
	psh.pszCaption	= IRIS_TEXT("PropSheet");
	psh.nPages		= PAGE;
	psh.phpage		= hpsp;
	ps.Create(&psh);
#endif
	return 0;
}

/**********************************************************************//**
 *
 * eXgp_CAOvV[W
 * 
*//***********************************************************************/
INT_PTR CALLBACK _DlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return 1;
}

#endif
#endif
