//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRichTextParams.h
 * @brief		b`GfBbgRg[gp̍\̋@\gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXRichTextParams_H_
#define INCG_IRIS_WXRichTextParams_H_

//======================================================================
// include
#include "iris_object.h"
#if	defined(IRIS_WIN32_WCE)
#error	Windows CE API not support richedit.h
#endif
#include <richedit.h>

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename _TN>class ICharFormat;
template<typename _TN>class ICharFormat2;
template<typename _TN>class IParaFormat;
template<typename _TN>class IParaFormat2;

//======================================================================
// typedef
typedef class ICharFormat<CHARFORMATA>		CCharFormatA;	//!< CHARFORMATANX
typedef class ICharFormat<CHARFORMATW>		CCharFormatW;	//!< CHARFORMATWNX
typedef class ICharFormat2<CHARFORMAT2A>	CCharFormat2A;	//!< CHARFORMAT2ANX
typedef class ICharFormat2<CHARFORMAT2W>	CCharFormat2W;	//!< CHARFORMAT2WNX

typedef class IParaFormat<PARAFORMAT>		CParaFormat;	//!< PARAFORMATNX
typedef class IParaFormat2<PARAFORMAT2>		CParaFormat2;	//!< PARAFORMAT2NX

#ifdef UNICODE
typedef CCharFormatW	CCharFormat;	//!< CHARFORMATNX
typedef CCharFormat2W	CCharFormat2;	//!< CHARFORMATNX
#else
typedef CCharFormatA	CCharFormat;	//!< CHARFORMATNX
typedef CCharFormat2A	CCharFormat2;	//!< CHARFORMATNX
#endif

//======================================================================
// function

//======================================================================
// class
//! CHARFORMATev[gNX
template<typename _TN>
class ICharFormat : public IIrisObject
{
	typedef _TN	Format;
protected:
	Format		m_Fmt;	//! CHARFORMAT
public:
	// RXgN^
	ICharFormat(void);
	ICharFormat(const Format& rFormat);

	// fXgN^
	~ICharFormat(void);

public:
	/// tH[}bg̎擾
			Format&	GetFormat(void)			{ return m_Fmt; }
	const	Format&	GetFormat(void)	const	{ return m_Fmt; }
	Format&	operator () (void)		{ return GetFormat(); }
	operator Format& (void)			{ return GetFormat(); }

protected:
	// Lɂ
	void		EnableEffects(DWORD dwCFM, DWORD dwCFE);
	// ɂ
	void		DisableEffects(DWORD dwCFM, DWORD dwCFE);
	// Lǂ
	bool		IsEffects(DWORD dwCFM, DWORD dwCFE) const;
public:
	/// ݒɂ
	void		EnableBold(void)			{ EnableEffects(CFM_BOLD, CFE_BOLD); }
	/// ݒ
	void		DisableBold(void)			{ DisableEffects(CFM_BOLD, CFE_BOLD); }
	/// ݒ肩ǂ
	bool		IsBold(void)		const	{ return IsEffects(CFM_BOLD, CFE_BOLD); }
	/// ݒ
	void		FlagBold(bool enable)		{ enable ? EnableBold() : DisableBold(); }

	/// Α̐ݒɂ
	void		EnableItalic(void)			{ EnableEffects(CFM_ITALIC, CFE_ITALIC); }
	/// Α̐ݒ
	void		DisableItalic(void)			{ DisableEffects(CFM_ITALIC, CFE_ITALIC); }
	/// Α̐ݒ肩ǂ
	bool		IsItalic(void)		const	{ return IsEffects(CFM_ITALIC, CFE_ITALIC); }
	/// Α̐ݒ
	void		FlagItalic(bool enable)		{ enable ? EnableItalic() : DisableItalic(); }

	/// ݒɂ
	void		EnableUnderline(void)		{ EnableEffects(CFM_UNDERLINE, CFE_UNDERLINE); }
	/// ݒ
	void		DisableUnderline(void)		{ DisableEffects(CFM_UNDERLINE, CFE_UNDERLINE); }
	/// ݒ肩ǂ
	bool		IsUnderline(void)	const	{ return IsEffects(CFM_UNDERLINE, CFE_UNDERLINE); }
	/// ݒ
	void		FlagUnderline(bool enable)	{ enable ? EnableUnderline() : DisableUnderline(); }

	/// łݒɂ
	void		EnableStrikeOut(void)		{ EnableEffects(CFM_STRIKEOUT, CFE_STRIKEOUT); }
	/// łݒ
	void		DisableStrikeOut(void)		{ DisableEffects(CFM_STRIKEOUT, CFE_STRIKEOUT); }
	/// łݒ肩ǂ
	bool		IsStrikeOut(void)	const	{ return IsEffects(CFM_STRIKEOUT, CFE_STRIKEOUT); }
	/// łݒ
	void		FlagStrikeOut(bool enable)	{ enable ? EnableStrikeOut() : DisableStrikeOut(); }

	/// یݒɂ
	void		EnableProtected(void)		{ EnableEffects(CFM_PROTECTED, CFE_PROTECTED); }
	/// یݒ
	void		DisableProtected(void)		{ DisableEffects(CFM_PROTECTED, CFE_PROTECTED); }
	/// یݒ肩ǂ
	bool		IsProtected(void)	const	{ return IsEffects(CFM_PROTECTED, CFE_PROTECTED); }
	/// یݒ
	void		FlagProtected(bool enable)	{ enable ? EnableProtected() : DisableProtected(); }

	/// Nݒɂ
	void		EnableLink(void)			{ EnableEffects(CFM_LINK, CFE_LINK); }
	/// Nݒ
	void		DisableLink(void)			{ DisableEffects(CFM_LINK, CFE_LINK); }
	/// Nݒ肩ǂ
	bool		IsLink(void)		const	{ return IsEffects(CFM_LINK, CFE_LINK); }
	/// Nݒ
	void		FlagLink(bool enable)		{ enable ? EnableLink() : DisableLink(); }

public:
	// ̍ݒ(twipP)
	void		SetCharHeightTwip(LONG lHeight);
	// ̍擾(twipP)
	LONG		GetCharHeightTwip(void) const;
	// ̍ݒ(pixelP)
	void		SetCharHeightPixel(HWND hWnd, LONG lHeight);
	// ̍擾(pixelP)
	LONG		GetCharHeightPixel(HWND hWnd) const;
	// ̍ݒ(pointP)
	void		SetCharHeightPoint(LONG lHeight);
	// ̍擾(pointP)
	LONG		GetCharHeightPoint(void) const;
	// ̍ݒLɂ
	void		EnableCharHeight(void);
	// ̍ݒ𖳌ɂ
	void		DisableCharHeight(void);
	// ̍ݒ肪Lǂ
	bool		IsCharHeight(void) const;
	/// ̍ݒ
	void		FlagCharHeight(bool enable)		{ enable ? EnableCharHeight() : DisableCharHeight(); }

	// LN^Zbgݒ
	void		SetCharSet(BYTE byCharSet);
	// LN^Zbg擾
	BYTE		GetCharSet(void) const;
	// LN^ZbgLɂ
	void		EnableCharSet(void);
	// LN^Zbg𖳌ɂ
	void		DisableCharSet(void);
	// LN^ZbgLǂ
	bool		IsCharSet(void) const;
	/// LN^Zbg
	void		FlagCharSet(bool enable)		{ enable ? EnableCharSet() : DisableCharSet(); }

	// x[XC̃ItZbgݒ
	void		SetOffset(LONG lOffset);
	// x[XC̃ItZbg擾
	LONG		GetOffset(void) const;
	// x[XC̃ItZbgݒLɂ
	void		EnableOffset(void);
	// x[XC̃ItZbgݒ𖳌ɂ
	void		DisableOffset(void);
	// x[XC̃ItZbgݒ肪Lǂ
	bool		IsOffset(void) const;
	/// x[XC̃ItZbgݒ
	void		FlagOffset(bool enable)		{ enable ? EnableOffset() : DisableOffset(); }

	// Fݒ
	void		SetTextColor(COLORREF color);
	// F擾
	COLORREF	GetTextColor(void) const;
	// F̐ݒLɂ
	void		EnableTextColor(void);
	// F̐ݒ𖳌ɂ
	void		DisableTextColor(void);
	// F̐ݒLǂ
	bool		IsTextColor(void) const;
	/// F̐ݒ
	void		FlagTextColor(bool enable)		{ enable ? EnableTextColor() : DisableTextColor(); }
	// FݒVXeJ[ɂ
	void		EnableAutoTextColor(void);
	// FݒVXeJ[ɂ̂
	void		DisableAutoTextColor(void);
	// Fݒ肪VXeJ[ݒ肩ǂ
	bool		IsAutoTextColor(void) const;
	/// VXeJ[ݒ
	void		FlagAutoTextColor(bool enable)	{ enable ? EnableAutoTextColor() : DisableAutoTextColor(); }

	// tHg̐ݒ
	void		SetFontFace(LPVOID lpszFace);
	// tHg̐ݒLɂ
	void		EnableFontFace(void);
	// tHg̐ݒ𖳌ɂ
	void		DisableFontFace(void);
	// tHg̐ݒLǂ
	bool		IsFontFace(void) const;
	/// tHg̐ݒ
	void		FlagFontFace(bool enable)		{ enable ? EnableFontFace() : DisableFontFace(); }

public:
	// tHgt@~ƃsb`w
	void		SetPitchAndFamily(BYTE byPitchAndFamily);
	// tHgt@~ƃsb`擾
	BYTE		GetPitchAndFamily(void) const;
};

//! CHARFORMAT2ev[gNX
template<typename _TN>
class ICharFormat2 : public ICharFormat<_TN>
{
	typedef ICharFormat<_TN>	_Myt;
public:
	/// ݒɂiRg[ɂ\ɉeȂj
	void		EnableSmallCaps(void)		{ EnableEffects(CFM_SMALLCAPS, CFE_SMALLCAPS); }
	/// ݒiRg[ɂ\ɉeȂj
	void		DisableSmallCaps(void)		{ DisableEffects(CFM_SMALLCAPS, CFE_SMALLCAPS); }
	/// ݒ肩ǂiRg[ɂ\ɉeȂj
	bool		IsSmallCaps(void)	const	{ return IsEffects(CFM_SMALLCAPS, CFE_SMALLCAPS); }
	/// ݒiRg[ɂ\ɉeȂj
	void		FlagSmallCaps(bool enable)	{ enable ? EnableSmallCaps() : DisableSmallCaps(); }

	/// 啶ݒɂiRg[ɂ\ɉeȂj
	void		EnableAllCaps(void)			{ EnableEffects(CFM_ALLCAPS, CFE_ALLCAPS); }
	/// 啶ݒiRg[ɂ\ɉeȂj
	void		DisableAllCaps(void)		{ DisableEffects(CFM_ALLCAPS, CFE_ALLCAPS); }
	/// 啶ݒ肩ǂiRg[ɂ\ɉeȂj
	bool		IsAllCaps(void)		const	{ return IsEffects(CFM_ALLCAPS, CFE_ALLCAPS); }
	/// 啶ݒiRg[ɂ\ɉeȂj
	void		FlagAllCaps(bool enable)	{ enable ? EnableAllCaps() : DisableAllCaps(); }

	/// \ݒɂi3.0ȍ~j
	void		EnableHidden(void)			{ EnableEffects(CFM_HIDDEN, CFE_HIDDEN); }
	/// \ݒi3.0ȍ~j
	void		DisableHidden(void)			{ DisableEffects(CFM_HIDDEN, CFE_HIDDEN); }
	/// \ݒ肩ǂi3.0ȍ~j
	bool		IsHidden(void)		const	{ return IsEffects(CFM_HIDDEN, CFE_HIDDEN); }
	/// \ݒ
	void		FlagHidden(bool enable)		{ enable ? EnableHidden() : DisableHidden(); }

	/// ֊s`ꂽݒɂiRg[ɂ\ɉeȂj
	void		EnableOutline(void)			{ EnableEffects(CFM_OUTLINE, CFE_OUTLINE); }
	/// ֊s`ꂽݒiRg[ɂ\ɉeȂj
	void		DisableOutline(void)		{ DisableEffects(CFM_OUTLINE, CFE_OUTLINE); }
	/// ֊s`ꂽݒ肩ǂiRg[ɂ\ɉeȂj
	bool		IsOutline(void)		const	{ return IsEffects(CFM_OUTLINE, CFE_OUTLINE); }
	/// ֊s`ꂽݒiRg[ɂ\ɉeȂj
	void		FlagOutline(bool enable)	{ enable ? EnableOutline() : DisableOutline(); }

	/// AeݒɂiRg[ɂ\ɉeȂj
	void		EnableShadow(void)			{ EnableEffects(CFM_SHADOW, CFE_SHADOW); }
	/// AeݒiRg[ɂ\ɉeȂj
	void		DisableShadow(void)			{ DisableEffects(CFM_SHADOW, CFE_SHADOW); }
	/// Aeݒ肩ǂiRg[ɂ\ɉeȂj
	bool		IsShadow(void)		const	{ return IsEffects(CFM_SHADOW, CFE_SHADOW); }
	/// AeݒiRg[ɂ\ɉeȂj
	void		FlagShadow(bool enable)		{ enable ? EnableShadow() : DisableShadow(); }

	/// オݒɂiRg[ɂ\ɉeȂj
	void		EnableEmboss(void)			{ EnableEffects(CFM_EMBOSS, CFE_EMBOSS); }
	/// オݒiRg[ɂ\ɉeȂj
	void		DisableEmboss(void)			{ DisableEffects(CFM_EMBOSS, CFE_EMBOSS); }
	/// オݒ肩ǂiRg[ɂ\ɉeȂj
	bool		IsEmboss(void)		const	{ return IsEffects(CFM_EMBOSS, CFE_EMBOSS); }
	/// オݒiRg[ɂ\ɉeȂj
	void		FlagEmboss(bool enable)		{ enable ? EnableEmboss() : DisableEmboss(); }

	/// 󂳂ꂽݒɂiRg[ɂ\ɉeȂj
	void		EnableImprint(void)			{ EnableEffects(CFM_IMPRINT, CFE_IMPRINT); }
	/// 󂳂ꂽݒiRg[ɂ\ɉeȂj
	void		DisableImprint(void)		{ DisableEffects(CFM_IMPRINT, CFE_IMPRINT); }
	/// 󂳂ꂽݒ肩ǂiRg[ɂ\ɉeȂj
	bool		IsImprint(void)		const	{ return IsEffects(CFM_IMPRINT, CFE_IMPRINT); }
	/// 󂳂ꂽݒiRg[ɂ\ɉeȂj
	void		FlagImprint(bool enable)	{ enable ? EnableImprint() : DisableImprint(); }

	/// e\ݒɂ
	void		EnableDisabled(void)		{ EnableEffects(CFM_DISABLED, CFE_DISABLED); }
	/// e\ݒ
	void		DisableDisabled(void)		{ DisableEffects(CFM_DISABLED, CFE_DISABLED); }
	/// e\ݒ肩ǂ
	bool		IsDisabled(void)	const	{ return IsEffects(CFM_DISABLED, CFE_DISABLED); }
	/// e\ݒ
	void		FlagDisabled(bool enable)	{ enable ? EnableDisabled() : DisableDisabled(); }

	/// }[N\ݒɂ
	void		EnableRevised(void)			{ EnableEffects(CFM_REVISED, CFE_REVISED); }
	/// }[N\ݒ
	void		DisableRevised(void)		{ DisableEffects(CFM_REVISED, CFE_REVISED); }
	/// }[N\ݒ肩ǂ
	bool		IsRevised(void)		const	{ return IsEffects(CFM_REVISED, CFE_REVISED); }
	/// }[N\ݒ
	void		FlagRevised(bool enable)	{ enable ? EnableRevised() : DisableRevised(); }

	/// tݒɂ
	void		EnableSubScript(void)		{ EnableEffects(CFM_SUBSCRIPT, CFE_SUBSCRIPT); }
	/// tݒ
	void		DisableSubScript(void)		{ DisableEffects(CFM_SUBSCRIPT, CFE_SUBSCRIPT); }
	/// tݒ肩ǂ
	bool		IsSubScript(void)	const	{ return IsEffects(CFM_SUBSCRIPT, CFE_SUBSCRIPT); }
	/// tݒ
	void		FlagSubScript(bool enable)	{ enable ? EnableSubScript() : DisableSubScript(); }

	/// tݒɂ
	void		EnableSuperScript(void)		{ EnableEffects(CFM_SUPERSCRIPT, CFE_SUPERSCRIPT); }
	/// tݒ
	void		DisableSuperScript(void)	{ DisableEffects(CFM_SUPERSCRIPT, CFE_SUPERSCRIPT); }
	/// tݒ肩ǂ
	bool		IsSuperScript(void)	const	{ return IsEffects(CFM_SUPERSCRIPT, CFE_SUPERSCRIPT); }
	/// tݒ
	void		FlagSuperScript(bool enable){ enable ? EnableSuperScript() : DisableSuperScript(); }

public:
	// wiFݒ
	void		SetBackColor(COLORREF color);
	// wiF擾
	COLORREF	GetBackColor(void) const;
	// wiF̐ݒLɂ
	void		EnableBackColor(void);
	// wiF̐ݒ𖳌ɂ
	void		DisableBackColor(void);
	// wiF̐ݒLǂ
	bool		IsBackColor(void) const;
	/// wiF̐ݒ
	void		FlagBackColor(bool enable)	{ enable ? EnableBackColor() : DisableBackColor(); }
	// wiFݒVXeJ[ɂ
	void		EnableAutoBackColor(void);
	// wiFݒVXeJ[ɂ̂
	void		DisableAutoBackColor(void);
	// wiFݒ肪VXeJ[ݒ肩ǂ
	bool		IsAutoBackColor(void) const;
	/// VXeJ[ݒ
	void		FlagAutoBackColor(bool enable)	{ enable ? EnableAutoBackColor() : DisableAutoBackColor(); }

public:
	// tHg̑ݒ
	void		SetWeight(WORD wWeight);
	// tHg̑擾
	WORD		GetWeight(void) const;
	// tHg̑Lɂ
	void		EnableWeight(void);
	// tHg̑𖳌ɂ
	void		DisableWeight(void);
	// tHg̑Lǂ
	bool		IsWeight(void) const;
	/// tHg̑
	void		FlagWeight(bool enable)				{ enable ? EnableWeight() : DisableWeight(); }

	// ̃^Cvݒ
	void		SetUnderlineType(BYTE byUnderlineType);
	// ̃^Cv擾
	BYTE		GetUnderlineType(void) const;
	// ̃^CvݒLɂ
	void		EnableUnderlineType(void);
	// ̃^Cvݒ𖳌ɂ
	void		DisableUnderlineType(void);
	// ̃^Cvݒ肪Lǂ
	bool		IsUnderlineType(void) const;
	/// ̃^Cvݒ
	void		FlagUnderlineType(bool enable)		{ enable ? EnableUnderlineType() : DisableUnderlineType(); }

	// ԊuݒiRg[ɂ\ɉeȂj
	void		SetSpacing(SHORT sSpacing);
	// Ԋu擾iRg[ɂ\ɉeȂj
	SHORT		GetSpacing(void) const;
	// ԊuݒLɂiRg[ɂ\ɉeȂj
	void		EnableSpacing(void);
	// Ԋuݒ𖳌ɂiRg[ɂ\ɉeȂj
	void		DisableSpacing(void);
	// Ԋuݒ肪LǂiRg[ɂ\ɉeȂj
	bool		IsSpacing(void) const;
	/// ԊuݒiRg[ɂ\ɉeȂj
	void		FlagSpacing(bool enable)			{ enable ? EnableSpacing() : DisableSpacing(); }

	// [PIDݒiRg[ɂ\ɉeȂj
	void		SetLCID(DWORD lcid);
	// [PID擾iRg[ɂ\ɉeȂj
	DWORD		GetLCID(void) const;
	// [PIDݒLɂiRg[ɂ\ɉeȂj
	void		EnableLCID(void);
	// [PIDݒ𖳌ɂiRg[ɂ\ɉeȂj
	void		DisableLCID(void);
	// [PIDݒ肪LǂiRg[ɂ\ɉeȂj
	bool		IsLCID(void) const;
	/// [PIDݒiRg[ɂ\ɉeȂj
	void		FlagLCID(bool enable)				{ enable ? EnableLCID() : DisableLCID(); }

	// X^CݒiRg[ɂ\ɉeȂj
	void		SetCharStyle(SHORT sStyle);
	// X^C擾iRg[ɂ\ɉeȂj
	SHORT		GetCharStyle(void) const;
	// X^CݒLɂiRg[ɂ\ɉeȂj
	void		EnableCharStyle(void);
	// X^Cݒ𖳌ɂiRg[ɂ\ɉeȂj
	void		DisableCharStyle(void);
	// X^Cݒ肪LǂiRg[ɂ\ɉeȂj
	bool		IsCharStyle(void) const;
	///X^CݒiRg[ɂ\ɉeȂj
	void		FlagCharStyle(bool enable)				{ enable ? EnableCharStyle() : DisableCharStyle(); }

	// J[jOݒiRg[ɂ\ɉeȂj
	void		SetKerning(WORD sStyle);
	// J[jO擾iRg[ɂ\ɉeȂj
	WORD		GetKerning(void) const;
	// J[jOݒLɂiRg[ɂ\ɉeȂj
	void		EnableKerning(void);
	// J[jOݒ𖳌ɂiRg[ɂ\ɉeȂj
	void		DisableKerning(void);
	// J[jOݒ肪LǂiRg[ɂ\ɉeȂj
	bool		IsKerning(void) const;
	///J[jOݒiRg[ɂ\ɉeȂj
	void		FlagKerning(bool enable)				{ enable ? EnableKerning() : DisableKerning(); }
};

//! PARAFORMATNX
template<typename _TN>
class IParaFormat : public IIrisObject
{
	typedef _TN	Format;
protected:
	Format		m_Fmt;	//! PARAFORMAT
public:
	// RXgN^
	IParaFormat(void);
	IParaFormat(const Format& rFormat);
	// fXgN^
	~IParaFormat(void);

public:
	/// tH[}bg̎擾
			Format&	GetFormat(void)			{ return m_Fmt; }
	const	Format&	GetFormat(void)	const	{ return m_Fmt; }
	Format&	operator () (void)		{ return GetFormat(); }
	operator Format& (void)			{ return GetFormat(); }

public:
	// w肳ꂽi̍ŏ̍s̃Cfgݒ
	void		SetStartIndent(LONG lIndent);
	// w肳ꂽi̍ŏ̍s̃Cfg擾
	LONG		GetStartIndent(void) const;
	// w肳ꂽi̍ŏ̍s̃Cfgݒi΁jLɂ
	void		EnableStartIndent(void);
	// w肳ꂽi̍ŏ̍s̃Cfgݒi΁j𖳌ɂ
	void		DisableStartIndent(void);
	// w肳ꂽi̍ŏ̍s̃Cfgݒi΁jLǂ
	bool		IsStartIndent(void) const;
	// w肳ꂽi̍ŏ̍s̃Cfgݒi΁jLɂ
	void		EnableOffsetIndent(void);
	// w肳ꂽi̍ŏ̍s̃Cfgݒi΁j𖳌ɂ
	void		DisableOffsetIndent(void);
	// w肳ꂽi̍ŏ̍s̃Cfgݒi΁jLǂ
	bool		IsOffsetIndent(void) const;

	// w肳ꂽỉẼCfgݒ
	void		SetRightIndent(LONG lIndent);
	// w肳ꂽỉẼCfg擾
	LONG		GetRightIndent(void) const;
	// w肳ꂽỉẼCfgݒLɂ
	void		EnableRightIndent(void);
	// w肳ꂽỉẼCfgݒ𖳌ɂ
	void		DisableRightIndent(void);
	// w肳ꂽỉẼCfgݒ肪Lǂ
	bool		IsRightIndent(void) const;

	// 2sڈȍ~̍s̃Cfgݒ
	void		SetOffset(LONG lIndent);
	// 2sڈȍ~̍s̃Cfg擾
	LONG		GetOffset(void) const;
	// 2sڈȍ~̍s̃CfgݒLɂ
	void		EnableOffset(void);
	// 2sڈȍ~̍s̃Cfgݒ𖳌ɂ
	void		DisableOffset(void);
	// 2sڈȍ~̍s̃Cfgݒ肪Lǂ
	bool		IsOffset(void) const;

	// i̔zuݒ
	void		SetAlignment(WORD wAlignment);
	// i̔zu擾
	WORD		GetAlignment(void) const;
	// i̔zuݒLɂ
	void		EnableAlignment(void);
	// i̔zuݒ𖳌ɂ
	void		DisableAlignment(void);
	// i̔zuݒ肪Lǂ
	bool		IsAlignment(void) const;

	// ^uXgbv̐ݒ
	void		SetTabCount(SHORT sTabCount);
	// ^uXgbv̐擾
	SHORT		GetTabCount(void) const;
	// ^uXgbv̈ʒuݒ
	void		SetTabPos(int nIndex, LONG lPos);
	// ^uXgbv̈ʒu擾
	LONG		GetTabPos(int nIndex) const;
	// ^uXgbvݒLɂ
	void		EnableTabStops(void);
	// ^uXgbvݒ𖳌ɂ
	void		DisableTabStops(void);
	// ^uXgbvݒ肪Lǂ
	bool		IsTabStops(void) const;

	// ioOIvVݒ
	void		SetNumbering(WORD wNumbering);
	// ioOIvV擾
	WORD		GetNumbering(void) const;
	// ioOIvVݒLɂ
	void		EnableNumbering(void);
	// ioOIvVݒ𖳌ɂ
	void		DisableNumbering(void);
	// ioOIvVݒ肪Lǂ
	bool		IsNumbering(void) const;

	// ǐʂݒiRg[ɂ\ɉeȂj
	void		SetRtlPara(WORD sStyle);
	// ǐʂ擾iRg[ɂ\ɉeȂj
	WORD		GetRtlPara(void) const;
	// ǐʐݒLɂiRg[ɂ\ɉeȂj
	void		EnableRtlPara(void);
	// ǐʐݒ𖳌ɂiRg[ɂ\ɉeȂj
	void		DisableRtlPara(void);
	// ǐʊuݒ肪LǂiRg[ɂ\ɉeȂj
	bool		IsRtlPara(void) const;
};

//! PARAFORMAT2NX
template<typename _TN>
class IParaFormat2 : public IParaFormat<_TN>
{
};

}	// end of namespace wx
}	// end of namespace iris

#endif
