//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStackWalker.h
 * @brief		WXStackWalker t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXStackWalker_H_
#define INCG_IRIS_WXStackWalker_H_

//======================================================================
// include
#include "WXSymbol.h"
#include "../../os/WXThread.h"

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// class
/**
 * @brief	StackWalker NX
*/
class CStackWalker : public IIrisObject
{
public:
	CSymbol		m_Symbol;	//!< V{
	CThread		m_Thread;	//!< Xbhnh
	CONTEXT		m_Context;	//!< XbhReLXg
	STACKFRAME	m_Frame;	//!< t[
public:
	// RXgN^
	CStackWalker(void);
	// fXgN^
	~CStackWalker(void);

public:
	// Jn
	bool	Begin(HANDLE hProcess, HANDLE hThread);

	// ǂ
	bool	Walk(PREAD_PROCESS_MEMORY_ROUTINE ReadMemoryRoutine, PFUNCTION_TABLE_ACCESS_ROUTINE FunctionTableAccessRoutine
		, PGET_MODULE_BASE_ROUTINE GetModuleBaseRoutine, PTRANSLATE_ADDRESS_ROUTINE TranslateAddress);

	// I
	void	End(void);

public:
	// V{̎擾
	bool	GetSymbolName(LPTSTR lpszSymbolName, u32 length) const;
	// C̎擾
	bool	GetLine(PIMAGEHLP_LINE lpihl) const;
};

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris


#endif
