//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSymbol.h
 * @brief		WXSymbol t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSymbol_H_
#define INCG_IRIS_WXSymbol_H_

//======================================================================
// include
#include "../../os/WXProcess.h"
#include "WXDebugHelp.h"

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/// V{֌Wbp[NX
class CSymbol : public CProcess
{
public:
	// RXgN^
	CSymbol(void);
	CSymbol(HANDLE hProcess);
	// fXgN^
	virtual ~CSymbol(void);

public:
	// 
	BOOL	Initialize(PSTR UserSearchPath, BOOL bInvadeProcess);
	// N[Abv
	BOOL	Cleanup(void);

public:
	// V{e[u[h
	XDWORD	LoadModule(HANDLE hFile, PSTR ImageName, PSTR ModuleName, XDWORD BaseOfDll, DWORD SizeOfDll);
	// V{e[uA[h
	BOOL	UnloadModule(DWORD BaseOfDll);

public:
	// W[̗
	BOOL	EnumModules(PSYM_ENUMMODULES_CALLBACK pfnCallback, PVOID pUserData);
	// V{̗
	DBHLP_DEPRECIATED
	BOOL	EnumSymbols(XULONG BaseOfDll, PSYM_ENUMSYMBOLS_CALLBACK pfnCallback, PVOID pUserData);

	// ֐e[ũGgAhX擾
	LPVOID	FunctionTableAccess(DWORD AddrBase);
	// w肳ꂽAhXɑΉ\[Xsi\[XR[h̍sj
	BOOL	GetLineFromAddr(XDWORD dwAddr, PDWORD pdwDisplacement, PIMAGEHLP_LINE pLine) const;
	// w肳ꂽW[ƃt@CΉ\[Xsi\[XR[h̍sj
	BOOL	GetLineFromName(LPSTR ModuleName, LPSTR FileName, DWORD dwLineNumber, PLONG lpDisplacement, PIMAGEHLP_LINE pLine) const;
	// ̃\[Xs擾
	BOOL	GetLineNext(PIMAGEHLP_LINE pLine) const;
	// Õ\[Xs擾
	BOOL	GetLinePrev(PIMAGEHLP_LINE pLine) const;

	// w肳ꂽAhXɒuĂV{
	BOOL	GetSymFromAddr(XDWORD dwAddr, PDWORD pdwDisplacement, PIMAGEHLP_SYMBOL pSymbol) const;
	// w肳ꂽOɑΉV{
	BOOL	GetSymFromName(LPSTR Name, PIMAGEHLP_SYMBOL pSymbol) const;
	// ̃V{擾
	BOOL	GetSymNext(PIMAGEHLP_SYMBOL pSymbol) const;
	// ÕV{擾
	BOOL	GetSymPrev(PIMAGEHLP_SYMBOL pSymbol) const;

public:
	// W[̃x[XAhX擾
	XDWORD	GetModuleBase(XDWORD dwAddr) const;
	// w肳ꂽW[̃W[擾
	BOOL	GetModuleInfo(XDWORD dwAddr, PIMAGEHLP_MODULE ModuleInfo) const;

public:
	// w肳ꂽvZXp̌pX擾
	BOOL	GetSearchPath(PSTR SearchPath, DWORD SearchPathLength) const;
	// w肳ꂽvZXp̌pXݒ
	BOOL	SetSearchPath(PSTR SearchPath);

public:

	// V{nhgR[obN֐o^
	BOOL	RegisterCallback(PSYMBOL_REGISTERED_CALLBACK pfnCallback, PVOID pUserData);

	// Alpha Rs[^ŃX^bNEH[LOiA̍ƁjvV[Wp邽߂̃R[obN֐o^
	BOOL	RegisterFunctionEntryCallback(PSYMBOL_FUNCENTRY_CALLBACK pfnCallback, PVOID pUserData);

};

}	// end of namespace wx
}	// end of namespace iris

#endif
