//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCDDrive.h
 * @brief		CD Drive t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXCDDrive_H_
#define INCG_IRIS_WXCDDrive_H_

//======================================================================
// include
#include "WXDrive.h"

#if defined(_IRIS_SUPPORT_WDK)

EXTERN_C_BEGIN
#include "ntddcdrm.h"
EXTERN_C_END

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	CD hCuNX
*/
class CCDDrive : public CDrive
{
public:
	// RXgN^
	CCDDrive(void);
	// fXgN^
	virtual ~CCDDrive(void);

public:
	// ăI[v
	BOOL	SearchOpen(DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes
						, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile=nullptr);
public:
	// ANZX\ǂ
	BOOL	IsReady(void);

public:
	// WIg̎擾
	virtual bool	GetGeometry(PDISK_GEOMETRY geo) const;
	virtual bool	GetGeometryEx(PDISK_GEOMETRY_EX geo) const;

public:

	// ǂݍ
	BOOL	ReadRawData(LPVOID lpBuffer, DWORD dwSize, LPDWORD lpdwRead
		, TRACK_MODE_TYPE TrackMode, LONGLONG DiskOffset, DWORD nSector=0, LPOVERLAPPED lpOverlapped=nullptr);
public:
	// ~
	BOOL	Stop(void);

public:
	// f
	BOOL	Suspend(void);
	// ĊJ
	BOOL	Resume(void);
	// fƍĊJ
	BOOL	Pause(BOOL bPause);

public:
	// fBA
	BOOL	EjectMedia(void);
	// fBA}
	BOOL	InsertMedia(void);
	// fBAւ/֎~
	BOOL	PreventMediaRemoval(BOOLEAN bPrevent);
};

}	// end of namespace wx
}	// end of namespace iris

#endif

#endif
