//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindProcess.cpp
 * @brief		Process NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFindProcess_CPP_

//======================================================================
// include
#include "WXFindProcess.h"
#include "iris_xchar.hpp"
#include <tchar.h>

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTFindProcess<CHARTYPE_>::CTFindProcess(void)
{
	SecureZeroMemory(&m_Entry, sizeof(m_Entry));
	m_Entry.dwSize = sizeof(m_Entry);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTFindProcess<CHARTYPE_>::~CTFindProcess(void)
{
}

/**********************************************************************//**
 *
 * vZX猟
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszProcessName	= vZX(exe)
 * @return	vZXID
*//***********************************************************************/
template<typename CHARTYPE_>
DWORD CTFindProcess<CHARTYPE_>::FindProcessId(_Mylpcstr lpszProcessName)
{
	if( lpszProcessName == nullptr ) return 0;
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	if( (toolhelp.GetFlags() & TH32CS_SNAPPROCESS) == 0 )
	{
		if( !toolhelp.Open(toolhelp.GetFlags() | TH32CS_SNAPPROCESS) ) return 0;
	}
	if( toolhelp.Process32First(&m_Entry) )
	{
		while(1)
		{
			if( xcsicmp(m_Entry.szExeFile, lpszProcessName) == 0 )
			{
				return m_Entry.th32ProcessID;
			}
			if( !toolhelp.Process32Next(&m_Entry) ) break;
		}
	}
	return 0;
}

/**********************************************************************//**
 *
 * vZX玟
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszProcessName	= vZX(exe)
 * @return	vZXID
*//***********************************************************************/
template<typename CHARTYPE_>
DWORD CTFindProcess<CHARTYPE_>::FindProcessIdNext(_Mylpcstr lpszProcessName)
{
	if( lpszProcessName == nullptr ) return 0;
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	while(1)
	{
		if( !toolhelp.Process32Next(&m_Entry) ) break;
		if( xcsicmp(m_Entry.szExeFile, lpszProcessName) == 0 )
		{
			return m_Entry.th32ProcessID;
		}
	}
	return 0;
}

/**********************************************************************//**
 *
 * vZXIDevZXID
 *
 -----------------------------------------------------------------------
 * @param [in]	dwID	= vZXID
 * @return	evZXID
*//***********************************************************************/
template<typename CHARTYPE_>
DWORD CTFindProcess<CHARTYPE_>::FindParentProcessId(DWORD dwID)
{
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	if( (toolhelp.GetFlags() & TH32CS_SNAPPROCESS) == 0 )
	{
		if( !toolhelp.Open(toolhelp.GetFlags() | TH32CS_SNAPPROCESS) ) return 0;
	}
	if( toolhelp.Process32First(&m_Entry) )
	{
		while(1)
		{
			if( m_Entry.th32ProcessID == dwID )
			{
				return m_Entry.th32ParentProcessID;
			}
			if( !toolhelp.Process32Next(&m_Entry) ) break;
		}
	}
	return 0;
}

template class CTFindProcess<CHAR>;
template class CTFindProcess<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris

#if	(defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "iris_using.h"

TEST(CFindProcessTest, Function)
{
	CFindProcess find;
	ASSERT_NE( 0, find.FindProcessId(TEXT("EXPLORER.exe")) );
}

#endif
