//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXWab.cpp
 * @brief		WABt@C
 *
 *
 * @note		TODO: WCHAR ΏKviMicrosoft̃oOΏj
 *				WCHAR̍Ē`ŃG[ƂȂ邽߁AYӏRgAEgȂǂĂB
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXWab_CPP_

//======================================================================
// include
#include "WXWab.h"

#if	!defined(IRIS_WIN32_WCE)

namespace iris {
namespace wx
{

//======================================================================
// macro
#define CHECK_INSTANCE()	{ if( s_hLibWab == nullptr ) LoadInstance(); }

//======================================================================
// static membar
HINSTANCE			CWab::s_hLibWab		= nullptr;
CWab::WABOpenProc	CWab::s_WABOpenProc = nullptr;

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CWab::CWab(void)
: m_lpAdrBook(nullptr)
, m_lpWABObject(nullptr)
, m_lpEntryID(nullptr)
, m_lpcbEntryID(0)
, m_ulObjType(0)
{
	LoadInstance();
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CWab::~CWab(void)
{
}

/**********************************************************************//**
 *
 * CX^X
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CWab::LoadInstance(void)
{
	if( s_hLibWab != nullptr ) return true;
	s_hLibWab = LoadLibrary(TEXT("C:\\Program Files\\Common Files\\System\\wab32.dll"));
	if( s_hLibWab == nullptr )
	{
		// Cu̓ǂݍݎs
		s_hLibWab = LoadLibrary(TEXT("wab32.dll"));
		if( s_hLibWab == nullptr )
		{
			return false;
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * CX^Xj
 *
*//***********************************************************************/
void CWab::UnloadInstance(void)
{
	FreeLibrary(s_hLibWab);
	s_hLibWab = nullptr;
	// ֐|C^̏
	s_WABOpenProc = nullptr;
}

/**********************************************************************//**
 *
 * WABOpen
 *
 ----------------------------------------------------------------------
 * @param [in]	lpWabParam	= 
 * @param [in]	Reserved2	= 
 * @return	
*//***********************************************************************/
bool CWab::WABOpen(LPWAB_PARAM lpWabParam, DWORD Reserved2 )
{
	HRESULT hr;
	CHECK_INSTANCE();
	if( s_WABOpenProc == nullptr )
	{
		// ֐|C^̎擾
		s_WABOpenProc = (WABOpenProc)GetProcAddress(s_hLibWab,"WABOpen");
		if( s_WABOpenProc == nullptr ) return false;
	}
	hr = (s_WABOpenProc)(&m_lpAdrBook, &m_lpWABObject, lpWabParam, Reserved2 );
	if( hr != S_OK ) return false;
	return true;
}

/**********************************************************************//**
 *
 * WABEntry
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CWab::WABEntry(void)
{
	CHECK_INSTANCE();
	HRESULT hr;
	hr = m_lpAdrBook->GetPAB(
		&m_lpcbEntryID,
		&m_lpEntryID
	);
	if( hr != S_OK ) return false;

	ULONG ulFlags = MAPI_BEST_ACCESS;
	m_ulObjType = 0;
	m_lpUnk = nullptr;
	hr = m_lpAdrBook->OpenEntry(
		m_lpcbEntryID,
		m_lpEntryID,
		nullptr,
		ulFlags,
		&m_ulObjType,
		&m_lpUnk
	);
	if( hr != S_OK ) return false;
	return true;
}

/**********************************************************************//**
 *
 * GetABSRows
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
LPSRowSet CWab::GetABSRows(void)
{
	CHECK_INSTANCE();
	HRESULT hr;
	if(m_ulObjType != MAPI_ABCONT) return nullptr;

	ULONG ulFlags = 0;
	LPABCONT lpContainer = static_cast<LPABCONT>(m_lpUnk);
	LPMAPITABLE lpTable = nullptr;
	hr = lpContainer->GetContentsTable(
		ulFlags,
		&lpTable
	);
	if( lpTable == nullptr ) return nullptr;

	ULONG ulRows;
	hr = lpTable->GetRowCount(0, &ulRows);
	if( hr != S_OK ) return nullptr;
	SRowSet *lpRows = nullptr;

	hr = lpTable->QueryRows(
		ulRows,		// Get all Rows
		0,
		&lpRows
	);
	if( hr != S_OK ) return nullptr;
	return lpRows;
}

/**********************************************************************//**
 *
 * Open(WABOpenbp[)
 *
 ----------------------------------------------------------------------
 * @param [in]	path		= 
 * @param [in]	hWnd		= 
 * @param [in]	ulFlag		= 
 * @param [in]	Reserved2	= 
 * @return	
*//***********************************************************************/
bool CWab::Open(LPSTR path, HWND hWnd, ULONG ulFlag, DWORD Reserved2)
{
	WAB_PARAM param;
	ZeroMemory(&param,sizeof(param));
	param.cbSize		= sizeof(WAB_PARAM);
	param.hwnd			= hWnd;
	param.szFileName	= path;
	param.ulFlags		= ulFlag;
	return WABOpen(&param,Reserved2);
}

/**********************************************************************//**
 *
 * f[^擾
 *
 ----------------------------------------------------------------------
 * @param [in]	func	= f[^󂯎֐
 * @param [in]	args	= ֐ɓn
 * @return	
*//***********************************************************************/
bool CWab::GetValue(WABGetValueProc func, LPVOID args)
{
	bool ret = false;
	if( func == nullptr ) return false;
	if( !WABEntry() ) return false;
	if( m_ulObjType == MAPI_ABCONT )
	{
		LPSRowSet lpRows = GetABSRows();
		if( lpRows == nullptr ) return false;

		for(ULONG i=0; i < lpRows->cRows; ++i)
		{
			LPSRow lpRow = &lpRows->aRow[i];
			for(ULONG j=0; j < lpRow->cValues; ++j)
			{
				LPSPropValue lpProp = &lpRow->lpProps[j];
				(*func)(lpProp,i,j,args);
			}
			FreeBuffer(lpRow);
		}
		ret = true;
		FreeBuffer(lpRows);
	}
	return ret;
}

}	// end of namespace wx
}	// end of namespace iris

#endif
