//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDesktopProfile.cpp
 * @brief		Desktop.iniNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDesktopProfile_CPP_

//======================================================================
// include
#include "WXDesktopProfile.h"
#include "iris_xchar.hpp"
#include <tchar.h>

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL ReadDesktopProfile (LPCTSTR lpszDirectory, LPTSTR lpszImagePath, DWORD dwImagePathSize
						 , LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
#ifdef UNICODE
	return ReadDesktopProfileW(lpszDirectory, lpszImagePath, dwImagePathSize, lpdwTextColor, lpdwTextBkColor);
#else
	return ReadDesktopProfileA(lpszDirectory, lpszImagePath, dwImagePathSize, lpdwTextColor, lpdwTextBkColor);
#endif
}
/// ReadDesktopProfile Q
BOOL ReadDesktopProfileA(LPCSTR  lpszDirectory, LPSTR lpszImagePath, DWORD dwImagePathSize
						 , LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::string path = lpszDirectory;
	path += "\\Desktop.ini";
	if( GetFileAttributesA(lpszDirectory) == (DWORD)-1 ) return FALSE;
	if( lpszImagePath != nullptr )
		GetPrivateProfileStringA(DESKTOP_PROFILE_APPNAME_IMAGEA, DESKTOP_PROFILE_SECNAME_IMAGEA, "", lpszImagePath, dwImagePathSize, path.c_str());
	if( lpdwTextColor != nullptr )
		*lpdwTextColor	= GetPrivateProfileHexA(DESKTOP_PROFILE_APPNAME_IMAGEA, DESKTOP_PROFILE_SECNAME_COLORA	, *lpdwTextColor	, path.c_str());
	if( lpdwTextBkColor != nullptr )
		*lpdwTextBkColor= GetPrivateProfileHexA(DESKTOP_PROFILE_APPNAME_IMAGEA, DESKTOP_PROFILE_SECNAME_BKCOLORA	, *lpdwTextBkColor	, path.c_str());
	return TRUE;
}
/// ReadDesktopProfile Q
BOOL ReadDesktopProfileW(LPCWSTR lpszDirectory, LPWSTR lpszImagePath, DWORD dwImagePathSize
						 , LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::wstring path = lpszDirectory;
	path += L"\\Desktop.ini";
	if( GetFileAttributesW(lpszDirectory) == (DWORD)-1 ) return FALSE;
	if( lpszImagePath != nullptr )
		GetPrivateProfileStringW(DESKTOP_PROFILE_APPNAME_IMAGEW, DESKTOP_PROFILE_SECNAME_IMAGEW, L"", lpszImagePath, dwImagePathSize, path.c_str());
	if( lpdwTextColor != nullptr )
		*lpdwTextColor	= GetPrivateProfileHexW(DESKTOP_PROFILE_APPNAME_IMAGEW, DESKTOP_PROFILE_SECNAME_COLORW	, *lpdwTextColor	, path.c_str());
	if( lpdwTextBkColor != nullptr )
		*lpdwTextBkColor= GetPrivateProfileHexW(DESKTOP_PROFILE_APPNAME_IMAGEW, DESKTOP_PROFILE_SECNAME_BKCOLORW	, *lpdwTextBkColor	, path.c_str());
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL WriteDesktopProfile (LPCTSTR lpszDirectory, LPCTSTR lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
#ifdef UNICODE
	return WriteDesktopProfileW(lpszDirectory, lpszImagePath, lpdwTextColor, lpdwTextBkColor);
#else
	return WriteDesktopProfileA(lpszDirectory, lpszImagePath, lpdwTextColor, lpdwTextBkColor);
#endif
}
/// WriteDesktopProfile Q
BOOL WriteDesktopProfileA(LPCSTR  lpszDirectory, LPCSTR  lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::string path = lpszDirectory;
	path += "\\Desktop.ini";
	LPCSTR p = path.c_str();
	WritePrivateProfileStringA(DESKTOP_PROFILE_APPNAME_IMAGEA, DESKTOP_PROFILE_SECNAME_IMAGEA, lpszImagePath, p);
	WritePrivateProfileStringA(DESKTOP_PROFILE_APPNAME_IMAGEA, DESKTOP_PROFILE_SECNAME_ATTRIBUTESA, "1", p);
	CHAR val[128];
	LPSTR pval1 = nullptr;
	LPSTR pval2 = nullptr;
	if( lpdwTextColor != nullptr )
	{
		wsprintfA(val, "0x%0.8x", *lpdwTextColor);
		pval1 = val;
	}
	WritePrivateProfileStringA(DESKTOP_PROFILE_APPNAME_IMAGEA, DESKTOP_PROFILE_SECNAME_COLORA, pval1, p);
	if( lpdwTextBkColor != nullptr )
	{
		wsprintfA(val, "0x%0.8x", *lpdwTextBkColor);
		pval2 = val;
	}
	WritePrivateProfileStringA(DESKTOP_PROFILE_APPNAME_IMAGEA, DESKTOP_PROFILE_SECNAME_BKCOLORA, pval2, p);
	// tH_̑ύX
	SetFileAttributesA(lpszDirectory, GetFileAttributesA(lpszDirectory) | FILE_ATTRIBUTE_SYSTEM );
	SetFileAttributesA(p, FILE_ATTRIBUTE_SYSTEM|FILE_ATTRIBUTE_HIDDEN );
	return TRUE;
}
/// WriteDesktopProfile Q
BOOL WriteDesktopProfileW(LPCWSTR lpszDirectory, LPCWSTR lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::wstring path = lpszDirectory;
	path += L"\\Desktop.ini";
	LPCWSTR p = path.c_str();
	WritePrivateProfileStringW(DESKTOP_PROFILE_APPNAME_IMAGEW, DESKTOP_PROFILE_SECNAME_IMAGEW, lpszImagePath, p);
	WritePrivateProfileStringW(DESKTOP_PROFILE_APPNAME_IMAGEW, DESKTOP_PROFILE_SECNAME_ATTRIBUTESW, L"1", p);
	WCHAR val[128];
	LPWSTR pval1 = nullptr;
	LPWSTR pval2 = nullptr;
	if( lpdwTextColor != nullptr )
	{
		wsprintfW(val, L"0x%0.8x", *lpdwTextColor);
		pval1 = val;
	}
	WritePrivateProfileStringW(DESKTOP_PROFILE_APPNAME_IMAGEW, DESKTOP_PROFILE_SECNAME_COLORW, pval1, p);
	if( lpdwTextBkColor != nullptr )
	{
		wsprintfW(val, L"0x%0.8x", *lpdwTextBkColor);
		pval2 = val;
	}
	WritePrivateProfileStringW(DESKTOP_PROFILE_APPNAME_IMAGEW, DESKTOP_PROFILE_SECNAME_BKCOLORW, pval2, p);
	// tH_̑ύX
	SetFileAttributesW(lpszDirectory, GetFileAttributesW(lpszDirectory) | FILE_ATTRIBUTE_SYSTEM );
	SetFileAttributesW(p, FILE_ATTRIBUTE_SYSTEM|FILE_ATTRIBUTE_HIDDEN );
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL ClearDesktopProfile (LPCTSTR lpszDirectory)
{
#ifdef UNICODE
	return ClearDesktopProfileW(lpszDirectory);
#else
	return ClearDesktopProfileA(lpszDirectory);
#endif
}
/// ClearDesktopProfile Q
BOOL ClearDesktopProfileA(LPCSTR  lpszDirectory)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::string path = lpszDirectory;
	path += "\\Desktop.ini";
	LPCSTR p = path.c_str();
	return WritePrivateProfileStringA(DESKTOP_PROFILE_APPNAME_IMAGEA, nullptr, nullptr, p);
}
/// ClearDesktopProfile Q
BOOL ClearDesktopProfileW(LPCWSTR lpszDirectory)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::wstring path = lpszDirectory;
	path += L"\\Desktop.ini";
	LPCWSTR p = path.c_str();
	return WritePrivateProfileStringW(DESKTOP_PROFILE_APPNAME_IMAGEW, nullptr, nullptr, p);
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTDesktopProfile<CHARTYPE_>::CTDesktopProfile(void)
: m_dwTextColor(0)
, m_dwTextBkColor(0xFFFFFFFF)
{
	ZeroMemory( m_ImagePath, sizeof(m_ImagePath) );
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTDesktopProfile<CHARTYPE_>::~CTDesktopProfile(void)
{
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
template<>
BOOL CTDesktopProfile<CHAR>::Read(_Mylpcstr lpszDirectory)
{
	_Mystring path = lpszDirectory;
	path += IRIS_XTEXT(_Mychar, "\\Desktop.ini");
	Open(path.c_str());
	if( !MakeProfileList() ) return FALSE;
	m_dwTextColor	= 0x00000000;
	m_dwTextBkColor	= 0xFFFFFFFF;
	return ReadDesktopProfileA(lpszDirectory, m_ImagePath, MAX_PATH, &m_dwTextColor, &m_dwTextBkColor);
}
template<>
BOOL CTDesktopProfile<WCHAR>::Read(_Mylpcstr lpszDirectory)
{
	_Mystring path = lpszDirectory;
	path += IRIS_XTEXT(_Mychar, "\\Desktop.ini");
	Open(path.c_str());
	if( !MakeProfileList() ) return FALSE;
	m_dwTextColor	= 0x00000000;
	m_dwTextBkColor	= 0xFFFFFFFF;
	return ReadDesktopProfileW(lpszDirectory, m_ImagePath, MAX_PATH, &m_dwTextColor, &m_dwTextBkColor);
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTDesktopProfile<CHARTYPE_>::Write(_Mylpcstr lpszDirectory)
{
	return CTDesktopProfile::WriteDesktopProfile(lpszDirectory, m_ImagePath, &m_dwTextColor, &m_dwTextBkColor);
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTDesktopProfile<CHARTYPE_>::Write(_Mylpcstr lpszDirectory, bool bImage, bool bColor, bool bBkColor)
{
	return CTDesktopProfile::WriteDesktopProfile(lpszDirectory, bImage ? m_ImagePath : nullptr
		, bColor ? &m_dwTextColor : nullptr
		, bBkColor ? &m_dwTextBkColor : nullptr );
}

/**********************************************************************//**
 *
 * NA
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
template<>
BOOL CTDesktopProfile<CHAR>::Clear(_Mylpcstr lpszDirectory)
{
	return ClearDesktopProfileA(lpszDirectory);
}
template<>
BOOL CTDesktopProfile<WCHAR>::Clear(_Mylpcstr lpszDirectory)
{
	return ClearDesktopProfileW(lpszDirectory);
}

template<typename CHARTYPE_>
void CTDesktopProfile<CHARTYPE_>::SetImagePath(_Mylpcstr lpszPath)
{
	xcscpy_s(m_ImagePath, MAX_PATH, lpszPath);
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
template<>
BOOL CTDesktopProfile<CHAR>::WriteDesktopProfile(_Mylpcstr lpszDirectory, _Mylpcstr lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
	return WriteDesktopProfileA(lpszDirectory, lpszImagePath, lpdwTextColor, lpdwTextBkColor);
}
template<>
BOOL CTDesktopProfile<WCHAR>::WriteDesktopProfile(_Mylpcstr lpszDirectory, _Mylpcstr lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
	return WriteDesktopProfileW(lpszDirectory, lpszImagePath, lpdwTextColor, lpdwTextBkColor);
}


template class CTDesktopProfile<CHAR>;
template class CTDesktopProfile<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/unittest/WXDebugUnitTest.h"
#include "../../shell/WXSHExecute.h"
#include "iris_using.h"
#include "iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CWXDesktopProfileUnitTest, Func)
{
	TCHAR dir[MAX_PATH];
	GetCurrentDirectory(MAX_PATH, dir);
	CDesktopProfile dp;
	dp.Read(dir);
	dp.SetTextColor(0x000000FF);
	dp.SetTextBkColor(0x00FF0000);
	if( !dp.Write(dir) ) return;

	CSHExecute::Run(nullptr, TEXT("open"), TEXT("explorer"), dir, nullptr, SW_SHOW);

	std::cout << "tH_āAȂɂ͂ĂBݒɖ߂܂B" << std::endl;
	getchar();

	dp.WriteList(true);

	CSHExecute::Run(nullptr, TEXT("open"), TEXT("explorer"), dir, nullptr, SW_SHOW);

}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
