//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXInstallRegistry.cpp
 * @brief		WXg̃CXg[擾NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXInstallRegistry_CPP_

//======================================================================
// include
#include "WXInstallRegistry.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * CXg[ς݂ǂ
 *
 -----------------------------------------------------------------------
 * @param [in]	pDisplayName	= DisplayName L[̕
 * @return ^Ul
*//***********************************************************************/
bool CInstallRegistry::IsInstall (LPCTSTR pDisplayName)
{
#ifdef UNICODE
	return IsInstallW(pDisplayName);
#else
	return IsInstallA(pDisplayName);
#endif
}
/// CInstallRegistry::IsInstall Q
bool CInstallRegistry::IsInstallA(LPCSTR  pDisplayName)
{
	IRIS_ASSERT( pDisplayName != nullptr );
	IRIS_ASSERT( pDisplayName[0] != '\0' );

	CHAR root_key[] = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
	CHAR key[MAX_PATH];
	DWORD key_size = MAX_PATH;
	CRegistry root;
	if( !root.OpenEx(HKEY_LOCAL_MACHINE, root_key, 0, KEY_ALL_ACCESS) ) return false;
	DWORD dwIndex = 0;
	DWORD dwValueSize = 0, dwType;
	for( dwIndex = 0; ; ++dwIndex )
	{
		LSTATUS lstatus = root.EnumKey(dwIndex, key, key_size);
		if( lstatus == ERROR_NO_MORE_ITEMS ) break;
		IRIS_ASSERT( lstatus == ERROR_SUCCESS );

		CRegistry reg;
		if( reg.OpenEx(root, key, 0, KEY_ALL_ACCESS) )
		{
			if( reg.QueryValueEx("DisplayName", &dwType, nullptr, &dwValueSize) )
			{
				LPSTR value = new char [dwValueSize];
				if( reg.QueryValueEx("DisplayName", &dwType, pointer_cast<LPBYTE>(value), &dwValueSize) )
				{
					if( strcmp(pDisplayName, value ) == 0 )
					{
						delete [] value;
						return true;
					}
				}
				delete [] value;
			}
		}
	}
	return false;
}
/// CInstallRegistry::IsInstall Q
bool CInstallRegistry::IsInstallW(LPCWSTR pDisplayName)
{
	IRIS_ASSERT( pDisplayName != nullptr );
	IRIS_ASSERT( pDisplayName[0] != '\0' );

	WCHAR root_key[] = L"Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
	WCHAR key[MAX_PATH];
	DWORD key_size = MAX_PATH;
	CRegistry root;
	if( !root.OpenEx(HKEY_LOCAL_MACHINE, root_key, 0, KEY_ALL_ACCESS) ) return false;
	DWORD dwIndex = 0;
	DWORD dwValueSize = 0, dwType;
	for( dwIndex = 0; ; ++dwIndex )
	{
		LSTATUS lstatus = root.EnumKey(dwIndex, key, key_size);
		if( lstatus == ERROR_NO_MORE_ITEMS ) break;
		IRIS_ASSERT( lstatus == ERROR_SUCCESS );

		CRegistry reg;
		if( reg.OpenEx(root, key, 0, KEY_ALL_ACCESS) )
		{
			if( reg.QueryValueEx(L"DisplayName", &dwType, nullptr, &dwValueSize) )
			{
				LPWSTR value = new WCHAR [dwValueSize/sizeof(WCHAR)];
				if( reg.QueryValueEx(L"DisplayName", &dwType, pointer_cast<LPBYTE>(value), &dwValueSize) )
				{
					if( wcscmp(pDisplayName, value ) == 0 )
					{
						delete [] value;
						return true;
					}
				}
				delete [] value;
			}
		}
	}
	return false;
}

/**********************************************************************//**
 *
 * CXg[pX̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pDst			= o̓obt@
 * @param [in]	dwSize			= o̓obt@TCY
 * @param [in]	pDisplayName	= DisplayName L[̕
 * @return 
*//***********************************************************************/
bool CInstallRegistry::GetPath (LPTSTR pDst, DWORD dwSize, LPCTSTR pDisplayName)
{
#ifdef UNICODE
	return GetPathW(pDst, dwSize, pDisplayName);
#else
	return GetPathA(pDst, dwSize, pDisplayName);
#endif
}
/// CInstallRegistry::GetPath Q
bool CInstallRegistry::GetPathA(LPSTR  pDst, DWORD dwSize, LPCSTR  pDisplayName)
{
	IRIS_ASSERT( pDisplayName != nullptr );
	IRIS_ASSERT( pDisplayName[0] != '\0' );

	CHAR root_key[] = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
	CHAR key[MAX_PATH];
	DWORD key_size = MAX_PATH;
	CRegistry root;
	if( !root.OpenEx(HKEY_LOCAL_MACHINE, root_key, 0, KEY_ALL_ACCESS) ) return false;
	DWORD dwIndex = 0;
	DWORD dwValueSize = 0, dwType;
	for( dwIndex = 0; ; ++dwIndex )
	{
		LSTATUS lstatus = root.EnumKey(dwIndex, key, key_size);
		if( lstatus == ERROR_NO_MORE_ITEMS ) break;
		IRIS_ASSERT( lstatus == ERROR_SUCCESS );

		CRegistry reg;
		if( reg.OpenEx(root, key, 0, KEY_ALL_ACCESS) )
		{
			if( reg.QueryValueEx("DisplayName", &dwType, nullptr, &dwValueSize) )
			{
				LPSTR value = new char [dwValueSize];
				if( reg.QueryValueEx("DisplayName", &dwType, pointer_cast<LPBYTE>(value), &dwValueSize) )
				{
					if( strcmp(pDisplayName, value ) == 0 )
					{
						if( reg.QueryValueEx("InstallLocation", &dwType, nullptr, &dwValueSize) )
						{
							delete [] value;
							if( pDst != nullptr && dwSize <= dwValueSize )
							{
								reg.QueryValueEx("InstallLocation", &dwType, pointer_cast<LPBYTE>(pDst), &dwValueSize);
							}
							return true;
						}
					}
				}
				delete [] value;
			}
		}
	}
	return false;
}
/// CInstallRegistry::GetPath Q
bool CInstallRegistry::GetPathW(LPWSTR pDst, DWORD dwSize, LPCWSTR pDisplayName)
{
	IRIS_ASSERT( pDst != nullptr );
	IRIS_ASSERT( pDisplayName != nullptr );
	IRIS_ASSERT( pDisplayName[0] != '\0' );
	IRIS_ASSERT( dwSize > 0 );

	WCHAR root_key[] = L"Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
	WCHAR key[MAX_PATH];
	DWORD key_size = MAX_PATH;
	CRegistry root;
	if( !root.OpenEx(HKEY_LOCAL_MACHINE, root_key, 0, KEY_ALL_ACCESS) ) return false;
	DWORD dwIndex = 0;
	DWORD dwValueSize = 0, dwType;
	for( dwIndex = 0; ; ++dwIndex )
	{
		LSTATUS lstatus = root.EnumKey(dwIndex, key, key_size);
		if( lstatus == ERROR_NO_MORE_ITEMS ) break;
		IRIS_ASSERT( lstatus == ERROR_SUCCESS );

		CRegistry reg;
		if( reg.OpenEx(root, key, 0, KEY_ALL_ACCESS) )
		{
			if( reg.QueryValueEx(L"DisplayName", &dwType, nullptr, &dwValueSize) )
			{
				LPWSTR value = new WCHAR [dwValueSize/sizeof(WCHAR)];
				if( reg.QueryValueEx(L"DisplayName", &dwType, pointer_cast<LPBYTE>(value), &dwValueSize) )
				{
					if( wcscmp(pDisplayName, value ) == 0 )
					{
						if( reg.QueryValueEx(L"InstallLocation", &dwType, nullptr, &dwValueSize) )
						{
							delete [] value;
							if( pDst != nullptr && dwSize <= dwValueSize )
							{
								reg.QueryValueEx(L"InstallLocation", &dwType, pointer_cast<LPBYTE>(pDst), &dwValueSize);
							}
							return true;
						}
					}
				}
				delete [] value;
			}
		}
	}
	return false;
}


}	// end of namespace wx
}	// end of namespace iris

