//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiGL.h
 * @brief		wglgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXGdiGL_H_
#define INCG_IRIS_WXGdiGL_H_

//======================================================================
// include
#include "iris_object.h"

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/// wgl contextNX
class CWglContext : public IIrisObject
{
protected:
	HGLRC	m_hRC;	//!< ReLXg
	HDC		m_hDC;	//!< DC
public:
	// RXgN^
	CWglContext(void);
	// fXgN^
	virtual ~CWglContext(void);
public:
	// 쐬
	BOOL	Create(HDC hDC);
	// 
	BOOL	Delete(void);

	// JgReLXgɐݒ
	BOOL	PushCurrent(void);
	// JgReLXg͂
	BOOL	PopCurrent(void);

public:
	// ֘At
	BOOL	Attach(HDC hDC, HGLRC hRC);
	// ֘At̉
	HGLRC	Detach(void);
};


}	// end of namespace wx
}	// end of namespace iris

#endif
