//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXLogFont.h
 * @brief		LOGFONTNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXLogFont_H_
#define INCG_IRIS_WXLogFont_H_

//======================================================================
// include
#include "iris_object.h"
#include "c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace wx
{

//======================================================================
// decalre
template<typename CHARTYPE_>class CTLogFont;

//======================================================================
// typedef
typedef CTLogFont<CHAR>		CLogFontA;
typedef CTLogFont<WCHAR>	CLogFontW;
typedef CTLogFont<TCHAR>	CLogFont;

//======================================================================
// class
//! LOGFONT NX
template<typename CHARTYPE_>
class CTLogFont : public IIrisObject
{
	typedef CTLogFont<CHARTYPE_>	_Myt;
protected:
	typedef CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;

public:
	typedef typename iml::type_select< (cpp0x::is_same<_Mychar, WCHAR>::value), LOGFONTW, LOGFONTA >::type XLOGFONT;
	typedef XLOGFONT	*LPXLOGFONT;
};

}	// end of namespace wx
}	// end of namespace iris

#endif
