//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRegion.h
 * @brief		[W t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXRegion_H_
#define INCG_IRIS_WXRegion_H_

//======================================================================
// include
#include "WXGdiObject.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	HRGN NX
*/
class CRegion : public CGDIObjectBase<HRGN>
{
	typedef CGDIObjectBase<HRGN>	_Mybase;
public:
	// RXgN^
	CRegion(void);

public:
	// `[W̍쐬
	BOOL	CreateRect(int left, int top, int right, int bottom);
	BOOL	CreateRect(const LPRECT lprc);
	// pۋ`[W̍쐬
	BOOL	CreateRoundRect(int left, int top, int right, int bottom, int widthEllipse, int heightEllipse);
	BOOL	CreateRoundRect(const LPRECT lprc, int widthEllipse, int heightEllipse);
	// ȉ~[W̍쐬
	BOOL	CreateElliptic(int x1, int y1, int x2, int y2);
	BOOL	CreateElliptic(const LPRECT lprc);
	// p`[W̍쐬
	BOOL	CreatePolygon(const LPPOINT lppt, int nPoint, int nFillMode);
	// p`[W̍쐬
	BOOL	CreatePolyPolygon(const LPPOINT lppt, const LPINT lpPointCount, int nCount, int nFillMode);
	// Wϊf[^쐬
	BOOL	CreateExt(const LPXFORM lpXform, DWORD nCount, const LPRGNDATA lpRgnData);
	// bitmap 쐬
	BOOL	CreateFromBitmap(HBITMAP hBmp, COLORREF ExtColor);

public:
	// t@C烍[h
	template<typename CHRATYPE_>
	BOOL	Load (const CHRATYPE_* lpszFileName, const LPXFORM lpXform=nullptr);
public:
	// [Wf[^̎擾
	DWORD	GetData(DWORD dwCount, LPRGNDATA lpRgnData) const;
public:
	// r
	BOOL	IsEqual(HRGN hRgn)	const;
	// Rs[쐬
	int		Copy(HRGN hRgn);
	// 
	int		Combine(HRGN hRgn, int fMode);
	int		Union(HRGN hRgn);
	int		Xor(HRGN hRgn);
	// [W܂ލŏ̋`擾
	int		GetBox(LPRECT lprc)	const;
	// w肵|Cg[Wɂ邩ǂ
	BOOL	IsPointIn(int x, int y)	const;
	// w肵̈ïꕔj[Wɂ邩ǂ
	BOOL	IsRectIn(int x1, int y1, int x2, int y2)	const;
	BOOL	IsRectIn(const LPRECT lprc)	const;

public:
	// hԂ
	BOOL	Fill(HDC hdc, HBRUSH hBrush);
	BOOL	Fill(HDC hdc);
	BOOL	Paint(HDC hdc);
	// g`
	BOOL	Frame(HDC hdc, HBRUSH hBrush, int w, int h);
	// [W̐F𔽓]
	BOOL	Invert(HDC hdc);
	// [Wړ
	int		Offset(int x, int y);


public:
	// operator
	BOOL	operator == (HRGN hRgn) const	{ return IsEqual(hRgn); }
	BOOL	operator != (HRGN hRgn) const	{ return IsEqual(hRgn) ? FALSE : TRUE; }

	CRegion&	operator += (HRGN hRgn)	{ Combine(hRgn, RGN_OR  ); return *this; }
	CRegion&	operator -= (HRGN hRgn)	{ Combine(hRgn, RGN_DIFF); return *this; }
	CRegion&	operator |= (HRGN hRgn)	{ Combine(hRgn, RGN_OR  ); return *this; }
	CRegion&	operator &= (HRGN hRgn)	{ Combine(hRgn, RGN_AND ); return *this; }
	CRegion&	operator ^= (HRGN hRgn)	{ Combine(hRgn, RGN_XOR ); return *this; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
