//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMonitor.cpp
 * @brief		j^[foCX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMonitor_CPP_

//======================================================================
// include
#include "WXMonitor.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMonitor::CMonitor(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMonitor::CMonitor(HMONITOR hObj)
: _MyBase(hObj)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMonitor::CMonitor(const CMonitor& rhs)
: _MyBase(rhs)
{
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool CMonitor::Close(void)
{
	return true;
}

/**********************************************************************//**
 *
 * ̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	lpmi	= o
 * @return 
*//***********************************************************************/
BOOL CMonitor::GetInfo (LPMONITORINFO lpmi) const
{
#ifdef UNICODE
	return GetInfoW(lpmi);
#else
	return GetInfoA(lpmi);
#endif
}
/// @ref GetInfo
BOOL CMonitor::GetInfoA(LPMONITORINFO lpmi) const
{
#if WINVER >= 0x0500
	IRIS_ASSERT( lpmi->cbSize == sizeof(MONITORINFO) || lpmi->cbSize == sizeof(MONITORINFOEXA) );
	return GetMonitorInfoA(m_hObject, lpmi);
#else
	return FALSE;
#endif
}
/// @ref GetInfo
BOOL CMonitor::GetInfoW(LPMONITORINFO lpmi) const
{
#if WINVER >= 0x0500
	IRIS_ASSERT( lpmi->cbSize == sizeof(MONITORINFO) || lpmi->cbSize == sizeof(MONITORINFOEXW) );
	return GetMonitorInfoW(m_hObject, lpmi);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * ̈̎擾
 *
 -----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
BOOL CMonitor::GetRect(LPRECT lprc) const
{
	IRIS_ASSERT(lprc != nullptr);
	MONITORINFO mi = {0};
	mi.cbSize = sizeof(MONITORINFO);
	if( !GetInfo(&mi) ) return FALSE;
	*lprc = mi.rcMonitor;
	return TRUE;
}

/**********************************************************************//**
 *
 * ̈̎擾
 *
 -----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
BOOL CMonitor::GetValidRect(LPRECT lprc) const
{
	IRIS_ASSERT(lprc != nullptr);
	MONITORINFO mi = {0};
	mi.cbSize = sizeof(MONITORINFO);
	if( !GetInfo(&mi) ) return FALSE;
	*lprc = mi.rcWork;
	return TRUE;
}

/**********************************************************************//**
 *
 * vC}j^[ǂ
 *
 -----------------------------------------------------------------------
 * @return ^Ul
*//***********************************************************************/
bool CMonitor::IsPrimary(void) const
{
	MONITORINFO mi = {0};
	mi.cbSize = sizeof(MONITORINFO);
	if( !GetInfo(&mi) ) return true;
	return mi.dwFlags != 0;
}

}	// end of namespace wx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "unit/UnitCore.h"
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXMonitor, Func)
{
	struct Proc
	{
		static BOOL CALLBACK EnumProc(HMONITOR hMonitor, HDC hdcMonitor, LPRECT lprcMonitor, LPARAM dwData)
		{
			IRIS_UNUSED_VAR(hdcMonitor);
			IRIS_UNUSED_VAR(lprcMonitor);
			IRIS_UNUSED_VAR(dwData);
			CMonitor mon = hMonitor;
			RECT rc;
			if( mon.GetRect(&rc) )
			{
				std::cout << rc.left << ", " << rc.top << ", " << rc.right << ", " << rc.bottom << std::endl;	
			}
			return TRUE;
		}
	};
	EnumDisplayMonitors(nullptr, nullptr, Proc::EnumProc, NULL);
}

#endif
