//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSetupDi.cpp
 * @brief		WXSetupDi t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010 t.sirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSetupDi_CPP_

//======================================================================
// include
#include "WXSetupDi.h"

#if	defined(_IRIS_SUPPORT_WDK)

#if	defined(_IRIS_SUPPORT_WDK)

//======================================================================
// link
#pragma comment(lib, "setupapi.lib")

#else

//======================================================================
// include
#include "../os/WXModule.h"

namespace
{

//======================================================================
// class
class CSetupApiDll : public iris::IIrisObject
{
public:
	iris::wx::CModule m_Module;
public:
	bool	Load(void)
	{
		if( m_Module.IsValid() ) return true;
		return IRIS_TO_bool(m_Module.Load(TEXT("setupapi.dll")));
	}
public:
	static	CHIDDLL&	GetInstance(void)	{ static CHIDDLL inst; return inst; }
};

}

#define PROC_LOAD(_ret, _name, _args, _err)			\
	typedef _ret (__stdcall *pfn##_name)##_args;	\
	static pfn##_name	pfnProc = nullptr;			\
	do {											\
	if( pfnProc == nullptr ) {						\
		CHIDDLL::GetInstance().Load();				\
		pfnProc = reinterpret_cast<pfn##_name>(CHIDDLL::GetInstance().m_Module.GetProcAddress(#_name));	\
		if( pfnProc == nullptr ) return _err;		\
	} } while(0)

//======================================================================
// function
typedef PVOID	HDEVINFO;

HDEVINFO SetupDiGetClassDevs(LPGUID ClassGuid, PCTSTR Enumerator
							 , HWND hwndParent, DWORD Flags)
{
	SETUP_PROC_LOAD(HDEVINFO, SetupDiGetClassDevs, (LPGUID ClassGuid, PCTSTR Enumerator
							 , HWND hwndParent, DWORD Flags), nullptr);
	return pfnProc(ClassGuid, Enumerator, hwndParent, Flags);
}

#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDevInfo::CDevInfo(void)
: m_DevInfo(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDevInfo::CDevInfo(HDEVINFO hDevinfo)
: m_DevInfo(nullptr)
{
	Attach(hDevinfo);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDevInfo::~CDevInfo(void)
{
	Close();
}

/**********************************************************************//**
 *
 * nh֘At
 *
 -----------------------------------------------------------------------
 * @param [in]	hDevInfo	= nh
 * @return	
*//***********************************************************************/
BOOL CDevInfo::Attach(HDEVINFO hDevInfo)
{
	if( hDevInfo == nullptr || m_DevInfo != nullptr ) return FALSE;
	m_DevInfo = hDevInfo;
	return TRUE;
}

/**********************************************************************//**
 *
 * nh֘At
 *
 -----------------------------------------------------------------------
 * @return	֘AtĂnh
*//***********************************************************************/
HDEVINFO CDevInfo::Detach(void)
{
	HDEVINFO hPre = m_DevInfo;
	m_DevInfo = nullptr;
	return hPre;
}

/**********************************************************************//**
 *
 * w肳ꂽNXɏ邷ׂẴfoCX܂܂Ă1̃foCXZbg擾
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CDevInfo::GetClassDevs (CONST GUID *ClassGuid, PCTSTR Enumerator, HWND hwndParent, DWORD Flags)
{
#ifdef UNICODE
	return GetClassDevsW(ClassGuid, Enumerator, hwndParent, Flags);
#else
	return GetClassDevsA(ClassGuid, Enumerator, hwndParent, Flags);
#endif
}
/// iris::wx::CDevInfo::GetClassDevs Q
BOOL CDevInfo::GetClassDevsA(CONST GUID *ClassGuid, PCSTR  Enumerator, HWND hwndParent, DWORD Flags)
{
	HDEVINFO devinfo = SetupDiGetClassDevsA(ClassGuid, Enumerator, hwndParent, Flags);
	if( devinfo == INVALID_HANDLE_VALUE ) return FALSE;
	if( !Attach(devinfo) )
	{
		SetupDiDestroyDeviceInfoList(devinfo);
		return FALSE;
	}
	return TRUE;
}
/// iris::wx::CDevInfo::GetClassDevs Q
BOOL CDevInfo::GetClassDevsW(CONST GUID *ClassGuid, PCWSTR Enumerator, HWND hwndParent, DWORD Flags) 
{
	HDEVINFO devinfo = SetupDiGetClassDevsW(ClassGuid, Enumerator, hwndParent, Flags);
	if( devinfo == INVALID_HANDLE_VALUE ) return FALSE;
	if( !Attach(devinfo) )
	{
		SetupDiDestroyDeviceInfoList(devinfo);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CDevInfo::Close(void)
{
	if( m_DevInfo == nullptr ) return TRUE;
	HDEVINFO hDevInfo = m_DevInfo;
	m_DevInfo = nullptr;
	return SetupDiDestroyDeviceInfoList(hDevInfo);
}

}	// end of namespace wx
}	// end of namespace iris

#endif
