//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRvlRemote.h
 * @brief		WXRvlRemote t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010 t.sirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXRvlRemote_H_
#define INCG_IRIS_WXRvlRemote_H_

//======================================================================
// include
#include "../WXHID.h"
#include "fnd/container/FndArray.h"
#include "fnd/container/FndBits.h"
#include "fnd/utility/FndFlag.h"

#if	defined(_IRIS_SUPPORT_WDK)

namespace iris {
namespace wx {
namespace rvl
{

//======================================================================
// struct
// R & k`N
typedef struct tagWPADFSStatus
{
	u16	button;
	s16 accX;
	s16 accY;
	s16 accZ;
	s8	fsStickX;
	s8	fsStickY;
	s16 fsAccX;
	s16 fsAccY;
	s16 fsAccZ;
} WPADFSStatus;

//======================================================================
// class
/// RNX
class CRvlRemote : protected CHID
{
public:
	enum
	{
		VENDOR_ID	= 0x057e,	//!< x_[ID
		PRODUCT_ID	= 0x0306,	//!< v_NgID
	};
	enum BATTERYLEVEL
	{
		BATTERYLEVEL_LOW	= 0,	//!< obe[cʍŏ
		BATTERYLEVEL_HIGH	= 200,	//!< obe[cʍő
	};
	enum STATUS
	{
		STATUS_BATTERY_LITTLE	= 0x01,		//!< obe[cʂ킸
		STATUS_CONNECT_EXCTRL	= 0x02,		//!< gRg[[̒E
		STATUS_SPEAKER			= 0x04,		//!< Xs[J[
		STATUS_IR_CAMERA		= 0x08,		//!< IR J
		STATUS_LED1				= 0x10,		//!< LED1
		STATUS_LED2				= 0x20,		//!< LED1
		STATUS_LED3				= 0x30,		//!< LED1
		STATUS_LED4				= 0x40,		//!< LED1
		STATUS_LED				= 0xF0,		//!< LED
	};
	enum BUTTONS
	{
		BUTTON_2		= (1<<0),	//!< 2
		BUTTON_1		= (1<<1),	//!< 1
		BUTTON_B		= (1<<2),	//!< B
		BUTTON_A		= (1<<3),	//!< A
		BUTTON_MINUS	= (1<<4),	//!< -
		BUTTON_HOME		= (1<<7),	//!< HOME
		BUTTON_LEFT		= (1<<8),	//!< 
		BUTTON_RIGHT	= (1<<9),	//!< E
		BUTTON_DOWN		= (1<<10),	//!< 
		BUTTON_UP		= (1<<11),	//!< 
		BUTTON_PLUS		= (1<<12),	//!< +
	};
	enum FORMAT
	{
		FMT_CORE				= 0x30,	//!< 
		FMT_FREESTYLE_ACC_DPD	= 0x37, //!< 
	};
	enum SPEAKER
	{
		FMT_4BIT_ADPCM		= 0x00,				//!< 4bit-ADPCM
		FMT_8BIT_PCM		= 0x40,				//!< 8bit-PCM
	};
protected:
	enum
	{
		FLAG_RUMBLE			= 0x00000001,		//!< UtO
	};

private:
	HIDP_CAPS		m_Caps;		//!< 
	fnd::CArray<u8>	m_Input;	//!< ̓obt@
	fnd::CArray<u8>	m_Output;	//!< o̓obt@

protected:
	s8				m_BatteryLevel;		//!< obe[cʃx
	fnd::CFlag		m_Flags;			//!< ݒtO
	fnd::CBits<u8>	m_Status;			//!< Xe[^X
	u16				m_Button;			//!< {^
	u8				m_Acc[3];			//!< x
	u8				m_IR[36];			//!< IR Camera
	u8				m_DataFormat;		//!< f[^tH[}bg

public:
	// ΏۃfoCXǂf
	static	bool	IsSpecifiedDevice(LPCTSTR lpDevicePath);

public:
	// RXgN^
	CRvlRemote(void);
	// fXgN^
	~CRvlRemote(void);
public:
	// 
	bool	Initialize(LPCTSTR lpDevicePath);

	// XV
	bool	Update(void);

	// Ԃ̍Ď擾
	bool	Reflesh(void);

public:
	// Xe[^X̎擾
	u8		GetStatus(void) const;

	// LED ̖
	bool	SetLED(u8 LedMask);
	// LED ̐ݒԎ擾
	u8		GetLED(void) const;

	// obe[cʂ킸ǂ
	bool	IsBatteryLittle(void) const;

	// U̐ݒ
	bool	SetRumble(bool rumble);
	// Uǂ
	bool	IsRumble(void) const;

	// Xs[J[ON/OFF
	bool	SetSpeaker(bool enable);
	// Xs[J[̃~[g
	bool	MuteSpeaker(bool enable);
	// Xs[J[̃f[^ݒ
	bool	SetSpeakerData(const u8* src, u8 size);
	// Xs[J[̐ݒ
	bool	SetSpeakerConfig(u8 fmt, u32 sampling_rate, f32 volume);

	// f[^tH[}bg̐ݒ
	bool	SetDataFormat(u8 format);

protected:
	// IR J̋N
	bool	EnableIRCamera(void);

protected:

	// ւ̏
	bool	WriteMemory(const u8* src, u32 offset, u8 size);
	// ̓ǂݍ
	bool	ReadMemory(u8* dst, u32 offset, u16 size);

	// WX^ւ̏
	bool	WriteRegister(const u8* src, u32 offset, u8 size);
	// WX^̓ǂݍ
	bool	ReadRegister(u8* dst, u32 offset, u16 size);

	//  or WX^ւ̏
	bool	WriteMemoryRegister(u8 memreg, const u8* src, u32 offset, u8 size);
	//  or WX^̓ǂݍ
	bool	ReadMemoryRegister(u8 memreg, u8* dst, u32 offset, u16 size);

protected:
	// Xe[^X̓ǂݎ薽ߔs
	bool	ReadStatus(void);
	// ̓ǂݍ & f
	bool	ReadCommand(void);

	// Xe[^X̓ǂݎ
	void	OnReadStatus(void);
protected:
	// ̏
	bool	Write(void);
	// ̓ǂݍ
	bool	Read(void);
};

}	// end of namespace rvl
}	// end of namespace wx
}	// end of namespace iris

#endif

#endif
