//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXScopedCursor.h
 * @brief		XR[vLJ[\NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXScopedCursor_H_
#define INCG_IRIS_WXScopedCursor_H_

//======================================================================
// include
#include "WXCursor.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
class CWaitCursor;

//======================================================================
// class
//! XR[vLJ[\NX
class CScopedCursor : public CCursor
{
	HCURSOR	m_hPreCursor;	//!< ȑÕJ[\
public:
	// RXgN^
	CScopedCursor(LPCTSTR lpCursorName)
	: m_hPreCursor(nullptr)
	{
		if( Load(nullptr, lpCursorName) )
			m_hPreCursor = ::SetCursor(GetHandle());
	}
	// fXgN^
	virtual ~CScopedCursor(void)
	{
		if( IsValid() )
			::SetCursor(m_hPreCursor);
	}
};

//! v\NX
class CWaitCursor : public CScopedCursor
{
public:
	// RXgN^
	CWaitCursor(void)
		: CScopedCursor(IDC_WAIT) {}
};


}	// end of namespace wx
}	// end of namespace iris

#endif
