//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXIMM.h
 * @brief		IMMNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXIMM_H_
#define INCG_IRIS_WXIMM_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! IMMNX
class CIMM : public INonCopyable<>
{
private:
	HIMC	m_hImc;		//!< imenh 
	HWND	m_hWnd;		//!< openƂ̃nh
	DWORD	m_dwThread;	//!< XbhID
public:
	// RXgN^
	CIMM(void);
	// fXgN^
	~CIMM(void);

public:
	HIMC	operator()(void)	{ return m_hImc; }
	HIMC	GetHIMC(void)		{ return m_hImc; }
	HKL		GetHKL(void)	const;
public:
	// J
	BOOL	Open(HWND hWnd);
	// 
	BOOL	Close(void);

	// 쐬
	BOOL	Create(void);
	// 폜
	BOOL	Destroy(void);

	// G[擾
	template<typename CHARTYPE_>
	DWORD	GetGuideLine(DWORD dwIndex, CHARTYPE_* lpBuffer, DWORD dwBufLen)	const;

public:
	// IME̊JԎ擾
	BOOL	GetOpenStatus(void)	const;
	// IME̊J
	BOOL	SetOpenStatus(BOOL Status);
	// ϊԂ擾
	BOOL	GetConversionStatus(LPDWORD lpdwCnversion, LPDWORD lpdwSentence)	const;
	// ϊԂݒ
	BOOL	SetConversionStatus(DWORD dwCnversion, DWORD dwSentence);
	// ܂͒P̕ϊʈꗗ擾
	template<typename CHARTYPE_>
	DWORD	GetConversionList(CHARTYPE_* lpSrc, LPCANDIDATELIST lpCandidateList, DWORD dwBufLen, UINT uFlag)	const;
	// ̓ReLXg̏Ԃ̕ύXɊւ IME ɒʒm
	BOOL	NotifyIME(DWORD dwAction, DWORD dwIndex, DWORD dwValue=0);

public:
	// ͒̕擾
	LONG	GetCompositionString (DWORD dwType, LPVOID lpBuffer, DWORD dwSize)	const;
	LONG	GetCompositionStringA(DWORD dwType, LPVOID lpBuffer, DWORD dwSize)	const;
	LONG	GetCompositionStringW(DWORD dwType, LPVOID lpBuffer, DWORD dwSize)	const;
	// ͒̕ݒ
	BOOL	SetCompositionString (DWORD dwIndex, LPVOID lpComp, DWORD dwCompLen, LPVOID lpRead, DWORD dwReadLen);
	BOOL	SetCompositionStringA(DWORD dwIndex, LPVOID lpComp, DWORD dwCompLen, LPVOID lpRead, DWORD dwReadLen);
	BOOL	SetCompositionStringW(DWORD dwIndex, LPVOID lpComp, DWORD dwCompLen, LPVOID lpRead, DWORD dwReadLen);

	// ϊEBhEł̃tHg擾
	template<typename TN>
	BOOL	GetCompositionFont(TN  lplf)	const;
	// ϊEBhEł̃tHgݒ
	template<typename TN>
	BOOL	SetCompositionFont(TN  lplf);

	// ϊEBhȄ擾
	BOOL	GetCompositionWindow(LPCOMPOSITIONFORM lpCompForm)	const;
	// ϊEBhȄݒ
	BOOL	SetCompositionWindow(LPCOMPOSITIONFORM lpCompForm);
	BOOL	SetCompositionWindow(DWORD dwStyle, LPPOINT ptCurrentPos, LPRECT rcArea);

public:
	// ꗗŜ̃obt@TCY擾
	DWORD	GetCandidateListCount (LPDWORD lpdwListCount)	const;
	DWORD	GetCandidateListCountA(LPDWORD lpdwListCount)	const;
	DWORD	GetCandidateListCountW(LPDWORD lpdwListCount)	const;

	// ꗗobt@ɃRs[
	DWORD	GetCandidateList (DWORD deIndex, LPCANDIDATELIST lpCandidateList, DWORD dwBufLen)	const;
	DWORD	GetCandidateListA(DWORD deIndex, LPCANDIDATELIST lpCandidateList, DWORD dwBufLen)	const;
	DWORD	GetCandidateListW(DWORD deIndex, LPCANDIDATELIST lpCandidateList, DWORD dwBufLen)	const;

	// ꗗEBhEɊւ擾
	BOOL	GetCandidateWindow(DWORD dwBufLen, LPCANDIDATEFORM lpCandidateForm)	const;
	// ꗗEBhEɊւݒ
	BOOL	SetCandidateWindow(LPCANDIDATEFORM lpCandidateForm);

public:
	// IME 镶擾
	template<typename CHARTYPE_>
	UINT	GetDescription(CHARTYPE_* lpString, UINT uLength)	const;

public:
	// Xe[^XEBhËʒu擾
	BOOL	GetStatusWindowPos(LPPOINT lppt)	const;
	// Xe[^XEBhËʒuݒ
	BOOL	SetStatusWindowPos(LPPOINT lppt);

public:
	// IME j[ɓo^Ă郁j[ڎ擾
	DWORD	GetImeMenuItems (DWORD dwFlags, DWORD dwType
							, LPIMEMENUITEMINFO  lpParentMenu, LPIMEMENUITEMINFO  lpMenu, DWORD dwSize)	const;
	DWORD	GetImeMenuItemsA(DWORD dwFlags, DWORD dwType
							, LPIMEMENUITEMINFOA lpParentMenu, LPIMEMENUITEMINFOA lpMenu, DWORD dwSize)	const;
	DWORD	GetImeMenuItemsW(DWORD dwFlags, DWORD dwType
							, LPIMEMENUITEMINFOW lpParentMenu, LPIMEMENUITEMINFOW lpMenu, DWORD dwSize)	const;
	// e IME ɌŗL̃Tu֐s
	LRESULT	Escape (UINT uEscape, LPVOID lpData);
	LRESULT	EscapeA(UINT uEscape, LPVOID lpData);
	LRESULT	EscapeW(UINT uEscape, LPVOID lpData);
	// IME̐ݒp_CAO{bNX̕\
	BOOL	ConfigureIME (HWND hWnd, DWORD dwMode, LPVOID lpData=nullptr);
	BOOL	ConfigureIMEA(HWND hWnd, DWORD dwMode, LPVOID lpData=nullptr);
	BOOL	ConfigureIMEW(HWND hWnd, DWORD dwMode, LPVOID lpData=nullptr);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
