//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindUrlCach.cpp
 * @brief		C^[lbgLbVnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFindUrlCach_CPP_

//======================================================================
// include
#include "WXFindUrlCach.h"

//======================================================================
#pragma comment ( lib, "wininet.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFindUrlCach::CFindUrlCach(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hCach		= ֘Atnh
*//***********************************************************************/
CFindUrlCach::CFindUrlCach(HANDLE hCach)
: CHandle(hCach)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFindUrlCach::~CFindUrlCach(void)
{
	Close();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CFindUrlCach::Close(void)
{
	return IRIS_TO_bool( FindCloseUrlCache(Detach()) );
}

/**********************************************************************//**
 *
 * LbVt@C폜
 *
 ----------------------------------------------------------------------
 * @param [in]	lpdwBufferSize			= 
 * @return	
*//***********************************************************************/
template<>
BOOL CFindUrlCach::Delete<CHAR>(LPCSTR lpszUrlName)
{
	return ::DeleteUrlCacheEntryA(lpszUrlName);
}
/// CFindUrlCach::Delete Q
template<>
BOOL CFindUrlCach::Delete<WCHAR>(LPCWSTR lpszUrlName)
{
	return ::DeleteUrlCacheEntryW(lpszUrlName);
}


/**********************************************************************//**
 *
 * LbV
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszUrlSearchPattern	= 
 * @param [in]	lpCacheEntry			= 
 * @param [in]	lpdwBufferSize			= 
 * @return	
*//***********************************************************************/
template<>
BOOL CFindUrlCach::FindFirst<CHAR>(LPCSTR  lpszUrlSearchPattern, LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize)
{
	HANDLE hObject = ::FindFirstUrlCacheEntryA(lpszUrlSearchPattern, lpCacheEntry, lpdwBufferSize);
	if( hObject == nullptr ) return FALSE;
	if( !Attach(hObject) )
	{
		FindCloseUrlCache(hObject);
		return FALSE;
	}
	return TRUE;
}
/// CFindUrlCach::FindFirst Q
template<>
BOOL CFindUrlCach::FindFirst<WCHAR>(LPCWSTR lpszUrlSearchPattern, LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize)
{
	HANDLE hObject = ::FindFirstUrlCacheEntryW(lpszUrlSearchPattern, lpCacheEntry, lpdwBufferSize);
	if( hObject == nullptr ) return FALSE;
	if( !Attach(hObject) )
	{
		FindCloseUrlCache(hObject);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @param [io]	lpCacheEntry			= 
 * @param [in]	lpdwBufferSize			= 
 * @return	
*//***********************************************************************/
template<>
BOOL CFindUrlCach::FindNext<LPINTERNET_CACHE_ENTRY_INFOA>(LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize)
{
	return ::FindNextUrlCacheEntryA(m_hObject, lpCacheEntry, lpdwBufferSize);
}
/// CFindUrlCach::FindNext Q
template<>
BOOL CFindUrlCach::FindNext<LPINTERNET_CACHE_ENTRY_INFOW>(LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize)
{
	return ::FindNextUrlCacheEntryW(m_hObject, lpCacheEntry, lpdwBufferSize);
}

/**********************************************************************//**
 *
 * LbV
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszUrlSearchPattern	= 
 * @param [in]	dwFlags					= 
 * @param [in]	dwFilter				= 
 * @param [in]	GroupId					= 
 * @param [in]	lpCacheEntry			= 
 * @param [in]	lpdwBufferSize			= 
 * @return	
*//***********************************************************************/
template<>
BOOL CFindUrlCach::FindFirstEx<CHAR>(LPCSTR  lpszUrlSearchPattern, DWORD dwFlags, DWORD dwFilter, GROUPID GroupId
							, LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize)
{
	HANDLE hObject = ::FindFirstUrlCacheEntryExA(lpszUrlSearchPattern, dwFlags, dwFilter, GroupId, lpCacheEntry, lpdwBufferSize
					, nullptr, nullptr, nullptr);
	if( hObject == nullptr ) return FALSE;
	if( !Attach(hObject) )
	{
		FindCloseUrlCache(hObject);
		return FALSE;
	}
	return TRUE;
}
/// CFindUrlCach::FindFirstEx Q
template<>
BOOL CFindUrlCach::FindFirstEx<WCHAR>(LPCWSTR lpszUrlSearchPattern, DWORD dwFlags, DWORD dwFilter, GROUPID GroupId
							, LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize)
{
	HANDLE hObject = ::FindFirstUrlCacheEntryExW(lpszUrlSearchPattern, dwFlags, dwFilter, GroupId, lpCacheEntry, lpdwBufferSize
					, nullptr, nullptr, nullptr);
	if( hObject == nullptr ) return FALSE;
	if( !Attach(hObject) )
	{
		FindCloseUrlCache(hObject);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @param [in]	lpCacheEntry			= 
 * @param [in]	lpdwBufferSize			= 
 * @return	
*//***********************************************************************/
template<>
BOOL CFindUrlCach::FindNextEx<LPINTERNET_CACHE_ENTRY_INFOA>(LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize)
{
	return ::FindNextUrlCacheEntryExA(m_hObject, lpCacheEntry, lpdwBufferSize
				, nullptr, nullptr, nullptr);
}
/// CFindUrlCach::FindNextEx Q
template<>
BOOL CFindUrlCach::FindNextEx<LPINTERNET_CACHE_ENTRY_INFOW>(LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize)
{
	return ::FindNextUrlCacheEntryExW(m_hObject, lpCacheEntry, lpdwBufferSize
				, nullptr, nullptr, nullptr);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "WXUrlCachEntryInfo.h"
#include "unit/UnitCore.h"
#include "iris_using.h"
#include "iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CWXUrlChachEntryInfoUnitTest, Func)
{
	CUrlCachEntryInfo<> cach;
	if( cach.FindFirstEx(nullptr, URLHISTORY_CACHE_ENTRY) )
	{
		do {
			std::tcout << IRIS_TEXT("{") << std::endl;
			std::tcout << IRIS_TEXT("\t") << cach.GetUrlName() << std::endl;
			std::tcout << IRIS_TEXT("\t") << cach.GetFilePath() << std::endl;
			std::tcout << IRIS_TEXT("}") << std::endl;
		} while(cach.FindNext());
	}

}

#endif
